# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

SURFACE_METRICS_METADATA = Metadata(
    id="1ef3c8a44dad85904fd6b95c168fae520751be00.boutiques",
    name="SurfaceMetrics",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


SurfaceMetricsParameters = typing.TypedDict('SurfaceMetricsParameters', {
    "__STYXTYPE__": typing.Literal["SurfaceMetrics"],
    "volume": bool,
    "convexity": bool,
    "closest_node": typing.NotRequired[InputPathType | None],
    "area": bool,
    "tri_sines": bool,
    "tri_cosines": bool,
    "tri_CoSines": bool,
    "tri_angles": bool,
    "node_angles": bool,
    "curvature": bool,
    "edges": bool,
    "node_normals": bool,
    "face_normals": bool,
    "normals_scale": typing.NotRequired[float | None],
    "coords": bool,
    "sph_coords": bool,
    "sph_coords_center": typing.NotRequired[list[float] | None],
    "boundary_nodes": bool,
    "boundary_triangles": bool,
    "internal_nodes": bool,
    "surf1": str,
    "tlrc": bool,
    "prefix": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "SurfaceMetrics": surface_metrics_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class SurfaceMetricsOutputs(typing.NamedTuple):
    """
    Output object returned when calling `surface_metrics(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def surface_metrics_params(
    surf1: str,
    volume: bool = False,
    convexity: bool = False,
    closest_node: InputPathType | None = None,
    area: bool = False,
    tri_sines: bool = False,
    tri_cosines: bool = False,
    tri_co_sines: bool = False,
    tri_angles: bool = False,
    node_angles: bool = False,
    curvature: bool = False,
    edges: bool = False,
    node_normals: bool = False,
    face_normals: bool = False,
    normals_scale: float | None = None,
    coords: bool = False,
    sph_coords: bool = False,
    sph_coords_center: list[float] | None = None,
    boundary_nodes: bool = False,
    boundary_triangles: bool = False,
    internal_nodes: bool = False,
    tlrc: bool = False,
    prefix: str | None = None,
) -> SurfaceMetricsParameters:
    """
    Build parameters.
    
    Args:
        surf1: Specifies the input surface.
        volume: Calculates the volume of a surface.
        convexity: Output surface convexity at each node.
        closest_node: Find the closest node to each XYZ triplet in XYZ_LIST.1D.
        area: Output area of each triangle.
        tri_sines: Output sine of angles at nodes forming triangles.
        tri_cosines: Output cosine of angles at nodes forming triangles.
        tri_co_sines: Output both cosines and sines of angles at nodes forming\
            triangles.
        tri_angles: Unsigned angles in radians of triangles.
        node_angles: Unsigned angles in radians at nodes of surface.
        curvature: Output curvature at each node.
        edges: Outputs info on each edge.
        node_normals: Outputs segments along node normals.
        face_normals: Outputs segments along triangle normals.
        normals_scale: Scale the normals by a given factor.
        coords: Output coordinates of each node after any transformation.
        sph_coords: Output spherical coordinates of each node.
        sph_coords_center: Shift each node by x y z before calculating\
            spherical coordinates.
        boundary_nodes: Output nodes that form a boundary of a surface.
        boundary_triangles: Output triangles that form a boundary of a surface.
        internal_nodes: Output nodes that are not a boundary.
        tlrc: Apply Talairach transform to surface.
        prefix: Use prefix for output files.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "SurfaceMetrics",
        "volume": volume,
        "convexity": convexity,
        "area": area,
        "tri_sines": tri_sines,
        "tri_cosines": tri_cosines,
        "tri_CoSines": tri_co_sines,
        "tri_angles": tri_angles,
        "node_angles": node_angles,
        "curvature": curvature,
        "edges": edges,
        "node_normals": node_normals,
        "face_normals": face_normals,
        "coords": coords,
        "sph_coords": sph_coords,
        "boundary_nodes": boundary_nodes,
        "boundary_triangles": boundary_triangles,
        "internal_nodes": internal_nodes,
        "surf1": surf1,
        "tlrc": tlrc,
    }
    if closest_node is not None:
        params["closest_node"] = closest_node
    if normals_scale is not None:
        params["normals_scale"] = normals_scale
    if sph_coords_center is not None:
        params["sph_coords_center"] = sph_coords_center
    if prefix is not None:
        params["prefix"] = prefix
    return params


def surface_metrics_cargs(
    params: SurfaceMetricsParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("SurfaceMetrics")
    if params.get("volume"):
        cargs.append("-vol")
    if params.get("convexity"):
        cargs.append("-conv")
    if params.get("closest_node") is not None:
        cargs.extend([
            "-closest_node",
            execution.input_file(params.get("closest_node"))
        ])
    if params.get("area"):
        cargs.append("-area")
    if params.get("tri_sines"):
        cargs.append("-tri_sines")
    if params.get("tri_cosines"):
        cargs.append("-tri_cosines")
    if params.get("tri_CoSines"):
        cargs.append("-tri_CoSines")
    if params.get("tri_angles"):
        cargs.append("-tri_angles")
    if params.get("node_angles"):
        cargs.append("-node_angles")
    if params.get("curvature"):
        cargs.append("-curv")
    if params.get("edges"):
        cargs.append("-edges")
    if params.get("node_normals"):
        cargs.append("-node_normals")
    if params.get("face_normals"):
        cargs.append("-face_normals")
    if params.get("normals_scale") is not None:
        cargs.extend([
            "-normals_scale",
            str(params.get("normals_scale"))
        ])
    if params.get("coords"):
        cargs.append("-coords")
    if params.get("sph_coords"):
        cargs.append("-sph_coords")
    if params.get("sph_coords_center") is not None:
        cargs.extend([
            "-sph_coords_center",
            *map(str, params.get("sph_coords_center"))
        ])
    if params.get("boundary_nodes"):
        cargs.append("-boundary_nodes")
    if params.get("boundary_triangles"):
        cargs.append("-boundary_triangles")
    if params.get("internal_nodes"):
        cargs.append("-internal_nodes")
    cargs.extend([
        "-SURF_1",
        params.get("surf1")
    ])
    if params.get("tlrc"):
        cargs.append("-tlrc")
    if params.get("prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix")
        ])
    return cargs


def surface_metrics_outputs(
    params: SurfaceMetricsParameters,
    execution: Execution,
) -> SurfaceMetricsOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = SurfaceMetricsOutputs(
        root=execution.output_file("."),
    )
    return ret


def surface_metrics_execute(
    params: SurfaceMetricsParameters,
    execution: Execution,
) -> SurfaceMetricsOutputs:
    """
    Outputs information about a surface's mesh.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `SurfaceMetricsOutputs`).
    """
    params = execution.params(params)
    cargs = surface_metrics_cargs(params, execution)
    ret = surface_metrics_outputs(params, execution)
    execution.run(cargs)
    return ret


def surface_metrics(
    surf1: str,
    volume: bool = False,
    convexity: bool = False,
    closest_node: InputPathType | None = None,
    area: bool = False,
    tri_sines: bool = False,
    tri_cosines: bool = False,
    tri_co_sines: bool = False,
    tri_angles: bool = False,
    node_angles: bool = False,
    curvature: bool = False,
    edges: bool = False,
    node_normals: bool = False,
    face_normals: bool = False,
    normals_scale: float | None = None,
    coords: bool = False,
    sph_coords: bool = False,
    sph_coords_center: list[float] | None = None,
    boundary_nodes: bool = False,
    boundary_triangles: bool = False,
    internal_nodes: bool = False,
    tlrc: bool = False,
    prefix: str | None = None,
    runner: Runner | None = None,
) -> SurfaceMetricsOutputs:
    """
    Outputs information about a surface's mesh.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        surf1: Specifies the input surface.
        volume: Calculates the volume of a surface.
        convexity: Output surface convexity at each node.
        closest_node: Find the closest node to each XYZ triplet in XYZ_LIST.1D.
        area: Output area of each triangle.
        tri_sines: Output sine of angles at nodes forming triangles.
        tri_cosines: Output cosine of angles at nodes forming triangles.
        tri_co_sines: Output both cosines and sines of angles at nodes forming\
            triangles.
        tri_angles: Unsigned angles in radians of triangles.
        node_angles: Unsigned angles in radians at nodes of surface.
        curvature: Output curvature at each node.
        edges: Outputs info on each edge.
        node_normals: Outputs segments along node normals.
        face_normals: Outputs segments along triangle normals.
        normals_scale: Scale the normals by a given factor.
        coords: Output coordinates of each node after any transformation.
        sph_coords: Output spherical coordinates of each node.
        sph_coords_center: Shift each node by x y z before calculating\
            spherical coordinates.
        boundary_nodes: Output nodes that form a boundary of a surface.
        boundary_triangles: Output triangles that form a boundary of a surface.
        internal_nodes: Output nodes that are not a boundary.
        tlrc: Apply Talairach transform to surface.
        prefix: Use prefix for output files.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SurfaceMetricsOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(SURFACE_METRICS_METADATA)
    params = surface_metrics_params(
        volume=volume,
        convexity=convexity,
        closest_node=closest_node,
        area=area,
        tri_sines=tri_sines,
        tri_cosines=tri_cosines,
        tri_co_sines=tri_co_sines,
        tri_angles=tri_angles,
        node_angles=node_angles,
        curvature=curvature,
        edges=edges,
        node_normals=node_normals,
        face_normals=face_normals,
        normals_scale=normals_scale,
        coords=coords,
        sph_coords=sph_coords,
        sph_coords_center=sph_coords_center,
        boundary_nodes=boundary_nodes,
        boundary_triangles=boundary_triangles,
        internal_nodes=internal_nodes,
        surf1=surf1,
        tlrc=tlrc,
        prefix=prefix,
    )
    return surface_metrics_execute(params, execution)


__all__ = [
    "SURFACE_METRICS_METADATA",
    "SurfaceMetricsOutputs",
    "SurfaceMetricsParameters",
    "surface_metrics",
    "surface_metrics_params",
]
