# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

UBER_PROC_PY_METADATA = Metadata(
    id="810164b90b5470d8a01aa9ff880068dc2dfc8cc0.boutiques",
    name="uber_proc.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


UberProcPyParameters = typing.TypedDict('UberProcPyParameters', {
    "__STYXTYPE__": typing.Literal["uber_proc.py"],
    "results_dir": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "uber_proc.py": uber_proc_py_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class UberProcPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `uber_proc_py(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def uber_proc_py_params(
    results_dir: str | None = None,
) -> UberProcPyParameters:
    """
    Build parameters.
    
    Args:
        results_dir: Directory where results will be placed. Default is a new\
            'uber_results' directory in the current working directory.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "uber_proc.py",
    }
    if results_dir is not None:
        params["results_dir"] = results_dir
    return params


def uber_proc_py_cargs(
    params: UberProcPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("uber_proc.py")
    if params.get("results_dir") is not None:
        cargs.append(params.get("results_dir"))
    return cargs


def uber_proc_py_outputs(
    params: UberProcPyParameters,
    execution: Execution,
) -> UberProcPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = UberProcPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def uber_proc_py_execute(
    params: UberProcPyParameters,
    execution: Execution,
) -> UberProcPyOutputs:
    """
    Uber processing tool - work in progress.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `UberProcPyOutputs`).
    """
    params = execution.params(params)
    cargs = uber_proc_py_cargs(params, execution)
    ret = uber_proc_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def uber_proc_py(
    results_dir: str | None = None,
    runner: Runner | None = None,
) -> UberProcPyOutputs:
    """
    Uber processing tool - work in progress.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        results_dir: Directory where results will be placed. Default is a new\
            'uber_results' directory in the current working directory.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `UberProcPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(UBER_PROC_PY_METADATA)
    params = uber_proc_py_params(
        results_dir=results_dir,
    )
    return uber_proc_py_execute(params, execution)


__all__ = [
    "UBER_PROC_PY_METADATA",
    "UberProcPyOutputs",
    "UberProcPyParameters",
    "uber_proc_py",
    "uber_proc_py_params",
]
