# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

UN_WARP_EPI_PY_METADATA = Metadata(
    id="fc0d8fa1e4c87d01b5598b608c709cf97544808c.boutiques",
    name="unWarpEPI.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


UnWarpEpiPyParameters = typing.TypedDict('UnWarpEpiPyParameters', {
    "__STYXTYPE__": typing.Literal["unWarpEPI.py"],
    "forward": InputPathType,
    "reverse": InputPathType,
    "anat4warp": InputPathType,
    "data": str,
    "subjID": str,
    "giant_move": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "unWarpEPI.py": un_warp_epi_py_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class UnWarpEpiPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `un_warp_epi_py(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def un_warp_epi_py_params(
    forward: InputPathType,
    reverse: InputPathType,
    anat4warp: InputPathType,
    data: str,
    subj_id: str,
    giant_move: bool = False,
) -> UnWarpEpiPyParameters:
    """
    Build parameters.
    
    Args:
        forward: Calibration matching data to be corrected.
        reverse: Calibration with opposing polarity to data to be corrected.
        anat4warp: Reference anatomical dataset.
        data: Data to be corrected (same polarity as forward calibration data).\
            Separate with commas if specifying multiple datasets.
        subj_id: ID of subject to be corrected.
        giant_move: Set giant_move option for align_epi_anat if final align of\
            anatomy to corrected EPI fails if datasets are far apart in space.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "unWarpEPI.py",
        "forward": forward,
        "reverse": reverse,
        "anat4warp": anat4warp,
        "data": data,
        "subjID": subj_id,
        "giant_move": giant_move,
    }
    return params


def un_warp_epi_py_cargs(
    params: UnWarpEpiPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("unWarpEPI.py")
    cargs.extend([
        "-f",
        execution.input_file(params.get("forward"))
    ])
    cargs.extend([
        "-r",
        execution.input_file(params.get("reverse"))
    ])
    cargs.extend([
        "-a",
        execution.input_file(params.get("anat4warp"))
    ])
    cargs.extend([
        "-d",
        params.get("data")
    ])
    cargs.extend([
        "-s",
        params.get("subjID")
    ])
    if params.get("giant_move"):
        cargs.append("-g")
    return cargs


def un_warp_epi_py_outputs(
    params: UnWarpEpiPyParameters,
    execution: Execution,
) -> UnWarpEpiPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = UnWarpEpiPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def un_warp_epi_py_execute(
    params: UnWarpEpiPyParameters,
    execution: Execution,
) -> UnWarpEpiPyOutputs:
    """
    Routine to unwarp EPI data set using another data set with opposite polarity.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `UnWarpEpiPyOutputs`).
    """
    params = execution.params(params)
    cargs = un_warp_epi_py_cargs(params, execution)
    ret = un_warp_epi_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def un_warp_epi_py(
    forward: InputPathType,
    reverse: InputPathType,
    anat4warp: InputPathType,
    data: str,
    subj_id: str,
    giant_move: bool = False,
    runner: Runner | None = None,
) -> UnWarpEpiPyOutputs:
    """
    Routine to unwarp EPI data set using another data set with opposite polarity.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        forward: Calibration matching data to be corrected.
        reverse: Calibration with opposing polarity to data to be corrected.
        anat4warp: Reference anatomical dataset.
        data: Data to be corrected (same polarity as forward calibration data).\
            Separate with commas if specifying multiple datasets.
        subj_id: ID of subject to be corrected.
        giant_move: Set giant_move option for align_epi_anat if final align of\
            anatomy to corrected EPI fails if datasets are far apart in space.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `UnWarpEpiPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(UN_WARP_EPI_PY_METADATA)
    params = un_warp_epi_py_params(
        forward=forward,
        reverse=reverse,
        anat4warp=anat4warp,
        data=data,
        subj_id=subj_id,
        giant_move=giant_move,
    )
    return un_warp_epi_py_execute(params, execution)


__all__ = [
    "UN_WARP_EPI_PY_METADATA",
    "UnWarpEpiPyOutputs",
    "UnWarpEpiPyParameters",
    "un_warp_epi_py",
    "un_warp_epi_py_params",
]
