# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1D_ASTRIP_METADATA = Metadata(
    id="2aea6d9a25067a9ea93b108537a720deaa6d64fe.boutiques",
    name="1dAstrip",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dAstripParameters = typing.TypedDict('V1dAstripParameters', {
    "__STYXTYPE__": typing.Literal["1dAstrip"],
    "infile": InputPathType,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "1dAstrip": v_1d_astrip_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "1dAstrip": v_1d_astrip_outputs,
    }.get(t)


class V1dAstripOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_1d_astrip(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    outfile: OutputPathType
    """Output file with only numeric characters."""


def v_1d_astrip_params(
    infile: InputPathType,
) -> V1dAstripParameters:
    """
    Build parameters.
    
    Args:
        infile: Input file from which non-numeric characters will be stripped.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "1dAstrip",
        "infile": infile,
    }
    return params


def v_1d_astrip_cargs(
    params: V1dAstripParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dAstrip")
    cargs.append("< " + execution.input_file(params.get("infile")))
    return cargs


def v_1d_astrip_outputs(
    params: V1dAstripParameters,
    execution: Execution,
) -> V1dAstripOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dAstripOutputs(
        root=execution.output_file("."),
        outfile=execution.output_file("[OUTPUT_FILE]"),
    )
    return ret


def v_1d_astrip_execute(
    params: V1dAstripParameters,
    execution: Execution,
) -> V1dAstripOutputs:
    """
    Strips non-numeric characters from a file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V1dAstripOutputs`).
    """
    params = execution.params(params)
    cargs = v_1d_astrip_cargs(params, execution)
    ret = v_1d_astrip_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1d_astrip(
    infile: InputPathType,
    runner: Runner | None = None,
) -> V1dAstripOutputs:
    """
    Strips non-numeric characters from a file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Input file from which non-numeric characters will be stripped.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dAstripOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1D_ASTRIP_METADATA)
    params = v_1d_astrip_params(
        infile=infile,
    )
    return v_1d_astrip_execute(params, execution)


__all__ = [
    "V1dAstripOutputs",
    "V1dAstripParameters",
    "V_1D_ASTRIP_METADATA",
    "v_1d_astrip",
    "v_1d_astrip_params",
]
