# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1DCAT_METADATA = Metadata(
    id="7a75008a7404e18d956b9ec2f61292d84973e4dc.boutiques",
    name="1dcat",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dcatParameters = typing.TypedDict('V1dcatParameters', {
    "__STYXTYPE__": typing.Literal["1dcat"],
    "input_files": list[InputPathType],
    "tsv_output": bool,
    "csv_output": bool,
    "nonconst_output": bool,
    "nonfixed_output": bool,
    "number_format": typing.NotRequired[str | None],
    "stack_output": bool,
    "column_row_selection": typing.NotRequired[str | None],
    "ok_empty": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "1dcat": v_1dcat_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "1dcat": v_1dcat_outputs,
    }.get(t)


class V1dcatOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_1dcat(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    concatenated_output: OutputPathType
    """Concatenated output in specified format"""


def v_1dcat_params(
    input_files: list[InputPathType],
    tsv_output: bool = False,
    csv_output: bool = False,
    nonconst_output: bool = False,
    nonfixed_output: bool = False,
    number_format: str | None = None,
    stack_output: bool = False,
    column_row_selection: str | None = None,
    ok_empty: bool = False,
) -> V1dcatParameters:
    """
    Build parameters.
    
    Args:
        input_files: Input 1D or TSV/CSV files to concatenate.
        tsv_output: Output in TSV format with tabs as separators and a header\
            line.
        csv_output: Output in CSV format with commas as separators and a header\
            line.
        nonconst_output: Omit columns that are identically constant from the\
            output.
        nonfixed_output: Keep only columns marked as 'free' in the 3dAllineate\
            header.
        number_format: Specify the format of the numbers to be output.
        stack_output: Stack the columns of the resulting matrix in the output.
        column_row_selection: Apply the same column/row selection string to all\
            filenames on the command line.
        ok_empty: Exit quietly when encountering an empty file on disk.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "1dcat",
        "input_files": input_files,
        "tsv_output": tsv_output,
        "csv_output": csv_output,
        "nonconst_output": nonconst_output,
        "nonfixed_output": nonfixed_output,
        "stack_output": stack_output,
        "ok_empty": ok_empty,
    }
    if number_format is not None:
        params["number_format"] = number_format
    if column_row_selection is not None:
        params["column_row_selection"] = column_row_selection
    return params


def v_1dcat_cargs(
    params: V1dcatParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dcat")
    cargs.extend([execution.input_file(f) for f in params.get("input_files")])
    if params.get("tsv_output"):
        cargs.append("-tsvout")
    if params.get("csv_output"):
        cargs.append("-csvout")
    if params.get("nonconst_output"):
        cargs.append("-nonconst")
    if params.get("nonfixed_output"):
        cargs.append("-nonfixed")
    if params.get("number_format") is not None:
        cargs.extend([
            "-form",
            params.get("number_format")
        ])
    if params.get("stack_output"):
        cargs.append("-stack")
    if params.get("column_row_selection") is not None:
        cargs.extend([
            "-sel",
            params.get("column_row_selection")
        ])
    if params.get("ok_empty"):
        cargs.append("-OKempty")
    return cargs


def v_1dcat_outputs(
    params: V1dcatParameters,
    execution: Execution,
) -> V1dcatOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dcatOutputs(
        root=execution.output_file("."),
        concatenated_output=execution.output_file("stdout"),
    )
    return ret


def v_1dcat_execute(
    params: V1dcatParameters,
    execution: Execution,
) -> V1dcatOutputs:
    """
    Concatenates columns of multiple 1D or TSV/CSV files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V1dcatOutputs`).
    """
    params = execution.params(params)
    cargs = v_1dcat_cargs(params, execution)
    ret = v_1dcat_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1dcat(
    input_files: list[InputPathType],
    tsv_output: bool = False,
    csv_output: bool = False,
    nonconst_output: bool = False,
    nonfixed_output: bool = False,
    number_format: str | None = None,
    stack_output: bool = False,
    column_row_selection: str | None = None,
    ok_empty: bool = False,
    runner: Runner | None = None,
) -> V1dcatOutputs:
    """
    Concatenates columns of multiple 1D or TSV/CSV files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input 1D or TSV/CSV files to concatenate.
        tsv_output: Output in TSV format with tabs as separators and a header\
            line.
        csv_output: Output in CSV format with commas as separators and a header\
            line.
        nonconst_output: Omit columns that are identically constant from the\
            output.
        nonfixed_output: Keep only columns marked as 'free' in the 3dAllineate\
            header.
        number_format: Specify the format of the numbers to be output.
        stack_output: Stack the columns of the resulting matrix in the output.
        column_row_selection: Apply the same column/row selection string to all\
            filenames on the command line.
        ok_empty: Exit quietly when encountering an empty file on disk.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dcatOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1DCAT_METADATA)
    params = v_1dcat_params(
        input_files=input_files,
        tsv_output=tsv_output,
        csv_output=csv_output,
        nonconst_output=nonconst_output,
        nonfixed_output=nonfixed_output,
        number_format=number_format,
        stack_output=stack_output,
        column_row_selection=column_row_selection,
        ok_empty=ok_empty,
    )
    return v_1dcat_execute(params, execution)


__all__ = [
    "V1dcatOutputs",
    "V1dcatParameters",
    "V_1DCAT_METADATA",
    "v_1dcat",
    "v_1dcat_params",
]
