# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1DDOT_METADATA = Metadata(
    id="78349c7b966df3a5026a4b202c3de358faef8d17.boutiques",
    name="1ddot",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1ddotParameters = typing.TypedDict('V1ddotParameters', {
    "__STYXTYPE__": typing.Literal["1ddot"],
    "one_flag": bool,
    "dem_flag": bool,
    "cov_flag": bool,
    "inn_flag": bool,
    "rank_flag": bool,
    "terse_flag": bool,
    "okzero_flag": bool,
    "input_files": list[InputPathType],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "1ddot": v_1ddot_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "1ddot": v_1ddot_outputs,
    }.get(t)


class V1ddotOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_1ddot(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    stdout: list[str]
    """output text file"""
    stdout_output: OutputPathType
    """Output correlation or covariance matrix printed to stdout."""


def v_1ddot_params(
    input_files: list[InputPathType],
    one_flag: bool = False,
    dem_flag: bool = False,
    cov_flag: bool = False,
    inn_flag: bool = False,
    rank_flag: bool = False,
    terse_flag: bool = False,
    okzero_flag: bool = False,
) -> V1ddotParameters:
    """
    Build parameters.
    
    Args:
        input_files: Input 1D files.
        one_flag: Make 1st vector be all 1's.
        dem_flag: Remove mean from all vectors (conflicts with '-one').
        cov_flag: Compute with covariance matrix instead of correlation.
        inn_flag: Compute with inner product matrix instead.
        rank_flag: Compute Spearman rank correlation instead (also implies\
            '-terse').
        terse_flag: Output only the correlation or covariance matrix without\
            any garnish.
        okzero_flag: Do not quit if a vector is all zeros. The correlation\
            matrix will have 0 where NaNs ought to go.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "1ddot",
        "one_flag": one_flag,
        "dem_flag": dem_flag,
        "cov_flag": cov_flag,
        "inn_flag": inn_flag,
        "rank_flag": rank_flag,
        "terse_flag": terse_flag,
        "okzero_flag": okzero_flag,
        "input_files": input_files,
    }
    return params


def v_1ddot_cargs(
    params: V1ddotParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1ddot")
    if params.get("one_flag"):
        cargs.append("-one")
    if params.get("dem_flag"):
        cargs.append("-dem")
    if params.get("cov_flag"):
        cargs.append("-cov")
    if params.get("inn_flag"):
        cargs.append("-inn")
    if params.get("rank_flag"):
        cargs.append("-rank")
    if params.get("terse_flag"):
        cargs.append("-terse")
    if params.get("okzero_flag"):
        cargs.append("-okzero")
    cargs.extend([execution.input_file(f) for f in params.get("input_files")])
    return cargs


def v_1ddot_outputs(
    params: V1ddotParameters,
    execution: Execution,
) -> V1ddotOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1ddotOutputs(
        root=execution.output_file("."),
        stdout=[],
        stdout_output=execution.output_file("stdout.txt"),
    )
    return ret


def v_1ddot_execute(
    params: V1ddotParameters,
    execution: Execution,
) -> V1ddotOutputs:
    """
    Computes the correlation matrix of the input 1D files and their inverse
    correlation matrix.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V1ddotOutputs`).
    """
    params = execution.params(params)
    cargs = v_1ddot_cargs(params, execution)
    ret = v_1ddot_outputs(params, execution)
    execution.run(cargs, handle_stdout=lambda s: ret.stdout.append(s))
    return ret


def v_1ddot(
    input_files: list[InputPathType],
    one_flag: bool = False,
    dem_flag: bool = False,
    cov_flag: bool = False,
    inn_flag: bool = False,
    rank_flag: bool = False,
    terse_flag: bool = False,
    okzero_flag: bool = False,
    runner: Runner | None = None,
) -> V1ddotOutputs:
    """
    Computes the correlation matrix of the input 1D files and their inverse
    correlation matrix.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input 1D files.
        one_flag: Make 1st vector be all 1's.
        dem_flag: Remove mean from all vectors (conflicts with '-one').
        cov_flag: Compute with covariance matrix instead of correlation.
        inn_flag: Compute with inner product matrix instead.
        rank_flag: Compute Spearman rank correlation instead (also implies\
            '-terse').
        terse_flag: Output only the correlation or covariance matrix without\
            any garnish.
        okzero_flag: Do not quit if a vector is all zeros. The correlation\
            matrix will have 0 where NaNs ought to go.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1ddotOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1DDOT_METADATA)
    params = v_1ddot_params(
        one_flag=one_flag,
        dem_flag=dem_flag,
        cov_flag=cov_flag,
        inn_flag=inn_flag,
        rank_flag=rank_flag,
        terse_flag=terse_flag,
        okzero_flag=okzero_flag,
        input_files=input_files,
    )
    return v_1ddot_execute(params, execution)


__all__ = [
    "V1ddotOutputs",
    "V1ddotParameters",
    "V_1DDOT_METADATA",
    "v_1ddot",
    "v_1ddot_params",
]
