# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1DFFT_METADATA = Metadata(
    id="1b564754f8ff373ff1545761e4e2740ba1cf898f.boutiques",
    name="1dfft",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dfftParameters = typing.TypedDict('V1dfftParameters', {
    "__STYXTYPE__": typing.Literal["1dfft"],
    "infile": InputPathType,
    "outfile": str,
    "ignore": typing.NotRequired[float | None],
    "use": typing.NotRequired[float | None],
    "nfft": typing.NotRequired[float | None],
    "tocx": bool,
    "fromcx": bool,
    "hilbert": bool,
    "nodetrend": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "1dfft": v_1dfft_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "1dfft": v_1dfft_outputs,
    }.get(t)


class V1dfftOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_1dfft(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_fft: OutputPathType
    """Output file with the absolute value of the FFT of the input columns."""


def v_1dfft_params(
    infile: InputPathType,
    outfile: str,
    ignore: float | None = None,
    use: float | None = None,
    nfft: float | None = None,
    tocx: bool = False,
    fromcx: bool = False,
    hilbert: bool = False,
    nodetrend: bool = False,
) -> V1dfftParameters:
    """
    Build parameters.
    
    Args:
        infile: Input .1D file containing an ASCII list of numbers arranged in\
            columns.
        outfile: Output file to store the FFT results.
        ignore: Skip the first 'sss' lines in the input file. [default = no\
            skipping].
        use: Use only 'uuu' lines of the input file. [default = use them all].
        nfft: Set FFT length to 'nnn'. [default = length of data (# of lines\
            used)].
        tocx: Save Re and Im parts of transform in 2 columns.
        fromcx: Convert 2 column complex input into 1 column real output. Note:\
            This will not work if the original data FFT length was an odd number.
        hilbert: When -fromcx is used, the inverse FFT will do the Hilbert\
            transform instead.
        nodetrend: Skip the detrending of the input.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "1dfft",
        "infile": infile,
        "outfile": outfile,
        "tocx": tocx,
        "fromcx": fromcx,
        "hilbert": hilbert,
        "nodetrend": nodetrend,
    }
    if ignore is not None:
        params["ignore"] = ignore
    if use is not None:
        params["use"] = use
    if nfft is not None:
        params["nfft"] = nfft
    return params


def v_1dfft_cargs(
    params: V1dfftParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dfft")
    cargs.append(execution.input_file(params.get("infile")))
    cargs.append(params.get("outfile"))
    if params.get("ignore") is not None:
        cargs.extend([
            "-ignore",
            str(params.get("ignore"))
        ])
    if params.get("use") is not None:
        cargs.extend([
            "-use",
            str(params.get("use"))
        ])
    if params.get("nfft") is not None:
        cargs.extend([
            "-nfft",
            str(params.get("nfft"))
        ])
    if params.get("tocx"):
        cargs.append("-tocx")
    if params.get("fromcx"):
        cargs.append("-fromcx")
    if params.get("hilbert"):
        cargs.append("-hilbert")
    if params.get("nodetrend"):
        cargs.append("-nodetrend")
    return cargs


def v_1dfft_outputs(
    params: V1dfftParameters,
    execution: Execution,
) -> V1dfftOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dfftOutputs(
        root=execution.output_file("."),
        out_fft=execution.output_file(params.get("outfile")),
    )
    return ret


def v_1dfft_execute(
    params: V1dfftParameters,
    execution: Execution,
) -> V1dfftOutputs:
    """
    Compute the absolute value of the FFT of input columns from an AFNI 1D file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V1dfftOutputs`).
    """
    params = execution.params(params)
    cargs = v_1dfft_cargs(params, execution)
    ret = v_1dfft_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1dfft(
    infile: InputPathType,
    outfile: str,
    ignore: float | None = None,
    use: float | None = None,
    nfft: float | None = None,
    tocx: bool = False,
    fromcx: bool = False,
    hilbert: bool = False,
    nodetrend: bool = False,
    runner: Runner | None = None,
) -> V1dfftOutputs:
    """
    Compute the absolute value of the FFT of input columns from an AFNI 1D file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Input .1D file containing an ASCII list of numbers arranged in\
            columns.
        outfile: Output file to store the FFT results.
        ignore: Skip the first 'sss' lines in the input file. [default = no\
            skipping].
        use: Use only 'uuu' lines of the input file. [default = use them all].
        nfft: Set FFT length to 'nnn'. [default = length of data (# of lines\
            used)].
        tocx: Save Re and Im parts of transform in 2 columns.
        fromcx: Convert 2 column complex input into 1 column real output. Note:\
            This will not work if the original data FFT length was an odd number.
        hilbert: When -fromcx is used, the inverse FFT will do the Hilbert\
            transform instead.
        nodetrend: Skip the detrending of the input.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dfftOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1DFFT_METADATA)
    params = v_1dfft_params(
        infile=infile,
        outfile=outfile,
        ignore=ignore,
        use=use,
        nfft=nfft,
        tocx=tocx,
        fromcx=fromcx,
        hilbert=hilbert,
        nodetrend=nodetrend,
    )
    return v_1dfft_execute(params, execution)


__all__ = [
    "V1dfftOutputs",
    "V1dfftParameters",
    "V_1DFFT_METADATA",
    "v_1dfft",
    "v_1dfft_params",
]
