# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1DGRAYPLOT_METADATA = Metadata(
    id="19cd85a5a31be03ff742d13e871815986799cf05.boutiques",
    name="1dgrayplot",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dgrayplotParameters = typing.TypedDict('V1dgrayplotParameters', {
    "__STYXTYPE__": typing.Literal["1dgrayplot"],
    "tsfile": InputPathType,
    "install": bool,
    "ignore": typing.NotRequired[float | None],
    "flip": bool,
    "sep": bool,
    "use": typing.NotRequired[float | None],
    "ps": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "1dgrayplot": v_1dgrayplot_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class V1dgrayplotOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_1dgrayplot(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_1dgrayplot_params(
    tsfile: InputPathType,
    install: bool = False,
    ignore: float | None = None,
    flip: bool = False,
    sep: bool = False,
    use: float | None = None,
    ps: bool = False,
) -> V1dgrayplotParameters:
    """
    Build parameters.
    
    Args:
        tsfile: Input time series file (*.1D format).
        install: Install a new X11 colormap (for X11 PseudoColor).
        ignore: Skip first 'nn' rows in the input file [default = 0].
        flip: Plot x and y axes interchanged [default: data columns plotted\
            DOWN the screen].
        sep: Separate scales for each column.
        use: Plot 'mm' points [default: all of them].
        ps: Don't draw plot in a window; write it to stdout in PostScript\
            format.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "1dgrayplot",
        "tsfile": tsfile,
        "install": install,
        "flip": flip,
        "sep": sep,
        "ps": ps,
    }
    if ignore is not None:
        params["ignore"] = ignore
    if use is not None:
        params["use"] = use
    return params


def v_1dgrayplot_cargs(
    params: V1dgrayplotParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dgrayplot")
    cargs.append(execution.input_file(params.get("tsfile")))
    if params.get("install"):
        cargs.append("-install")
    if params.get("ignore") is not None:
        cargs.extend([
            "-ignore",
            str(params.get("ignore"))
        ])
    if params.get("flip"):
        cargs.append("-flip")
    if params.get("sep"):
        cargs.append("-sep")
    if params.get("use") is not None:
        cargs.extend([
            "-use",
            str(params.get("use"))
        ])
    if params.get("ps"):
        cargs.append("-ps")
    return cargs


def v_1dgrayplot_outputs(
    params: V1dgrayplotParameters,
    execution: Execution,
) -> V1dgrayplotOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dgrayplotOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_1dgrayplot_execute(
    params: V1dgrayplotParameters,
    execution: Execution,
) -> V1dgrayplotOutputs:
    """
    Graphs the columns of a *.1D type time series file to the screen in grayscale.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V1dgrayplotOutputs`).
    """
    params = execution.params(params)
    cargs = v_1dgrayplot_cargs(params, execution)
    ret = v_1dgrayplot_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1dgrayplot(
    tsfile: InputPathType,
    install: bool = False,
    ignore: float | None = None,
    flip: bool = False,
    sep: bool = False,
    use: float | None = None,
    ps: bool = False,
    runner: Runner | None = None,
) -> V1dgrayplotOutputs:
    """
    Graphs the columns of a *.1D type time series file to the screen in grayscale.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        tsfile: Input time series file (*.1D format).
        install: Install a new X11 colormap (for X11 PseudoColor).
        ignore: Skip first 'nn' rows in the input file [default = 0].
        flip: Plot x and y axes interchanged [default: data columns plotted\
            DOWN the screen].
        sep: Separate scales for each column.
        use: Plot 'mm' points [default: all of them].
        ps: Don't draw plot in a window; write it to stdout in PostScript\
            format.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dgrayplotOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1DGRAYPLOT_METADATA)
    params = v_1dgrayplot_params(
        tsfile=tsfile,
        install=install,
        ignore=ignore,
        flip=flip,
        sep=sep,
        use=use,
        ps=ps,
    )
    return v_1dgrayplot_execute(params, execution)


__all__ = [
    "V1dgrayplotOutputs",
    "V1dgrayplotParameters",
    "V_1DGRAYPLOT_METADATA",
    "v_1dgrayplot",
    "v_1dgrayplot_params",
]
