# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_1DPLOT_PY_METADATA = Metadata(
    id="1d4b51ffb97efd0a7d1029f51fabf9626d9f1906.boutiques",
    name="1dplot.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dplotPyParameters = typing.TypedDict('V1dplotPyParameters', {
    "__STYXTYPE__": typing.Literal["1dplot.py"],
    "infiles": list[InputPathType],
    "prefix": str,
    "help": bool,
    "boxplot_on": bool,
    "bplot_view": typing.NotRequired[str | None],
    "margin_off": bool,
    "scale": typing.NotRequired[list[str] | None],
    "xfile": typing.NotRequired[InputPathType | None],
    "xvals": typing.NotRequired[list[float] | None],
    "yaxis": typing.NotRequired[list[str] | None],
    "ylabels": typing.NotRequired[list[str] | None],
    "ylabels_maxlen": typing.NotRequired[float | None],
    "legend_on": bool,
    "legend_labels": typing.NotRequired[list[str] | None],
    "legend_locs": typing.NotRequired[list[str] | None],
    "xlabel": typing.NotRequired[str | None],
    "title": typing.NotRequired[str | None],
    "reverse_order": bool,
    "sepscl": bool,
    "one_graph": bool,
    "dpi": typing.NotRequired[float | None],
    "figsize": typing.NotRequired[list[float] | None],
    "fontsize": typing.NotRequired[float | None],
    "fontfamily": typing.NotRequired[str | None],
    "fontstyles": typing.NotRequired[str | None],
    "colors": typing.NotRequired[list[str] | None],
    "patches": typing.NotRequired[list[str] | None],
    "censor_trs": typing.NotRequired[list[str] | None],
    "censor_files": typing.NotRequired[list[InputPathType] | None],
    "censor_hline": typing.NotRequired[list[str] | None],
    "censor_rgb": typing.NotRequired[str | None],
    "bkgd_color": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "1dplot.py": v_1dplot_py_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "1dplot.py": v_1dplot_py_outputs,
    }.get(t)


class V1dplotPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_1dplot_py(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_image: OutputPathType
    """Output image file, default to .jpg"""


def v_1dplot_py_params(
    infiles: list[InputPathType],
    prefix: str,
    help_: bool = False,
    boxplot_on: bool = False,
    bplot_view: str | None = None,
    margin_off: bool = False,
    scale: list[str] | None = None,
    xfile: InputPathType | None = None,
    xvals: list[float] | None = None,
    yaxis: list[str] | None = None,
    ylabels: list[str] | None = None,
    ylabels_maxlen: float | None = None,
    legend_on: bool = False,
    legend_labels: list[str] | None = None,
    legend_locs: list[str] | None = None,
    xlabel: str | None = None,
    title: str | None = None,
    reverse_order: bool = False,
    sepscl: bool = False,
    one_graph: bool = False,
    dpi: float | None = None,
    figsize: list[float] | None = None,
    fontsize: float | None = None,
    fontfamily: str | None = None,
    fontstyles: str | None = None,
    colors: list[str] | None = None,
    patches: list[str] | None = None,
    censor_trs: list[str] | None = None,
    censor_files: list[InputPathType] | None = None,
    censor_hline: list[str] | None = None,
    censor_rgb: str | None = None,
    bkgd_color: str | None = None,
) -> V1dplotPyParameters:
    """
    Build parameters.
    
    Args:
        infiles: One or more file names of text files. Each column in this file\
            will be treated as a separate time series for plotting.
        prefix: Output filename or prefix. Default output image type is .jpg.
        help_: See helpfile.
        boxplot_on: A fun feature to show an additional boxplot adjacent to\
            each time series.
        bplot_view: Adjust view for boxplots when using censoring.
        margin_off: Fill the plot frame completely, thus no labels, frame, or\
            titles will be visible.
        scale: Provide a list of scales to apply to the y-values.
        xfile: One way to input x-values explicitly: as a "1D" file containing\
            a single file of numbers.
        xvals: Provide exactly 3 numbers for x-values: start, stop, and\
            stepsize.
        yaxis: Optional range for each 'infile' y-axis.
        ylabels: Optional text labels for each 'infile' column.
        ylabels_maxlen: allows y-axis labels to wrap into multiple rows, each\
            of length <= which the user can decide.
        legend_on: Turn on the plotting of a legend in the plot(s).
        legend_labels: Optional legend labels, if using '-legend_on'.
        legend_locs: Optional legend locations, if using '-legend_on'.
        xlabel: Optional text labels for the abscissa/x-axis.
        title: Optional title for the set of plots.
        reverse_order: Reverses the order of plotted time series.
        sepscl: Make each graph have its own y-range.
        one_graph: Plot multiple infiles in a single subplot.
        dpi: Choose the output image's DPI. Default value is 150.
        figsize: Choose the output image's dimensions (units are inches).
        fontsize: Change image fontsize; default is 10.
        fontfamily: Change font-family used; default is monospace.
        fontstyles: Add a specific font name; should match with chosen\
            font-family.
        colors: Decide what color(s) to cycle through in plots (one or more).
        patches: Specify run lengths for background patches to distinguish runs.
        censor_trs: Specify time points where censoring has occurred using AFNI\
            index notation.
        censor_files: Specify time points where censoring has occurred using\
            one or more 1D files.
        censor_hline: Add a dotted horizontal line to the plot, representing\
            the censor threshold.
        censor_rgb: Choose the color of the censoring background; default is:\
            [1, 0.7, 0.7].
        bkgd_color: Change the background color outside of the plot windows.\
            Default is 0.9.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "1dplot.py",
        "infiles": infiles,
        "prefix": prefix,
        "help": help_,
        "boxplot_on": boxplot_on,
        "margin_off": margin_off,
        "legend_on": legend_on,
        "reverse_order": reverse_order,
        "sepscl": sepscl,
        "one_graph": one_graph,
    }
    if bplot_view is not None:
        params["bplot_view"] = bplot_view
    if scale is not None:
        params["scale"] = scale
    if xfile is not None:
        params["xfile"] = xfile
    if xvals is not None:
        params["xvals"] = xvals
    if yaxis is not None:
        params["yaxis"] = yaxis
    if ylabels is not None:
        params["ylabels"] = ylabels
    if ylabels_maxlen is not None:
        params["ylabels_maxlen"] = ylabels_maxlen
    if legend_labels is not None:
        params["legend_labels"] = legend_labels
    if legend_locs is not None:
        params["legend_locs"] = legend_locs
    if xlabel is not None:
        params["xlabel"] = xlabel
    if title is not None:
        params["title"] = title
    if dpi is not None:
        params["dpi"] = dpi
    if figsize is not None:
        params["figsize"] = figsize
    if fontsize is not None:
        params["fontsize"] = fontsize
    if fontfamily is not None:
        params["fontfamily"] = fontfamily
    if fontstyles is not None:
        params["fontstyles"] = fontstyles
    if colors is not None:
        params["colors"] = colors
    if patches is not None:
        params["patches"] = patches
    if censor_trs is not None:
        params["censor_trs"] = censor_trs
    if censor_files is not None:
        params["censor_files"] = censor_files
    if censor_hline is not None:
        params["censor_hline"] = censor_hline
    if censor_rgb is not None:
        params["censor_rgb"] = censor_rgb
    if bkgd_color is not None:
        params["bkgd_color"] = bkgd_color
    return params


def v_1dplot_py_cargs(
    params: V1dplotPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("1dplot.py")
    cargs.extend([
        "-infiles",
        *[execution.input_file(f) for f in params.get("infiles")]
    ])
    cargs.extend([
        "-prefix",
        params.get("prefix")
    ])
    if params.get("help"):
        cargs.append("-h")
    if params.get("boxplot_on"):
        cargs.append("-boxplot_on")
    if params.get("bplot_view") is not None:
        cargs.extend([
            "-bplot_view",
            params.get("bplot_view")
        ])
    if params.get("margin_off"):
        cargs.append("-margin_off")
    if params.get("scale") is not None:
        cargs.extend([
            "-scale",
            *params.get("scale")
        ])
    if params.get("xfile") is not None:
        cargs.extend([
            "-xfile",
            execution.input_file(params.get("xfile"))
        ])
    if params.get("xvals") is not None:
        cargs.extend([
            "-xvals",
            *map(str, params.get("xvals"))
        ])
    if params.get("yaxis") is not None:
        cargs.extend([
            "-yaxis",
            *params.get("yaxis")
        ])
    if params.get("ylabels") is not None:
        cargs.extend([
            "-ylabels",
            *params.get("ylabels")
        ])
    if params.get("ylabels_maxlen") is not None:
        cargs.extend([
            "-ylabels_maxlen",
            str(params.get("ylabels_maxlen"))
        ])
    if params.get("legend_on"):
        cargs.append("-legend_on")
    if params.get("legend_labels") is not None:
        cargs.extend([
            "-legend_labels",
            *params.get("legend_labels")
        ])
    if params.get("legend_locs") is not None:
        cargs.extend([
            "-legend_locs",
            *params.get("legend_locs")
        ])
    if params.get("xlabel") is not None:
        cargs.extend([
            "-xlabel",
            params.get("xlabel")
        ])
    if params.get("title") is not None:
        cargs.extend([
            "-title",
            params.get("title")
        ])
    if params.get("reverse_order"):
        cargs.append("-reverse_order")
    if params.get("sepscl"):
        cargs.append("-sepscl")
    if params.get("one_graph"):
        cargs.append("-one_graph")
    if params.get("dpi") is not None:
        cargs.extend([
            "-dpi",
            str(params.get("dpi"))
        ])
    if params.get("figsize") is not None:
        cargs.extend([
            "-figsize",
            *map(str, params.get("figsize"))
        ])
    if params.get("fontsize") is not None:
        cargs.extend([
            "-fontsize",
            str(params.get("fontsize"))
        ])
    if params.get("fontfamily") is not None:
        cargs.extend([
            "-fontfamily",
            params.get("fontfamily")
        ])
    if params.get("fontstyles") is not None:
        cargs.extend([
            "-fontstyles",
            params.get("fontstyles")
        ])
    if params.get("colors") is not None:
        cargs.extend([
            "-colors",
            *params.get("colors")
        ])
    if params.get("patches") is not None:
        cargs.extend([
            "-patches",
            *params.get("patches")
        ])
    if params.get("censor_trs") is not None:
        cargs.extend([
            "-censor_trs",
            *params.get("censor_trs")
        ])
    if params.get("censor_files") is not None:
        cargs.extend([
            "-censor_files",
            *[execution.input_file(f) for f in params.get("censor_files")]
        ])
    if params.get("censor_hline") is not None:
        cargs.extend([
            "-censor_hline",
            *params.get("censor_hline")
        ])
    if params.get("censor_rgb") is not None:
        cargs.extend([
            "-censor_RGB",
            params.get("censor_rgb")
        ])
    if params.get("bkgd_color") is not None:
        cargs.extend([
            "-bkgd_color",
            params.get("bkgd_color")
        ])
    return cargs


def v_1dplot_py_outputs(
    params: V1dplotPyParameters,
    execution: Execution,
) -> V1dplotPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dplotPyOutputs(
        root=execution.output_file("."),
        output_image=execution.output_file(params.get("prefix") + ".jpg"),
    )
    return ret


def v_1dplot_py_execute(
    params: V1dplotPyParameters,
    execution: Execution,
) -> V1dplotPyOutputs:
    """
    This program is for making images to visualize columns of numbers from 1D text
    files. It uses Python, particularly matplotlib, to create plots.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V1dplotPyOutputs`).
    """
    params = execution.params(params)
    cargs = v_1dplot_py_cargs(params, execution)
    ret = v_1dplot_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_1dplot_py(
    infiles: list[InputPathType],
    prefix: str,
    help_: bool = False,
    boxplot_on: bool = False,
    bplot_view: str | None = None,
    margin_off: bool = False,
    scale: list[str] | None = None,
    xfile: InputPathType | None = None,
    xvals: list[float] | None = None,
    yaxis: list[str] | None = None,
    ylabels: list[str] | None = None,
    ylabels_maxlen: float | None = None,
    legend_on: bool = False,
    legend_labels: list[str] | None = None,
    legend_locs: list[str] | None = None,
    xlabel: str | None = None,
    title: str | None = None,
    reverse_order: bool = False,
    sepscl: bool = False,
    one_graph: bool = False,
    dpi: float | None = None,
    figsize: list[float] | None = None,
    fontsize: float | None = None,
    fontfamily: str | None = None,
    fontstyles: str | None = None,
    colors: list[str] | None = None,
    patches: list[str] | None = None,
    censor_trs: list[str] | None = None,
    censor_files: list[InputPathType] | None = None,
    censor_hline: list[str] | None = None,
    censor_rgb: str | None = None,
    bkgd_color: str | None = None,
    runner: Runner | None = None,
) -> V1dplotPyOutputs:
    """
    This program is for making images to visualize columns of numbers from 1D text
    files. It uses Python, particularly matplotlib, to create plots.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infiles: One or more file names of text files. Each column in this file\
            will be treated as a separate time series for plotting.
        prefix: Output filename or prefix. Default output image type is .jpg.
        help_: See helpfile.
        boxplot_on: A fun feature to show an additional boxplot adjacent to\
            each time series.
        bplot_view: Adjust view for boxplots when using censoring.
        margin_off: Fill the plot frame completely, thus no labels, frame, or\
            titles will be visible.
        scale: Provide a list of scales to apply to the y-values.
        xfile: One way to input x-values explicitly: as a "1D" file containing\
            a single file of numbers.
        xvals: Provide exactly 3 numbers for x-values: start, stop, and\
            stepsize.
        yaxis: Optional range for each 'infile' y-axis.
        ylabels: Optional text labels for each 'infile' column.
        ylabels_maxlen: allows y-axis labels to wrap into multiple rows, each\
            of length <= which the user can decide.
        legend_on: Turn on the plotting of a legend in the plot(s).
        legend_labels: Optional legend labels, if using '-legend_on'.
        legend_locs: Optional legend locations, if using '-legend_on'.
        xlabel: Optional text labels for the abscissa/x-axis.
        title: Optional title for the set of plots.
        reverse_order: Reverses the order of plotted time series.
        sepscl: Make each graph have its own y-range.
        one_graph: Plot multiple infiles in a single subplot.
        dpi: Choose the output image's DPI. Default value is 150.
        figsize: Choose the output image's dimensions (units are inches).
        fontsize: Change image fontsize; default is 10.
        fontfamily: Change font-family used; default is monospace.
        fontstyles: Add a specific font name; should match with chosen\
            font-family.
        colors: Decide what color(s) to cycle through in plots (one or more).
        patches: Specify run lengths for background patches to distinguish runs.
        censor_trs: Specify time points where censoring has occurred using AFNI\
            index notation.
        censor_files: Specify time points where censoring has occurred using\
            one or more 1D files.
        censor_hline: Add a dotted horizontal line to the plot, representing\
            the censor threshold.
        censor_rgb: Choose the color of the censoring background; default is:\
            [1, 0.7, 0.7].
        bkgd_color: Change the background color outside of the plot windows.\
            Default is 0.9.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dplotPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_1DPLOT_PY_METADATA)
    params = v_1dplot_py_params(
        infiles=infiles,
        prefix=prefix,
        help_=help_,
        boxplot_on=boxplot_on,
        bplot_view=bplot_view,
        margin_off=margin_off,
        scale=scale,
        xfile=xfile,
        xvals=xvals,
        yaxis=yaxis,
        ylabels=ylabels,
        ylabels_maxlen=ylabels_maxlen,
        legend_on=legend_on,
        legend_labels=legend_labels,
        legend_locs=legend_locs,
        xlabel=xlabel,
        title=title,
        reverse_order=reverse_order,
        sepscl=sepscl,
        one_graph=one_graph,
        dpi=dpi,
        figsize=figsize,
        fontsize=fontsize,
        fontfamily=fontfamily,
        fontstyles=fontstyles,
        colors=colors,
        patches=patches,
        censor_trs=censor_trs,
        censor_files=censor_files,
        censor_hline=censor_hline,
        censor_rgb=censor_rgb,
        bkgd_color=bkgd_color,
    )
    return v_1dplot_py_execute(params, execution)


__all__ = [
    "V1dplotPyOutputs",
    "V1dplotPyParameters",
    "V_1DPLOT_PY_METADATA",
    "v_1dplot_py",
    "v_1dplot_py_params",
]
