# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_24SWAP_METADATA = Metadata(
    id="7bff8c87ec5e9d1f68524b27c8cf903189e91f26.boutiques",
    name="24swap",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V24swapParameters = typing.TypedDict('V24swapParameters', {
    "__STYXTYPE__": typing.Literal["24swap"],
    "quiet": bool,
    "pattern": typing.NotRequired[str | None],
    "input_files": list[InputPathType],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "24swap": v_24swap_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class V24swapOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_24swap(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_24swap_params(
    input_files: list[InputPathType],
    quiet: bool = False,
    pattern: str | None = None,
) -> V24swapParameters:
    """
    Build parameters.
    
    Args:
        input_files: Input file(s) to swap bytes.
        quiet: Operate quietly.
        pattern: Pattern that determines the pattern of 2 and 4 byte swaps.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "24swap",
        "quiet": quiet,
        "input_files": input_files,
    }
    if pattern is not None:
        params["pattern"] = pattern
    return params


def v_24swap_cargs(
    params: V24swapParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("24swap")
    if params.get("quiet"):
        cargs.append("-q")
    if params.get("pattern") is not None:
        cargs.extend([
            "-pattern",
            params.get("pattern")
        ])
    cargs.extend([execution.input_file(f) for f in params.get("input_files")])
    return cargs


def v_24swap_outputs(
    params: V24swapParameters,
    execution: Execution,
) -> V24swapOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V24swapOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_24swap_execute(
    params: V24swapParameters,
    execution: Execution,
) -> V24swapOutputs:
    """
    Swaps bytes pairs and/or quadruples on the files listed.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V24swapOutputs`).
    """
    params = execution.params(params)
    cargs = v_24swap_cargs(params, execution)
    ret = v_24swap_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_24swap(
    input_files: list[InputPathType],
    quiet: bool = False,
    pattern: str | None = None,
    runner: Runner | None = None,
) -> V24swapOutputs:
    """
    Swaps bytes pairs and/or quadruples on the files listed.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input file(s) to swap bytes.
        quiet: Operate quietly.
        pattern: Pattern that determines the pattern of 2 and 4 byte swaps.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V24swapOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_24SWAP_METADATA)
    params = v_24swap_params(
        quiet=quiet,
        pattern=pattern,
        input_files=input_files,
    )
    return v_24swap_execute(params, execution)


__all__ = [
    "V24swapOutputs",
    "V24swapParameters",
    "V_24SWAP_METADATA",
    "v_24swap",
    "v_24swap_params",
]
