# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_ACOST_METADATA = Metadata(
    id="3b13cb783a9f1117e8f3b02cc3c2980e9a683a89.boutiques",
    name="3dAcost",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dAcostParameters = typing.TypedDict('V3dAcostParameters', {
    "__STYXTYPE__": typing.Literal["3dAcost"],
    "infile": InputPathType,
    "basefile": InputPathType,
    "outfile": str,
    "all_cost": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dAcost": v_3d_acost_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dAcost": v_3d_acost_outputs,
    }.get(t)


class V3dAcostOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_acost(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_head: OutputPathType
    """Output aligned dataset (HEAD file)"""
    output_brik: OutputPathType
    """Output aligned dataset (BRIK file)"""


def v_3d_acost_params(
    infile: InputPathType,
    basefile: InputPathType,
    outfile: str,
    all_cost: bool = False,
) -> V3dAcostParameters:
    """
    Build parameters.
    
    Args:
        infile: Input dataset for allineation.
        basefile: Base dataset for allineation.
        outfile: Prefix for the output dataset.
        all_cost: Prints all alignment cost metrics.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dAcost",
        "infile": infile,
        "basefile": basefile,
        "outfile": outfile,
        "all_cost": all_cost,
    }
    return params


def v_3d_acost_cargs(
    params: V3dAcostParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dAcost")
    cargs.append(execution.input_file(params.get("infile")))
    cargs.extend([
        "-base",
        execution.input_file(params.get("basefile"))
    ])
    cargs.extend([
        "-prefix",
        params.get("outfile")
    ])
    if params.get("all_cost"):
        cargs.append("-allcostX")
    return cargs


def v_3d_acost_outputs(
    params: V3dAcostParameters,
    execution: Execution,
) -> V3dAcostOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dAcostOutputs(
        root=execution.output_file("."),
        output_head=execution.output_file(params.get("outfile") + "+orig.HEAD"),
        output_brik=execution.output_file(params.get("outfile") + "+orig.BRIK"),
    )
    return ret


def v_3d_acost_execute(
    params: V3dAcostParameters,
    execution: Execution,
) -> V3dAcostOutputs:
    """
    Allineate dataset to a base dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dAcostOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_acost_cargs(params, execution)
    ret = v_3d_acost_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_acost(
    infile: InputPathType,
    basefile: InputPathType,
    outfile: str,
    all_cost: bool = False,
    runner: Runner | None = None,
) -> V3dAcostOutputs:
    """
    Allineate dataset to a base dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Input dataset for allineation.
        basefile: Base dataset for allineation.
        outfile: Prefix for the output dataset.
        all_cost: Prints all alignment cost metrics.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dAcostOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_ACOST_METADATA)
    params = v_3d_acost_params(
        infile=infile,
        basefile=basefile,
        outfile=outfile,
        all_cost=all_cost,
    )
    return v_3d_acost_execute(params, execution)


__all__ = [
    "V3dAcostOutputs",
    "V3dAcostParameters",
    "V_3D_ACOST_METADATA",
    "v_3d_acost",
    "v_3d_acost_params",
]
