# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_AUTO_TCORRELATE_METADATA = Metadata(
    id="f8dd31b3bdbd84c61b724bec91c847beb95fd339.boutiques",
    name="3dAutoTcorrelate",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dAutoTcorrelateParameters = typing.TypedDict('V3dAutoTcorrelateParameters', {
    "__STYXTYPE__": typing.Literal["3dAutoTcorrelate"],
    "input_dataset": InputPathType,
    "pearson": bool,
    "eta2": bool,
    "polort": typing.NotRequired[int | None],
    "autoclip": bool,
    "automask": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "mask_only_targets": bool,
    "mask_source": typing.NotRequired[InputPathType | None],
    "prefix": typing.NotRequired[str | None],
    "out1d": typing.NotRequired[str | None],
    "time": bool,
    "mmap": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dAutoTcorrelate": v_3d_auto_tcorrelate_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dAutoTcorrelate": v_3d_auto_tcorrelate_outputs,
    }.get(t)


class V3dAutoTcorrelateOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_auto_tcorrelate(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_brick: OutputPathType | None
    """Main output dataset"""
    output_head: OutputPathType | None
    """Header information for main output dataset"""
    out1d_file: OutputPathType | None
    """Output in 1D text format"""


def v_3d_auto_tcorrelate_params(
    input_dataset: InputPathType,
    pearson: bool = False,
    eta2: bool = False,
    polort: int | None = None,
    autoclip: bool = False,
    automask: bool = False,
    mask: InputPathType | None = None,
    mask_only_targets: bool = False,
    mask_source: InputPathType | None = None,
    prefix: str | None = None,
    out1d: str | None = None,
    time_: bool = False,
    mmap_: bool = False,
) -> V3dAutoTcorrelateParameters:
    """
    Build parameters.
    
    Args:
        input_dataset: Input dataset.
        pearson: Correlation is the normal Pearson (product moment) correlation\
            coefficient [default].
        eta2: Output is eta^2 measure from Cohen et al., NeuroImage, 2008.
        polort: Remove polynomial trend of order 'm', for m=-1..3.
        autoclip: Clip off low-intensity regions in the dataset.
        automask: Apply automask to the dataset.
        mask: Mask of both 'source' and 'target' voxels.
        mask_only_targets: Provide output for all voxels.
        mask_source: Provide output for voxels only in specified mask.
        prefix: Save output into dataset with specified prefix.
        out1d: Save output in a text file in 1D format.
        time_: Mark output as a 3D+time dataset.
        mmap_: Write .BRIK results to disk directly using Unix mmap().
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dAutoTcorrelate",
        "input_dataset": input_dataset,
        "pearson": pearson,
        "eta2": eta2,
        "autoclip": autoclip,
        "automask": automask,
        "mask_only_targets": mask_only_targets,
        "time": time_,
        "mmap": mmap_,
    }
    if polort is not None:
        params["polort"] = polort
    if mask is not None:
        params["mask"] = mask
    if mask_source is not None:
        params["mask_source"] = mask_source
    if prefix is not None:
        params["prefix"] = prefix
    if out1d is not None:
        params["out1d"] = out1d
    return params


def v_3d_auto_tcorrelate_cargs(
    params: V3dAutoTcorrelateParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dAutoTcorrelate")
    cargs.append(execution.input_file(params.get("input_dataset")))
    if params.get("pearson"):
        cargs.append("-pearson")
    if params.get("eta2"):
        cargs.append("-eta2")
    if params.get("polort") is not None:
        cargs.extend([
            "-polort",
            str(params.get("polort"))
        ])
    if params.get("autoclip"):
        cargs.append("-autoclip")
    if params.get("automask"):
        cargs.append("-automask")
    if params.get("mask") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask"))
        ])
    if params.get("mask_only_targets"):
        cargs.append("-mask_only_targets")
    if params.get("mask_source") is not None:
        cargs.extend([
            "-mask_source",
            execution.input_file(params.get("mask_source"))
        ])
    if params.get("prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix")
        ])
    if params.get("out1d") is not None:
        cargs.extend([
            "-out1D",
            params.get("out1d")
        ])
    if params.get("time"):
        cargs.append("-time")
    if params.get("mmap"):
        cargs.append("-mmap")
    return cargs


def v_3d_auto_tcorrelate_outputs(
    params: V3dAutoTcorrelateParameters,
    execution: Execution,
) -> V3dAutoTcorrelateOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dAutoTcorrelateOutputs(
        root=execution.output_file("."),
        output_brick=execution.output_file(params.get("prefix") + ".BRIK") if (params.get("prefix") is not None) else None,
        output_head=execution.output_file(params.get("prefix") + ".HEAD") if (params.get("prefix") is not None) else None,
        out1d_file=execution.output_file(params.get("out1d")) if (params.get("out1d") is not None) else None,
    )
    return ret


def v_3d_auto_tcorrelate_execute(
    params: V3dAutoTcorrelateParameters,
    execution: Execution,
) -> V3dAutoTcorrelateOutputs:
    """
    Computes the correlation coefficient between the time series of each pair of
    voxels in the input dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dAutoTcorrelateOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_auto_tcorrelate_cargs(params, execution)
    ret = v_3d_auto_tcorrelate_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_auto_tcorrelate(
    input_dataset: InputPathType,
    pearson: bool = False,
    eta2: bool = False,
    polort: int | None = None,
    autoclip: bool = False,
    automask: bool = False,
    mask: InputPathType | None = None,
    mask_only_targets: bool = False,
    mask_source: InputPathType | None = None,
    prefix: str | None = None,
    out1d: str | None = None,
    time_: bool = False,
    mmap_: bool = False,
    runner: Runner | None = None,
) -> V3dAutoTcorrelateOutputs:
    """
    Computes the correlation coefficient between the time series of each pair of
    voxels in the input dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_dataset: Input dataset.
        pearson: Correlation is the normal Pearson (product moment) correlation\
            coefficient [default].
        eta2: Output is eta^2 measure from Cohen et al., NeuroImage, 2008.
        polort: Remove polynomial trend of order 'm', for m=-1..3.
        autoclip: Clip off low-intensity regions in the dataset.
        automask: Apply automask to the dataset.
        mask: Mask of both 'source' and 'target' voxels.
        mask_only_targets: Provide output for all voxels.
        mask_source: Provide output for voxels only in specified mask.
        prefix: Save output into dataset with specified prefix.
        out1d: Save output in a text file in 1D format.
        time_: Mark output as a 3D+time dataset.
        mmap_: Write .BRIK results to disk directly using Unix mmap().
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dAutoTcorrelateOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_AUTO_TCORRELATE_METADATA)
    params = v_3d_auto_tcorrelate_params(
        input_dataset=input_dataset,
        pearson=pearson,
        eta2=eta2,
        polort=polort,
        autoclip=autoclip,
        automask=automask,
        mask=mask,
        mask_only_targets=mask_only_targets,
        mask_source=mask_source,
        prefix=prefix,
        out1d=out1d,
        time_=time_,
        mmap_=mmap_,
    )
    return v_3d_auto_tcorrelate_execute(params, execution)


__all__ = [
    "V3dAutoTcorrelateOutputs",
    "V3dAutoTcorrelateParameters",
    "V_3D_AUTO_TCORRELATE_METADATA",
    "v_3d_auto_tcorrelate",
    "v_3d_auto_tcorrelate_params",
]
