# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_BRICK_STAT_METADATA = Metadata(
    id="a69dcfae94945e2d6a2a10deecf9753b5bb81503.boutiques",
    name="3dBrickStat",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dBrickStatParameters = typing.TypedDict('V3dBrickStatParameters', {
    "__STYXTYPE__": typing.Literal["3dBrickStat"],
    "dataset": str,
    "quick": bool,
    "slow": bool,
    "min": bool,
    "max": bool,
    "mean": bool,
    "sum": bool,
    "var": bool,
    "stdev": bool,
    "count": bool,
    "volume": bool,
    "positive": bool,
    "negative": bool,
    "zero": bool,
    "non_positive": bool,
    "non_negative": bool,
    "non_zero": bool,
    "absolute": bool,
    "nan": bool,
    "nonan": bool,
    "mask": typing.NotRequired[str | None],
    "mrange": typing.NotRequired[list[float] | None],
    "mvalue": typing.NotRequired[float | None],
    "automask": bool,
    "percentile": typing.NotRequired[list[float] | None],
    "perclist": typing.NotRequired[list[float] | None],
    "median": bool,
    "perc_quiet": bool,
    "ver": bool,
    "help": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dBrickStat": v_3d_brick_stat_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dBrickStat": v_3d_brick_stat_outputs,
    }.get(t)


class V3dBrickStatOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_brick_stat(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    console_output: OutputPathType
    """Console output of computed statistics"""


def v_3d_brick_stat_params(
    dataset: str,
    quick: bool = False,
    slow: bool = False,
    min_: bool = False,
    max_: bool = False,
    mean: bool = False,
    sum_: bool = False,
    var: bool = False,
    stdev: bool = False,
    count: bool = False,
    volume: bool = False,
    positive: bool = False,
    negative: bool = False,
    zero: bool = False,
    non_positive: bool = False,
    non_negative: bool = False,
    non_zero: bool = False,
    absolute: bool = False,
    nan: bool = False,
    nonan: bool = False,
    mask: str | None = None,
    mrange: list[float] | None = None,
    mvalue: float | None = None,
    automask: bool = False,
    percentile: list[float] | None = None,
    perclist: list[float] | None = None,
    median: bool = False,
    perc_quiet: bool = False,
    ver: bool = False,
    help_: bool = False,
) -> V3dBrickStatParameters:
    """
    Build parameters.
    
    Args:
        dataset: Input dataset.
        quick: Get the information from the header only (default).
        slow: Read the whole dataset to find the min and max values.
        min_: Print the minimum value in dataset.
        max_: Print the maximum value in dataset (default).
        mean: Print the mean value in dataset.
        sum_: Print the sum of values in the dataset.
        var: Print the variance in the dataset.
        stdev: Print the standard deviation in the dataset.
        count: Print the number of voxels included.
        volume: Print the volume of voxels included in microliters.
        positive: Include only positive voxel values.
        negative: Include only negative voxel values.
        zero: Include only zero voxel values.
        non_positive: Include only voxel values 0 or negative.
        non_negative: Include only voxel values 0 or greater.
        non_zero: Include only voxel values not equal to 0.
        absolute: Use absolute value of voxel values for all calculations.
        nan: Include only voxel values that are NaN or inf. Forces -slow mode.
        nonan: Exclude voxel values that are NaN or inf.
        mask: Use the specified dataset as mask to include/exclude voxels.
        mrange: Only accept values between MIN and MAX (inclusive) from the\
            mask.
        mvalue: Only accept values equal to VAL from the mask.
        automask: Automatically compute mask for dataset. Cannot be combined\
            with -mask.
        percentile: Compute and print percentile values from p0% to p1% at a\
            step of ps%. Only one sub-brick is accepted as input with this option.
        perclist: Like -percentile, but output the given percentiles.
        median: Shortcut for -percentile 50 1 50 (or -perclist 1 50).
        perc_quiet: Only print percentile results, not input percentile cutoffs.
        ver: Print author and version info.
        help_: Print help screen.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dBrickStat",
        "dataset": dataset,
        "quick": quick,
        "slow": slow,
        "min": min_,
        "max": max_,
        "mean": mean,
        "sum": sum_,
        "var": var,
        "stdev": stdev,
        "count": count,
        "volume": volume,
        "positive": positive,
        "negative": negative,
        "zero": zero,
        "non_positive": non_positive,
        "non_negative": non_negative,
        "non_zero": non_zero,
        "absolute": absolute,
        "nan": nan,
        "nonan": nonan,
        "automask": automask,
        "median": median,
        "perc_quiet": perc_quiet,
        "ver": ver,
        "help": help_,
    }
    if mask is not None:
        params["mask"] = mask
    if mrange is not None:
        params["mrange"] = mrange
    if mvalue is not None:
        params["mvalue"] = mvalue
    if percentile is not None:
        params["percentile"] = percentile
    if perclist is not None:
        params["perclist"] = perclist
    return params


def v_3d_brick_stat_cargs(
    params: V3dBrickStatParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dBrickStat")
    cargs.append(params.get("dataset"))
    if params.get("quick"):
        cargs.append("-quick")
    if params.get("slow"):
        cargs.append("-slow")
    if params.get("min"):
        cargs.append("-min")
    if params.get("max"):
        cargs.append("-max")
    if params.get("mean"):
        cargs.append("-mean")
    if params.get("sum"):
        cargs.append("-sum")
    if params.get("var"):
        cargs.append("-var")
    if params.get("stdev"):
        cargs.append("-stdev")
    if params.get("count"):
        cargs.append("-count")
    if params.get("volume"):
        cargs.append("-volume")
    if params.get("positive"):
        cargs.append("-positive")
    if params.get("negative"):
        cargs.append("-negative")
    if params.get("zero"):
        cargs.append("-zero")
    if params.get("non_positive"):
        cargs.append("-non-positive")
    if params.get("non_negative"):
        cargs.append("-non-negative")
    if params.get("non_zero"):
        cargs.append("-non-zero")
    if params.get("absolute"):
        cargs.append("-absolute")
    if params.get("nan"):
        cargs.append("-nan")
    if params.get("nonan"):
        cargs.append("-nonan")
    if params.get("mask") is not None:
        cargs.extend([
            "-mask",
            params.get("mask")
        ])
    if params.get("mrange") is not None:
        cargs.extend([
            "-mrange",
            *map(str, params.get("mrange"))
        ])
    if params.get("mvalue") is not None:
        cargs.extend([
            "-mvalue",
            str(params.get("mvalue"))
        ])
    if params.get("automask"):
        cargs.append("-automask")
    if params.get("percentile") is not None:
        cargs.extend([
            "-percentile",
            *map(str, params.get("percentile"))
        ])
    if params.get("perclist") is not None:
        cargs.extend([
            "-perclist",
            *map(str, params.get("perclist"))
        ])
    if params.get("median"):
        cargs.append("-median")
    if params.get("perc_quiet"):
        cargs.append("-perc_quiet")
    if params.get("ver"):
        cargs.append("-ver")
    if params.get("help"):
        cargs.append("-help")
    return cargs


def v_3d_brick_stat_outputs(
    params: V3dBrickStatParameters,
    execution: Execution,
) -> V3dBrickStatOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dBrickStatOutputs(
        root=execution.output_file("."),
        console_output=execution.output_file("output.txt"),
    )
    return ret


def v_3d_brick_stat_execute(
    params: V3dBrickStatParameters,
    execution: Execution,
) -> V3dBrickStatOutputs:
    """
    Compute voxel statistics of an input dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dBrickStatOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_brick_stat_cargs(params, execution)
    ret = v_3d_brick_stat_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_brick_stat(
    dataset: str,
    quick: bool = False,
    slow: bool = False,
    min_: bool = False,
    max_: bool = False,
    mean: bool = False,
    sum_: bool = False,
    var: bool = False,
    stdev: bool = False,
    count: bool = False,
    volume: bool = False,
    positive: bool = False,
    negative: bool = False,
    zero: bool = False,
    non_positive: bool = False,
    non_negative: bool = False,
    non_zero: bool = False,
    absolute: bool = False,
    nan: bool = False,
    nonan: bool = False,
    mask: str | None = None,
    mrange: list[float] | None = None,
    mvalue: float | None = None,
    automask: bool = False,
    percentile: list[float] | None = None,
    perclist: list[float] | None = None,
    median: bool = False,
    perc_quiet: bool = False,
    ver: bool = False,
    help_: bool = False,
    runner: Runner | None = None,
) -> V3dBrickStatOutputs:
    """
    Compute voxel statistics of an input dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input dataset.
        quick: Get the information from the header only (default).
        slow: Read the whole dataset to find the min and max values.
        min_: Print the minimum value in dataset.
        max_: Print the maximum value in dataset (default).
        mean: Print the mean value in dataset.
        sum_: Print the sum of values in the dataset.
        var: Print the variance in the dataset.
        stdev: Print the standard deviation in the dataset.
        count: Print the number of voxels included.
        volume: Print the volume of voxels included in microliters.
        positive: Include only positive voxel values.
        negative: Include only negative voxel values.
        zero: Include only zero voxel values.
        non_positive: Include only voxel values 0 or negative.
        non_negative: Include only voxel values 0 or greater.
        non_zero: Include only voxel values not equal to 0.
        absolute: Use absolute value of voxel values for all calculations.
        nan: Include only voxel values that are NaN or inf. Forces -slow mode.
        nonan: Exclude voxel values that are NaN or inf.
        mask: Use the specified dataset as mask to include/exclude voxels.
        mrange: Only accept values between MIN and MAX (inclusive) from the\
            mask.
        mvalue: Only accept values equal to VAL from the mask.
        automask: Automatically compute mask for dataset. Cannot be combined\
            with -mask.
        percentile: Compute and print percentile values from p0% to p1% at a\
            step of ps%. Only one sub-brick is accepted as input with this option.
        perclist: Like -percentile, but output the given percentiles.
        median: Shortcut for -percentile 50 1 50 (or -perclist 1 50).
        perc_quiet: Only print percentile results, not input percentile cutoffs.
        ver: Print author and version info.
        help_: Print help screen.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dBrickStatOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_BRICK_STAT_METADATA)
    params = v_3d_brick_stat_params(
        dataset=dataset,
        quick=quick,
        slow=slow,
        min_=min_,
        max_=max_,
        mean=mean,
        sum_=sum_,
        var=var,
        stdev=stdev,
        count=count,
        volume=volume,
        positive=positive,
        negative=negative,
        zero=zero,
        non_positive=non_positive,
        non_negative=non_negative,
        non_zero=non_zero,
        absolute=absolute,
        nan=nan,
        nonan=nonan,
        mask=mask,
        mrange=mrange,
        mvalue=mvalue,
        automask=automask,
        percentile=percentile,
        perclist=perclist,
        median=median,
        perc_quiet=perc_quiet,
        ver=ver,
        help_=help_,
    )
    return v_3d_brick_stat_execute(params, execution)


__all__ = [
    "V3dBrickStatOutputs",
    "V3dBrickStatParameters",
    "V_3D_BRICK_STAT_METADATA",
    "v_3d_brick_stat",
    "v_3d_brick_stat_params",
]
