# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_CLIP_LEVEL_METADATA = Metadata(
    id="88bdbec4ad5f8ad542e0aad8dde4036aca9e4e12.boutiques",
    name="3dClipLevel",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dClipLevelParameters = typing.TypedDict('V3dClipLevelParameters', {
    "__STYXTYPE__": typing.Literal["3dClipLevel"],
    "dataset": InputPathType,
    "mfrac": typing.NotRequired[float | None],
    "doall": bool,
    "grad": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dClipLevel": v_3d_clip_level_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class V3dClipLevelOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_clip_level(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3d_clip_level_params(
    dataset: InputPathType,
    mfrac: float | None = None,
    doall: bool = False,
    grad: str | None = None,
) -> V3dClipLevelParameters:
    """
    Build parameters.
    
    Args:
        dataset: Input dataset (e.g. dataset.nii.gz).
        mfrac: Use the number ff instead of 0.50 in the algorithm.
        doall: Apply the algorithm to each sub-brick separately.
        grad: Compute a 'gradual' clip level as a function of voxel position\
            and output to a dataset with the given prefix.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dClipLevel",
        "dataset": dataset,
        "doall": doall,
    }
    if mfrac is not None:
        params["mfrac"] = mfrac
    if grad is not None:
        params["grad"] = grad
    return params


def v_3d_clip_level_cargs(
    params: V3dClipLevelParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dClipLevel")
    cargs.append(execution.input_file(params.get("dataset")))
    if params.get("mfrac") is not None:
        cargs.extend([
            "-mfrac",
            str(params.get("mfrac"))
        ])
    if params.get("doall"):
        cargs.append("-doall")
    if params.get("grad") is not None:
        cargs.extend([
            "-grad",
            params.get("grad")
        ])
    return cargs


def v_3d_clip_level_outputs(
    params: V3dClipLevelParameters,
    execution: Execution,
) -> V3dClipLevelOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dClipLevelOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3d_clip_level_execute(
    params: V3dClipLevelParameters,
    execution: Execution,
) -> V3dClipLevelOutputs:
    """
    Estimates the value at which to clip the anatomical dataset so that background
    regions are set to zero.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dClipLevelOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_clip_level_cargs(params, execution)
    ret = v_3d_clip_level_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_clip_level(
    dataset: InputPathType,
    mfrac: float | None = None,
    doall: bool = False,
    grad: str | None = None,
    runner: Runner | None = None,
) -> V3dClipLevelOutputs:
    """
    Estimates the value at which to clip the anatomical dataset so that background
    regions are set to zero.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input dataset (e.g. dataset.nii.gz).
        mfrac: Use the number ff instead of 0.50 in the algorithm.
        doall: Apply the algorithm to each sub-brick separately.
        grad: Compute a 'gradual' clip level as a function of voxel position\
            and output to a dataset with the given prefix.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dClipLevelOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_CLIP_LEVEL_METADATA)
    params = v_3d_clip_level_params(
        dataset=dataset,
        mfrac=mfrac,
        doall=doall,
        grad=grad,
    )
    return v_3d_clip_level_execute(params, execution)


__all__ = [
    "V3dClipLevelOutputs",
    "V3dClipLevelParameters",
    "V_3D_CLIP_LEVEL_METADATA",
    "v_3d_clip_level",
    "v_3d_clip_level_params",
]
