# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_CLUSTERIZE_METADATA = Metadata(
    id="e4655542f19e9af1312825c39fb9645b11431092.boutiques",
    name="3dClusterize",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dClusterizeParameters = typing.TypedDict('V3dClusterizeParameters', {
    "__STYXTYPE__": typing.Literal["3dClusterize"],
    "inset": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "mask_from_hdr": bool,
    "out_mask": typing.NotRequired[str | None],
    "ithr": str,
    "idat": typing.NotRequired[str | None],
    "onesided": typing.NotRequired[str | None],
    "twosided": typing.NotRequired[str | None],
    "bisided": typing.NotRequired[str | None],
    "within_range": typing.NotRequired[str | None],
    "nn": int,
    "clust_nvox": typing.NotRequired[int | None],
    "clust_vol": typing.NotRequired[int | None],
    "pref_map": typing.NotRequired[str | None],
    "pref_dat": typing.NotRequired[str | None],
    "one_d_format": bool,
    "no_one_d_format": bool,
    "summarize": bool,
    "nosum": bool,
    "quiet": bool,
    "outvol_if_no_clust": bool,
    "orient": typing.NotRequired[str | None],
    "abs_table_data": bool,
    "binary": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dClusterize": v_3d_clusterize_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dClusterize": v_3d_clusterize_outputs,
    }.get(t)


class V3dClusterizeOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_clusterize(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_map_file: OutputPathType | None
    """Output map of cluster ROIs"""
    out_data_file: OutputPathType | None
    """Cluster-masked version of the data volume"""
    out_mask_file: OutputPathType | None
    """Utilized mask dataset"""


def v_3d_clusterize_params(
    inset: InputPathType,
    ithr: str,
    nn: int,
    mask: InputPathType | None = None,
    mask_from_hdr: bool = False,
    out_mask: str | None = None,
    idat: str | None = None,
    onesided: str | None = None,
    twosided: str | None = None,
    bisided: str | None = None,
    within_range: str | None = None,
    clust_nvox: int | None = None,
    clust_vol: int | None = None,
    pref_map: str | None = None,
    pref_dat: str | None = None,
    one_d_format: bool = False,
    no_one_d_format: bool = False,
    summarize: bool = False,
    nosum: bool = False,
    quiet: bool = False,
    outvol_if_no_clust: bool = False,
    orient: str | None = None,
    abs_table_data: bool = False,
    binary: bool = False,
) -> V3dClusterizeParameters:
    """
    Build parameters.
    
    Args:
        inset: Load in a dataset for thresholding and clusterizing.
        ithr: Specify the sub-brick to use as the threshold source.
        nn: Specify the number of voxel neighbors (1: 6, 2: 18, 3: 26).
        mask: Load in a dataset to use as a mask.
        mask_from_hdr: Use internal mask from dataset header.
        out_mask: Specify to dump the utilized mask as a dataset.
        idat: Specify the sub-brick to use as the data source.
        onesided: Perform one-sided testing.
        twosided: Perform two-sided testing.
        bisided: Perform bisided testing.
        within_range: Keep values within the range [AA, BB].
        clust_nvox: Specify the minimum cluster size in terms of number of\
            voxels.
        clust_vol: Specify the minimum cluster size by volume in microliters.
        pref_map: Prefix/filename of the output map of cluster ROIs.
        pref_dat: Output a cluster-masked version of the data volume.
        one_d_format: Write output in 1D format.
        no_one_d_format: Do not write output in 1D format.
        summarize: Write out only the total nonzero voxel count and volume for\
            each dataset.
        nosum: Suppress printout of the totals.
        quiet: Suppress all non-essential output.
        outvol_if_no_clust: Output an empty volume if no clusters are found.
        orient: Coordinate order in the output report table (default: RAI).
        abs_table_data: Use absolute values for mean and SEM in report table.
        binary: Turn output map of cluster ROIs into a binary mask.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dClusterize",
        "inset": inset,
        "mask_from_hdr": mask_from_hdr,
        "ithr": ithr,
        "nn": nn,
        "one_d_format": one_d_format,
        "no_one_d_format": no_one_d_format,
        "summarize": summarize,
        "nosum": nosum,
        "quiet": quiet,
        "outvol_if_no_clust": outvol_if_no_clust,
        "abs_table_data": abs_table_data,
        "binary": binary,
    }
    if mask is not None:
        params["mask"] = mask
    if out_mask is not None:
        params["out_mask"] = out_mask
    if idat is not None:
        params["idat"] = idat
    if onesided is not None:
        params["onesided"] = onesided
    if twosided is not None:
        params["twosided"] = twosided
    if bisided is not None:
        params["bisided"] = bisided
    if within_range is not None:
        params["within_range"] = within_range
    if clust_nvox is not None:
        params["clust_nvox"] = clust_nvox
    if clust_vol is not None:
        params["clust_vol"] = clust_vol
    if pref_map is not None:
        params["pref_map"] = pref_map
    if pref_dat is not None:
        params["pref_dat"] = pref_dat
    if orient is not None:
        params["orient"] = orient
    return params


def v_3d_clusterize_cargs(
    params: V3dClusterizeParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dClusterize")
    cargs.extend([
        "-inset",
        execution.input_file(params.get("inset"))
    ])
    if params.get("mask") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask"))
        ])
    if params.get("mask_from_hdr"):
        cargs.append("-mask_from_hdr")
    if params.get("out_mask") is not None:
        cargs.extend([
            "-out_mask",
            params.get("out_mask")
        ])
    cargs.extend([
        "-ithr",
        params.get("ithr")
    ])
    if params.get("idat") is not None:
        cargs.extend([
            "-idat",
            params.get("idat")
        ])
    if params.get("onesided") is not None:
        cargs.extend([
            "-1sided",
            params.get("onesided")
        ])
    if params.get("twosided") is not None:
        cargs.extend([
            "-2sided",
            params.get("twosided")
        ])
    if params.get("bisided") is not None:
        cargs.extend([
            "-bisided",
            params.get("bisided")
        ])
    if params.get("within_range") is not None:
        cargs.extend([
            "-within_range",
            params.get("within_range")
        ])
    cargs.extend([
        "-NN",
        str(params.get("nn"))
    ])
    if params.get("clust_nvox") is not None:
        cargs.extend([
            "-clust_nvox",
            str(params.get("clust_nvox"))
        ])
    if params.get("clust_vol") is not None:
        cargs.extend([
            "-clust_vol",
            str(params.get("clust_vol"))
        ])
    if params.get("pref_map") is not None:
        cargs.extend([
            "-pref_map",
            params.get("pref_map")
        ])
    if params.get("pref_dat") is not None:
        cargs.extend([
            "-pref_dat",
            params.get("pref_dat")
        ])
    if params.get("one_d_format"):
        cargs.append("-1Dformat")
    if params.get("no_one_d_format"):
        cargs.append("-no_1Dformat")
    if params.get("summarize"):
        cargs.append("-summarize")
    if params.get("nosum"):
        cargs.append("-nosum")
    if params.get("quiet"):
        cargs.append("-quiet")
    if params.get("outvol_if_no_clust"):
        cargs.append("-outvol_if_no_clust")
    if params.get("orient") is not None:
        cargs.extend([
            "-orient",
            params.get("orient")
        ])
    if params.get("abs_table_data"):
        cargs.append("-abs_table_data")
    if params.get("binary"):
        cargs.append("-binary")
    return cargs


def v_3d_clusterize_outputs(
    params: V3dClusterizeParameters,
    execution: Execution,
) -> V3dClusterizeOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dClusterizeOutputs(
        root=execution.output_file("."),
        out_map_file=execution.output_file(params.get("pref_map") + "+orig.HEAD") if (params.get("pref_map") is not None) else None,
        out_data_file=execution.output_file(params.get("pref_dat") + "+orig.HEAD") if (params.get("pref_dat") is not None) else None,
        out_mask_file=execution.output_file(params.get("out_mask") + "+orig.HEAD") if (params.get("out_mask") is not None) else None,
    )
    return ret


def v_3d_clusterize_execute(
    params: V3dClusterizeParameters,
    execution: Execution,
) -> V3dClusterizeOutputs:
    """
    A tool for voxelwise thresholding and clusterizing of datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dClusterizeOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_clusterize_cargs(params, execution)
    ret = v_3d_clusterize_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_clusterize(
    inset: InputPathType,
    ithr: str,
    nn: int,
    mask: InputPathType | None = None,
    mask_from_hdr: bool = False,
    out_mask: str | None = None,
    idat: str | None = None,
    onesided: str | None = None,
    twosided: str | None = None,
    bisided: str | None = None,
    within_range: str | None = None,
    clust_nvox: int | None = None,
    clust_vol: int | None = None,
    pref_map: str | None = None,
    pref_dat: str | None = None,
    one_d_format: bool = False,
    no_one_d_format: bool = False,
    summarize: bool = False,
    nosum: bool = False,
    quiet: bool = False,
    outvol_if_no_clust: bool = False,
    orient: str | None = None,
    abs_table_data: bool = False,
    binary: bool = False,
    runner: Runner | None = None,
) -> V3dClusterizeOutputs:
    """
    A tool for voxelwise thresholding and clusterizing of datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        inset: Load in a dataset for thresholding and clusterizing.
        ithr: Specify the sub-brick to use as the threshold source.
        nn: Specify the number of voxel neighbors (1: 6, 2: 18, 3: 26).
        mask: Load in a dataset to use as a mask.
        mask_from_hdr: Use internal mask from dataset header.
        out_mask: Specify to dump the utilized mask as a dataset.
        idat: Specify the sub-brick to use as the data source.
        onesided: Perform one-sided testing.
        twosided: Perform two-sided testing.
        bisided: Perform bisided testing.
        within_range: Keep values within the range [AA, BB].
        clust_nvox: Specify the minimum cluster size in terms of number of\
            voxels.
        clust_vol: Specify the minimum cluster size by volume in microliters.
        pref_map: Prefix/filename of the output map of cluster ROIs.
        pref_dat: Output a cluster-masked version of the data volume.
        one_d_format: Write output in 1D format.
        no_one_d_format: Do not write output in 1D format.
        summarize: Write out only the total nonzero voxel count and volume for\
            each dataset.
        nosum: Suppress printout of the totals.
        quiet: Suppress all non-essential output.
        outvol_if_no_clust: Output an empty volume if no clusters are found.
        orient: Coordinate order in the output report table (default: RAI).
        abs_table_data: Use absolute values for mean and SEM in report table.
        binary: Turn output map of cluster ROIs into a binary mask.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dClusterizeOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_CLUSTERIZE_METADATA)
    params = v_3d_clusterize_params(
        inset=inset,
        mask=mask,
        mask_from_hdr=mask_from_hdr,
        out_mask=out_mask,
        ithr=ithr,
        idat=idat,
        onesided=onesided,
        twosided=twosided,
        bisided=bisided,
        within_range=within_range,
        nn=nn,
        clust_nvox=clust_nvox,
        clust_vol=clust_vol,
        pref_map=pref_map,
        pref_dat=pref_dat,
        one_d_format=one_d_format,
        no_one_d_format=no_one_d_format,
        summarize=summarize,
        nosum=nosum,
        quiet=quiet,
        outvol_if_no_clust=outvol_if_no_clust,
        orient=orient,
        abs_table_data=abs_table_data,
        binary=binary,
    )
    return v_3d_clusterize_execute(params, execution)


__all__ = [
    "V3dClusterizeOutputs",
    "V3dClusterizeParameters",
    "V_3D_CLUSTERIZE_METADATA",
    "v_3d_clusterize",
    "v_3d_clusterize_params",
]
