# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_CM_METADATA = Metadata(
    id="86d28ac666c67b4bd4d8d68c8533d068db093ca1.boutiques",
    name="3dCM",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dCmParameters = typing.TypedDict('V3dCmParameters', {
    "__STYXTYPE__": typing.Literal["3dCM"],
    "dset": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "automask": bool,
    "set_origin": typing.NotRequired[list[float] | None],
    "local_ijk": bool,
    "roi_vals": typing.NotRequired[list[float] | None],
    "all_rois": bool,
    "icent": bool,
    "dcent": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dCM": v_3d_cm_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dCM": v_3d_cm_outputs,
    }.get(t)


class V3dCmOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_cm(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    center_of_mass: OutputPathType
    """Center of mass of the dataset."""


def v_3d_cm_params(
    dset: InputPathType,
    mask: InputPathType | None = None,
    automask: bool = False,
    set_origin: list[float] | None = None,
    local_ijk: bool = False,
    roi_vals: list[float] | None = None,
    all_rois: bool = False,
    icent: bool = False,
    dcent: bool = False,
) -> V3dCmParameters:
    """
    Build parameters.
    
    Args:
        dset: Input dataset.
        mask: Use the specified dataset as a mask. Only voxels with nonzero\
            values in 'mset' will be averaged from 'dataset'. Both datasets must\
            have the same number of voxels.
        automask: Generate the mask automatically.
        set_origin: After computing the CM of the dataset, set the origin\
            fields in the header so that the CM will be at (x,y,z) in DICOM\
            coordinates.
        local_ijk: Output values as (i,j,k) in local orientation.
        roi_vals: Compute center of mass for each blob with specified voxel\
            values.
        all_rois: Automatically find all ROI values and compute their centers\
            of mass.
        icent: Compute Internal Center, which finds the center voxel closest to\
            the center of mass.
        dcent: Compute Distance Center, the center voxel with the shortest\
            average distance to all other voxels. This is computationally\
            expensive.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dCM",
        "dset": dset,
        "automask": automask,
        "local_ijk": local_ijk,
        "all_rois": all_rois,
        "icent": icent,
        "dcent": dcent,
    }
    if mask is not None:
        params["mask"] = mask
    if set_origin is not None:
        params["set_origin"] = set_origin
    if roi_vals is not None:
        params["roi_vals"] = roi_vals
    return params


def v_3d_cm_cargs(
    params: V3dCmParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dCM")
    cargs.append(execution.input_file(params.get("dset")))
    if params.get("mask") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask"))
        ])
    if params.get("automask"):
        cargs.append("-automask")
    if params.get("set_origin") is not None:
        cargs.extend([
            "-set",
            *map(str, params.get("set_origin"))
        ])
    if params.get("local_ijk"):
        cargs.append("-local_ijk")
    if params.get("roi_vals") is not None:
        cargs.extend([
            "-roi_vals",
            *map(str, params.get("roi_vals"))
        ])
    if params.get("all_rois"):
        cargs.append("-all_rois")
    if params.get("icent"):
        cargs.append("-Icent")
    if params.get("dcent"):
        cargs.append("-Dcent")
    return cargs


def v_3d_cm_outputs(
    params: V3dCmParameters,
    execution: Execution,
) -> V3dCmOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dCmOutputs(
        root=execution.output_file("."),
        center_of_mass=execution.output_file("<stdout>"),
    )
    return ret


def v_3d_cm_execute(
    params: V3dCmParameters,
    execution: Execution,
) -> V3dCmOutputs:
    """
    Tool for computing the center of mass of a dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dCmOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_cm_cargs(params, execution)
    ret = v_3d_cm_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_cm(
    dset: InputPathType,
    mask: InputPathType | None = None,
    automask: bool = False,
    set_origin: list[float] | None = None,
    local_ijk: bool = False,
    roi_vals: list[float] | None = None,
    all_rois: bool = False,
    icent: bool = False,
    dcent: bool = False,
    runner: Runner | None = None,
) -> V3dCmOutputs:
    """
    Tool for computing the center of mass of a dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dset: Input dataset.
        mask: Use the specified dataset as a mask. Only voxels with nonzero\
            values in 'mset' will be averaged from 'dataset'. Both datasets must\
            have the same number of voxels.
        automask: Generate the mask automatically.
        set_origin: After computing the CM of the dataset, set the origin\
            fields in the header so that the CM will be at (x,y,z) in DICOM\
            coordinates.
        local_ijk: Output values as (i,j,k) in local orientation.
        roi_vals: Compute center of mass for each blob with specified voxel\
            values.
        all_rois: Automatically find all ROI values and compute their centers\
            of mass.
        icent: Compute Internal Center, which finds the center voxel closest to\
            the center of mass.
        dcent: Compute Distance Center, the center voxel with the shortest\
            average distance to all other voxels. This is computationally\
            expensive.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dCmOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_CM_METADATA)
    params = v_3d_cm_params(
        dset=dset,
        mask=mask,
        automask=automask,
        set_origin=set_origin,
        local_ijk=local_ijk,
        roi_vals=roi_vals,
        all_rois=all_rois,
        icent=icent,
        dcent=dcent,
    )
    return v_3d_cm_execute(params, execution)


__all__ = [
    "V3dCmOutputs",
    "V3dCmParameters",
    "V_3D_CM_METADATA",
    "v_3d_cm",
    "v_3d_cm_params",
]
