# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_CONFORMIST_METADATA = Metadata(
    id="63b3754b3ba2db8a7c79b06afeb0810bdb32d0bc.boutiques",
    name="3dConformist",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dConformistParameters = typing.TypedDict('V3dConformistParameters', {
    "__STYXTYPE__": typing.Literal["3dConformist"],
    "input_files": list[InputPathType],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dConformist": v_3d_conformist_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dConformist": v_3d_conformist_outputs,
    }.get(t)


class V3dConformistOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_conformist(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_files: OutputPathType
    """Zero padded output dataset files"""


def v_3d_conformist_params(
    input_files: list[InputPathType],
) -> V3dConformistParameters:
    """
    Build parameters.
    
    Args:
        input_files: Input datasets to be zero padded to the same size.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dConformist",
        "input_files": input_files,
    }
    return params


def v_3d_conformist_cargs(
    params: V3dConformistParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dConformist")
    cargs.extend([execution.input_file(f) for f in params.get("input_files")])
    return cargs


def v_3d_conformist_outputs(
    params: V3dConformistParameters,
    execution: Execution,
) -> V3dConformistOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dConformistOutputs(
        root=execution.output_file("."),
        output_files=execution.output_file("."),
    )
    return ret


def v_3d_conformist_execute(
    params: V3dConformistParameters,
    execution: Execution,
) -> V3dConformistOutputs:
    """
    Program to conform a collection of datasets to the same size by zero padding.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dConformistOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_conformist_cargs(params, execution)
    ret = v_3d_conformist_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_conformist(
    input_files: list[InputPathType],
    runner: Runner | None = None,
) -> V3dConformistOutputs:
    """
    Program to conform a collection of datasets to the same size by zero padding.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input datasets to be zero padded to the same size.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dConformistOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_CONFORMIST_METADATA)
    params = v_3d_conformist_params(
        input_files=input_files,
    )
    return v_3d_conformist_execute(params, execution)


__all__ = [
    "V3dConformistOutputs",
    "V3dConformistParameters",
    "V_3D_CONFORMIST_METADATA",
    "v_3d_conformist",
    "v_3d_conformist_params",
]
