# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_CRUISETO_AFNI_METADATA = Metadata(
    id="ecced7561c452fa6014dcc10bbbbd514bae7282a.boutiques",
    name="3dCRUISEtoAFNI",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dCruisetoAfniTraceParameters = typing.TypedDict('V3dCruisetoAfniTraceParameters', {
    "__STYXTYPE__": typing.Literal["trace"],
    "trace": bool,
    "TRACE": bool,
})


V3dCruisetoAfniParameters = typing.TypedDict('V3dCruisetoAfniParameters', {
    "__STYXTYPE__": typing.Literal["3dCRUISEtoAFNI"],
    "input": InputPathType,
    "novolreg": bool,
    "noxform": bool,
    "setenv": typing.NotRequired[str | None],
    "trace": typing.NotRequired[V3dCruisetoAfniTraceParameters | None],
    "nomall": bool,
    "yesmall": bool,
    "help": bool,
    "h": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dCRUISEtoAFNI": v_3d_cruiseto_afni_cargs,
        "trace": v_3d_cruiseto_afni_trace_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


def v_3d_cruiseto_afni_trace_params(
    trace_: bool = False,
    trace_2: bool = False,
) -> V3dCruisetoAfniTraceParameters:
    """
    Build parameters.
    
    Args:
        trace_: Turns on In/Out debug and Memory tracing. It's recommended to\
            redirect stdout to a file when using this option.
        trace_2: Turns on extreme tracing.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "trace",
        "trace": trace_,
        "TRACE": trace_2,
    }
    return params


def v_3d_cruiseto_afni_trace_cargs(
    params: V3dCruisetoAfniTraceParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    if params.get("trace"):
        cargs.append("-trace")
    if params.get("TRACE"):
        cargs.append("-TRACE")
    return cargs


class V3dCruisetoAfniOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_cruiseto_afni(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3d_cruiseto_afni_params(
    input_: InputPathType,
    novolreg: bool = False,
    noxform: bool = False,
    setenv: str | None = None,
    trace_: V3dCruisetoAfniTraceParameters | None = None,
    nomall: bool = False,
    yesmall: bool = False,
    help_: bool = False,
    h: bool = False,
) -> V3dCruisetoAfniParameters:
    """
    Build parameters.
    
    Args:
        input_: Input CRUISE header file in OpenDX format.
        novolreg: Ignore any Rotate, Volreg, Tagalign, or WarpDrive\
            transformations present in the Surface Volume.
        noxform: Same as -novolreg.
        setenv: Set environment variable ENVname to be ENVvalue. Quotes are\
            necessary. Example: suma -setenv "'SUMA_BackgroundColor = 1 0 1'".
        trace_: Turns on In/Out debug and Memory tracing. It's recommended to\
            redirect stdout to a file when using this option.
        nomall: Turn off memory tracing.
        yesmall: Turn on memory tracing (default).
        help_: The entire help output.
        h: Displays mini help; in many cases, it's the same as -help.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dCRUISEtoAFNI",
        "input": input_,
        "novolreg": novolreg,
        "noxform": noxform,
        "nomall": nomall,
        "yesmall": yesmall,
        "help": help_,
        "h": h,
    }
    if setenv is not None:
        params["setenv"] = setenv
    if trace_ is not None:
        params["trace"] = trace_
    return params


def v_3d_cruiseto_afni_cargs(
    params: V3dCruisetoAfniParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dCRUISEtoAFNI")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input"))
    ])
    if params.get("novolreg"):
        cargs.append("-novolreg")
    if params.get("noxform"):
        cargs.append("-noxform")
    if params.get("setenv") is not None:
        cargs.extend([
            "-setenv",
            params.get("setenv")
        ])
    if params.get("trace") is not None:
        cargs.extend(dyn_cargs(params.get("trace")["__STYXTYPE__"])(params.get("trace"), execution))
    if params.get("nomall"):
        cargs.append("-nomall")
    if params.get("yesmall"):
        cargs.append("-yesmall")
    if params.get("help"):
        cargs.append("-help")
    if params.get("h"):
        cargs.append("-h")
    return cargs


def v_3d_cruiseto_afni_outputs(
    params: V3dCruisetoAfniParameters,
    execution: Execution,
) -> V3dCruisetoAfniOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dCruisetoAfniOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3d_cruiseto_afni_execute(
    params: V3dCruisetoAfniParameters,
    execution: Execution,
) -> V3dCruisetoAfniOutputs:
    """
    Converts a CRUISE dataset defined by a header in OpenDX format.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dCruisetoAfniOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_cruiseto_afni_cargs(params, execution)
    ret = v_3d_cruiseto_afni_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_cruiseto_afni(
    input_: InputPathType,
    novolreg: bool = False,
    noxform: bool = False,
    setenv: str | None = None,
    trace_: V3dCruisetoAfniTraceParameters | None = None,
    nomall: bool = False,
    yesmall: bool = False,
    help_: bool = False,
    h: bool = False,
    runner: Runner | None = None,
) -> V3dCruisetoAfniOutputs:
    """
    Converts a CRUISE dataset defined by a header in OpenDX format.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_: Input CRUISE header file in OpenDX format.
        novolreg: Ignore any Rotate, Volreg, Tagalign, or WarpDrive\
            transformations present in the Surface Volume.
        noxform: Same as -novolreg.
        setenv: Set environment variable ENVname to be ENVvalue. Quotes are\
            necessary. Example: suma -setenv "'SUMA_BackgroundColor = 1 0 1'".
        trace_: Turns on In/Out debug and Memory tracing. It's recommended to\
            redirect stdout to a file when using this option.
        nomall: Turn off memory tracing.
        yesmall: Turn on memory tracing (default).
        help_: The entire help output.
        h: Displays mini help; in many cases, it's the same as -help.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dCruisetoAfniOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_CRUISETO_AFNI_METADATA)
    params = v_3d_cruiseto_afni_params(
        input_=input_,
        novolreg=novolreg,
        noxform=noxform,
        setenv=setenv,
        trace_=trace_,
        nomall=nomall,
        yesmall=yesmall,
        help_=help_,
        h=h,
    )
    return v_3d_cruiseto_afni_execute(params, execution)


__all__ = [
    "V3dCruisetoAfniOutputs",
    "V3dCruisetoAfniParameters",
    "V3dCruisetoAfniTraceParameters",
    "V_3D_CRUISETO_AFNI_METADATA",
    "v_3d_cruiseto_afni",
    "v_3d_cruiseto_afni_params",
    "v_3d_cruiseto_afni_trace_params",
]
