# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_DEGREE_CENTRALITY_METADATA = Metadata(
    id="6b26eb322a598bdf48e84565bbf6674c9e7c8cf4.boutiques",
    name="3dDegreeCentrality",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dDegreeCentralityParameters = typing.TypedDict('V3dDegreeCentralityParameters', {
    "__STYXTYPE__": typing.Literal["3dDegreeCentrality"],
    "autoclip": bool,
    "automask": bool,
    "in_file": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "oned_file": typing.NotRequired[str | None],
    "polort": typing.NotRequired[int | None],
    "sparsity": typing.NotRequired[float | None],
    "thresh": typing.NotRequired[float | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dDegreeCentrality": v_3d_degree_centrality_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dDegreeCentrality": v_3d_degree_centrality_outputs,
    }.get(t)


class V3dDegreeCentralityOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_degree_centrality(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_file: OutputPathType
    """Output image file name."""
    oned_file_outfile: OutputPathType | None
    """The text output of the similarity matrix computed after thresholding with
    one-dimensional and ijk voxel indices, correlations, image extents, and
    affine matrix."""


def v_3d_degree_centrality_params(
    in_file: InputPathType,
    autoclip: bool = False,
    automask: bool = False,
    mask: InputPathType | None = None,
    oned_file: str | None = None,
    polort: int | None = None,
    sparsity: float | None = None,
    thresh: float | None = None,
) -> V3dDegreeCentralityParameters:
    """
    Build parameters.
    
    Args:
        in_file: Input file to 3ddegreecentrality.
        autoclip: Clip off low-intensity regions in the dataset.
        automask: Mask the dataset to target brain-only voxels.
        mask: Mask file to mask input data.
        oned_file: Output filepath to text dump of correlation matrix.
        polort: No description provided.
        sparsity: Only take the top percent of connections.
        thresh: Threshold to exclude connections where corr <= thresh.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dDegreeCentrality",
        "autoclip": autoclip,
        "automask": automask,
        "in_file": in_file,
    }
    if mask is not None:
        params["mask"] = mask
    if oned_file is not None:
        params["oned_file"] = oned_file
    if polort is not None:
        params["polort"] = polort
    if sparsity is not None:
        params["sparsity"] = sparsity
    if thresh is not None:
        params["thresh"] = thresh
    return params


def v_3d_degree_centrality_cargs(
    params: V3dDegreeCentralityParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dDegreeCentrality")
    if params.get("autoclip"):
        cargs.append("-autoclip")
    if params.get("automask"):
        cargs.append("-automask")
    cargs.append(execution.input_file(params.get("in_file")))
    if params.get("mask") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask"))
        ])
    if params.get("oned_file") is not None:
        cargs.extend([
            "-out1D",
            params.get("oned_file")
        ])
    if params.get("polort") is not None:
        cargs.extend([
            "-polort",
            str(params.get("polort"))
        ])
    if params.get("sparsity") is not None:
        cargs.extend([
            "-sparsity",
            str(params.get("sparsity"))
        ])
    if params.get("thresh") is not None:
        cargs.extend([
            "-thresh",
            str(params.get("thresh"))
        ])
    return cargs


def v_3d_degree_centrality_outputs(
    params: V3dDegreeCentralityParameters,
    execution: Execution,
) -> V3dDegreeCentralityOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dDegreeCentralityOutputs(
        root=execution.output_file("."),
        out_file=execution.output_file(pathlib.Path(params.get("in_file")).name),
        oned_file_outfile=execution.output_file(params.get("oned_file")) if (params.get("oned_file") is not None) else None,
    )
    return ret


def v_3d_degree_centrality_execute(
    params: V3dDegreeCentralityParameters,
    execution: Execution,
) -> V3dDegreeCentralityOutputs:
    """
    Computes voxelwise weighted and binary degree centrality and stores the result
    in a new 3D bucket dataset as floats to preserve their values. Degree centrality
    reflects the strength and extent of the correlation of a voxel with every other
    voxel in the brain. .
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dDegreeCentralityOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_degree_centrality_cargs(params, execution)
    ret = v_3d_degree_centrality_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_degree_centrality(
    in_file: InputPathType,
    autoclip: bool = False,
    automask: bool = False,
    mask: InputPathType | None = None,
    oned_file: str | None = None,
    polort: int | None = None,
    sparsity: float | None = None,
    thresh: float | None = None,
    runner: Runner | None = None,
) -> V3dDegreeCentralityOutputs:
    """
    Computes voxelwise weighted and binary degree centrality and stores the result
    in a new 3D bucket dataset as floats to preserve their values. Degree centrality
    reflects the strength and extent of the correlation of a voxel with every other
    voxel in the brain. .
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        in_file: Input file to 3ddegreecentrality.
        autoclip: Clip off low-intensity regions in the dataset.
        automask: Mask the dataset to target brain-only voxels.
        mask: Mask file to mask input data.
        oned_file: Output filepath to text dump of correlation matrix.
        polort: No description provided.
        sparsity: Only take the top percent of connections.
        thresh: Threshold to exclude connections where corr <= thresh.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDegreeCentralityOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_DEGREE_CENTRALITY_METADATA)
    params = v_3d_degree_centrality_params(
        autoclip=autoclip,
        automask=automask,
        in_file=in_file,
        mask=mask,
        oned_file=oned_file,
        polort=polort,
        sparsity=sparsity,
        thresh=thresh,
    )
    return v_3d_degree_centrality_execute(params, execution)


__all__ = [
    "V3dDegreeCentralityOutputs",
    "V3dDegreeCentralityParameters",
    "V_3D_DEGREE_CENTRALITY_METADATA",
    "v_3d_degree_centrality",
    "v_3d_degree_centrality_params",
]
