# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_DEPTH_MAP_METADATA = Metadata(
    id="b4b586aabaa0388928e52c39e0a960a38ea18d5b.boutiques",
    name="3dDepthMap",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dDepthMapParameters = typing.TypedDict('V3dDepthMapParameters', {
    "__STYXTYPE__": typing.Literal["3dDepthMap"],
    "input_dataset": InputPathType,
    "output_prefix": str,
    "mask": typing.NotRequired[InputPathType | None],
    "dist_squared": bool,
    "ignore_voxdims": bool,
    "rimify": typing.NotRequired[float | None],
    "zeros_are_zero": bool,
    "zeros_are_neg": bool,
    "nz_are_neg": bool,
    "bounds_are_not_zero": bool,
    "only2D": typing.NotRequired[str | None],
    "binary_only": bool,
    "verbosity": typing.NotRequired[float | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dDepthMap": v_3d_depth_map_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dDepthMap": v_3d_depth_map_outputs,
    }.get(t)


class V3dDepthMapOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_depth_map(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Main output file"""


def v_3d_depth_map_params(
    input_dataset: InputPathType,
    output_prefix: str,
    mask: InputPathType | None = None,
    dist_squared: bool = False,
    ignore_voxdims: bool = False,
    rimify: float | None = None,
    zeros_are_zero: bool = False,
    zeros_are_neg: bool = False,
    nz_are_neg: bool = False,
    bounds_are_not_zero: bool = False,
    only2_d: str | None = None,
    binary_only: bool = False,
    verbosity: float | None = None,
) -> V3dDepthMapParameters:
    """
    Build parameters.
    
    Args:
        input_dataset: Input dataset.
        output_prefix: Output prefix name.
        mask: Mask dataset, applied after the EDT has been calculated.
        dist_squared: Output EDT values as distance squared.
        ignore_voxdims: Ignore voxel dimensions, producing outputs as if each\
            voxel dimension was unity.
        rimify: Output a map of each ROI's boundary layer up to thickness RIM.
        zeros_are_zero: EDT values only reported within nonzero locations of\
            the input dataset.
        zeros_are_neg: EDT values in the zero/background regions will be\
            negative.
        nz_are_neg: EDT values in the nonzero ROI regions will be negative.
        bounds_are_not_zero: Treat FOV boundaries for nonzero ROIs as open\
            (i.e., continue infinitely).
        only2_d: Run EDT in 2D along the specified plane (axi|cor|sag).
        binary_only: Treat the input as a binary mask for a faster calculation.
        verbosity: Manage verbosity when running code (default: 1).
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dDepthMap",
        "input_dataset": input_dataset,
        "output_prefix": output_prefix,
        "dist_squared": dist_squared,
        "ignore_voxdims": ignore_voxdims,
        "zeros_are_zero": zeros_are_zero,
        "zeros_are_neg": zeros_are_neg,
        "nz_are_neg": nz_are_neg,
        "bounds_are_not_zero": bounds_are_not_zero,
        "binary_only": binary_only,
    }
    if mask is not None:
        params["mask"] = mask
    if rimify is not None:
        params["rimify"] = rimify
    if only2_d is not None:
        params["only2D"] = only2_d
    if verbosity is not None:
        params["verbosity"] = verbosity
    return params


def v_3d_depth_map_cargs(
    params: V3dDepthMapParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dDepthMap")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_dataset"))
    ])
    cargs.extend([
        "-prefix",
        params.get("output_prefix")
    ])
    if params.get("mask") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask"))
        ])
    if params.get("dist_squared"):
        cargs.append("-dist_sq")
    if params.get("ignore_voxdims"):
        cargs.append("-ignore_voxdims")
    if params.get("rimify") is not None:
        cargs.extend([
            "-rimify",
            str(params.get("rimify"))
        ])
    if params.get("zeros_are_zero"):
        cargs.append("-zeros_are_zero")
    if params.get("zeros_are_neg"):
        cargs.append("-zeros_are_neg")
    if params.get("nz_are_neg"):
        cargs.append("-nz_are_neg")
    if params.get("bounds_are_not_zero"):
        cargs.append("-bounds_are_not_zero")
    if params.get("only2D") is not None:
        cargs.extend([
            "-only2D",
            params.get("only2D")
        ])
    if params.get("binary_only"):
        cargs.append("-binary_only")
    if params.get("verbosity") is not None:
        cargs.extend([
            "-verb",
            str(params.get("verbosity"))
        ])
    return cargs


def v_3d_depth_map_outputs(
    params: V3dDepthMapParameters,
    execution: Execution,
) -> V3dDepthMapOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dDepthMapOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("output_prefix") + ".nii.gz"),
    )
    return ret


def v_3d_depth_map_execute(
    params: V3dDepthMapParameters,
    execution: Execution,
) -> V3dDepthMapOutputs:
    """
    Calculates the Euclidean Distance Transform (EDT) for 3D volumes, allowing
    computation of ROI depth maps and applying various adjustments like masking and
    rimification.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dDepthMapOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_depth_map_cargs(params, execution)
    ret = v_3d_depth_map_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_depth_map(
    input_dataset: InputPathType,
    output_prefix: str,
    mask: InputPathType | None = None,
    dist_squared: bool = False,
    ignore_voxdims: bool = False,
    rimify: float | None = None,
    zeros_are_zero: bool = False,
    zeros_are_neg: bool = False,
    nz_are_neg: bool = False,
    bounds_are_not_zero: bool = False,
    only2_d: str | None = None,
    binary_only: bool = False,
    verbosity: float | None = None,
    runner: Runner | None = None,
) -> V3dDepthMapOutputs:
    """
    Calculates the Euclidean Distance Transform (EDT) for 3D volumes, allowing
    computation of ROI depth maps and applying various adjustments like masking and
    rimification.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_dataset: Input dataset.
        output_prefix: Output prefix name.
        mask: Mask dataset, applied after the EDT has been calculated.
        dist_squared: Output EDT values as distance squared.
        ignore_voxdims: Ignore voxel dimensions, producing outputs as if each\
            voxel dimension was unity.
        rimify: Output a map of each ROI's boundary layer up to thickness RIM.
        zeros_are_zero: EDT values only reported within nonzero locations of\
            the input dataset.
        zeros_are_neg: EDT values in the zero/background regions will be\
            negative.
        nz_are_neg: EDT values in the nonzero ROI regions will be negative.
        bounds_are_not_zero: Treat FOV boundaries for nonzero ROIs as open\
            (i.e., continue infinitely).
        only2_d: Run EDT in 2D along the specified plane (axi|cor|sag).
        binary_only: Treat the input as a binary mask for a faster calculation.
        verbosity: Manage verbosity when running code (default: 1).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDepthMapOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_DEPTH_MAP_METADATA)
    params = v_3d_depth_map_params(
        input_dataset=input_dataset,
        output_prefix=output_prefix,
        mask=mask,
        dist_squared=dist_squared,
        ignore_voxdims=ignore_voxdims,
        rimify=rimify,
        zeros_are_zero=zeros_are_zero,
        zeros_are_neg=zeros_are_neg,
        nz_are_neg=nz_are_neg,
        bounds_are_not_zero=bounds_are_not_zero,
        only2_d=only2_d,
        binary_only=binary_only,
        verbosity=verbosity,
    )
    return v_3d_depth_map_execute(params, execution)


__all__ = [
    "V3dDepthMapOutputs",
    "V3dDepthMapParameters",
    "V_3D_DEPTH_MAP_METADATA",
    "v_3d_depth_map",
    "v_3d_depth_map_params",
]
