# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_DFT_METADATA = Metadata(
    id="6d9e48bc41131cc9d366a1482d65d7f807be33ce.boutiques",
    name="3dDFT",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dDftParameters = typing.TypedDict('V3dDftParameters', {
    "__STYXTYPE__": typing.Literal["3dDFT"],
    "infile": InputPathType,
    "prefix": str,
    "abs_output": bool,
    "nfft": typing.NotRequired[float | None],
    "detrend": bool,
    "taper": typing.NotRequired[float | None],
    "inverse": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dDFT": v_3d_dft_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dDFT": v_3d_dft_outputs,
    }.get(t)


class V3dDftOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_dft(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    outfile: OutputPathType
    """Output dataset file"""
    outheader: OutputPathType
    """Output dataset header file"""


def v_3d_dft_params(
    infile: InputPathType,
    prefix: str,
    abs_output: bool = False,
    nfft: float | None = None,
    detrend: bool = False,
    taper: float | None = None,
    inverse: bool = False,
) -> V3dDftParameters:
    """
    Build parameters.
    
    Args:
        infile: Input dataset (complex- or float-valued).
        prefix: Prefix for the output file.
        abs_output: Output float dataset = abs(DFT).
        nfft: DFT length (must be >= number of time points).
        detrend: Least-squares remove linear drift before DFT.
        taper: Fraction (0 <= f <= 1) of data to taper at ends (Hamming taper).
        inverse: Perform the inverse DFT.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dDFT",
        "infile": infile,
        "prefix": prefix,
        "abs_output": abs_output,
        "detrend": detrend,
        "inverse": inverse,
    }
    if nfft is not None:
        params["nfft"] = nfft
    if taper is not None:
        params["taper"] = taper
    return params


def v_3d_dft_cargs(
    params: V3dDftParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dDFT")
    cargs.append(execution.input_file(params.get("infile")))
    cargs.extend([
        "-prefix",
        params.get("prefix")
    ])
    if params.get("abs_output"):
        cargs.append("-abs")
    if params.get("nfft") is not None:
        cargs.extend([
            "-nfft",
            str(params.get("nfft"))
        ])
    if params.get("detrend"):
        cargs.append("-detrend")
    if params.get("taper") is not None:
        cargs.extend([
            "-taper",
            str(params.get("taper"))
        ])
    if params.get("inverse"):
        cargs.append("-inverse")
    return cargs


def v_3d_dft_outputs(
    params: V3dDftParameters,
    execution: Execution,
) -> V3dDftOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dDftOutputs(
        root=execution.output_file("."),
        outfile=execution.output_file(params.get("prefix") + "+orig.BRIK"),
        outheader=execution.output_file(params.get("prefix") + "+orig.HEAD"),
    )
    return ret


def v_3d_dft_execute(
    params: V3dDftParameters,
    execution: Execution,
) -> V3dDftOutputs:
    """
    Performs Discrete Fourier Transform (DFT) along the time axis of a complex- or
    float-valued dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dDftOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_dft_cargs(params, execution)
    ret = v_3d_dft_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_dft(
    infile: InputPathType,
    prefix: str,
    abs_output: bool = False,
    nfft: float | None = None,
    detrend: bool = False,
    taper: float | None = None,
    inverse: bool = False,
    runner: Runner | None = None,
) -> V3dDftOutputs:
    """
    Performs Discrete Fourier Transform (DFT) along the time axis of a complex- or
    float-valued dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Input dataset (complex- or float-valued).
        prefix: Prefix for the output file.
        abs_output: Output float dataset = abs(DFT).
        nfft: DFT length (must be >= number of time points).
        detrend: Least-squares remove linear drift before DFT.
        taper: Fraction (0 <= f <= 1) of data to taper at ends (Hamming taper).
        inverse: Perform the inverse DFT.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDftOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_DFT_METADATA)
    params = v_3d_dft_params(
        infile=infile,
        prefix=prefix,
        abs_output=abs_output,
        nfft=nfft,
        detrend=detrend,
        taper=taper,
        inverse=inverse,
    )
    return v_3d_dft_execute(params, execution)


__all__ = [
    "V3dDftOutputs",
    "V3dDftParameters",
    "V_3D_DFT_METADATA",
    "v_3d_dft",
    "v_3d_dft_params",
]
