# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_DWUNCERT_METADATA = Metadata(
    id="36a7630a6addf3cde3da6dc8c065b0d3b2cad85a.boutiques",
    name="3dDWUncert",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dDwuncertParameters = typing.TypedDict('V3dDwuncertParameters', {
    "__STYXTYPE__": typing.Literal["3dDWUncert"],
    "input_file": InputPathType,
    "input_prefix": str,
    "output_prefix": str,
    "grad_file": typing.NotRequired[InputPathType | None],
    "bmatrix_file": typing.NotRequired[InputPathType | None],
    "num_iters": typing.NotRequired[float | None],
    "mask_file": typing.NotRequired[InputPathType | None],
    "calc_thr_fa": typing.NotRequired[float | None],
    "csf_fa": typing.NotRequired[float | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dDWUncert": v_3d_dwuncert_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dDWUncert": v_3d_dwuncert_outputs,
    }.get(t)


class V3dDwuncertOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_dwuncert(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """AFNI-format file with 6 subbricks, containing uncertainty information."""


def v_3d_dwuncert_params(
    input_file: InputPathType,
    input_prefix: str,
    output_prefix: str,
    grad_file: InputPathType | None = None,
    bmatrix_file: InputPathType | None = None,
    num_iters: float | None = None,
    mask_file: InputPathType | None = None,
    calc_thr_fa: float | None = None,
    csf_fa: float | None = None,
) -> V3dDwuncertParameters:
    """
    Build parameters.
    
    Args:
        input_file: Input file with b0 and DWI subbricks.
        input_prefix: Basename of DTI volumes.
        output_prefix: Output file name prefix.
        grad_file: File with 3 columns for x-, y-, and z-comps of DW-gradients.
        bmatrix_file: File with gradient info in b-matrix format.
        num_iters: Number of jackknife resample iterations.
        mask_file: Mask file within which to calculate uncertainty.
        calc_thr_fa: Threshold for the minimum FA value above which to\
            calculate uncertainty.
        csf_fa: Number marking FA value of 'bad' voxels.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dDWUncert",
        "input_file": input_file,
        "input_prefix": input_prefix,
        "output_prefix": output_prefix,
    }
    if grad_file is not None:
        params["grad_file"] = grad_file
    if bmatrix_file is not None:
        params["bmatrix_file"] = bmatrix_file
    if num_iters is not None:
        params["num_iters"] = num_iters
    if mask_file is not None:
        params["mask_file"] = mask_file
    if calc_thr_fa is not None:
        params["calc_thr_fa"] = calc_thr_fa
    if csf_fa is not None:
        params["csf_fa"] = csf_fa
    return params


def v_3d_dwuncert_cargs(
    params: V3dDwuncertParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dDWUncert")
    cargs.extend([
        "-inset",
        execution.input_file(params.get("input_file"))
    ])
    cargs.extend([
        "-input",
        params.get("input_prefix")
    ])
    cargs.extend([
        "-prefix",
        params.get("output_prefix")
    ])
    if params.get("grad_file") is not None:
        cargs.extend([
            "-grads",
            execution.input_file(params.get("grad_file"))
        ])
    if params.get("bmatrix_file") is not None:
        cargs.extend([
            "-bmatrix_FULL",
            execution.input_file(params.get("bmatrix_file"))
        ])
    if params.get("num_iters") is not None:
        cargs.extend([
            "-iters",
            str(params.get("num_iters"))
        ])
    if params.get("mask_file") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask_file"))
        ])
    if params.get("calc_thr_fa") is not None:
        cargs.extend([
            "-calc_thr_FA",
            str(params.get("calc_thr_fa"))
        ])
    if params.get("csf_fa") is not None:
        cargs.extend([
            "-csf_fa",
            str(params.get("csf_fa"))
        ])
    return cargs


def v_3d_dwuncert_outputs(
    params: V3dDwuncertParameters,
    execution: Execution,
) -> V3dDwuncertOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dDwuncertOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("output_prefix") + "+*.HEAD/" + params.get("output_prefix") + "+*.BRIK"),
    )
    return ret


def v_3d_dwuncert_execute(
    params: V3dDwuncertParameters,
    execution: Execution,
) -> V3dDwuncertOutputs:
    """
    Use jackknifing to estimate uncertainty of DTI parameters, important for
    probabilistic tractography.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dDwuncertOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_dwuncert_cargs(params, execution)
    ret = v_3d_dwuncert_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_dwuncert(
    input_file: InputPathType,
    input_prefix: str,
    output_prefix: str,
    grad_file: InputPathType | None = None,
    bmatrix_file: InputPathType | None = None,
    num_iters: float | None = None,
    mask_file: InputPathType | None = None,
    calc_thr_fa: float | None = None,
    csf_fa: float | None = None,
    runner: Runner | None = None,
) -> V3dDwuncertOutputs:
    """
    Use jackknifing to estimate uncertainty of DTI parameters, important for
    probabilistic tractography.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Input file with b0 and DWI subbricks.
        input_prefix: Basename of DTI volumes.
        output_prefix: Output file name prefix.
        grad_file: File with 3 columns for x-, y-, and z-comps of DW-gradients.
        bmatrix_file: File with gradient info in b-matrix format.
        num_iters: Number of jackknife resample iterations.
        mask_file: Mask file within which to calculate uncertainty.
        calc_thr_fa: Threshold for the minimum FA value above which to\
            calculate uncertainty.
        csf_fa: Number marking FA value of 'bad' voxels.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dDwuncertOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_DWUNCERT_METADATA)
    params = v_3d_dwuncert_params(
        input_file=input_file,
        input_prefix=input_prefix,
        output_prefix=output_prefix,
        grad_file=grad_file,
        bmatrix_file=bmatrix_file,
        num_iters=num_iters,
        mask_file=mask_file,
        calc_thr_fa=calc_thr_fa,
        csf_fa=csf_fa,
    )
    return v_3d_dwuncert_execute(params, execution)


__all__ = [
    "V3dDwuncertOutputs",
    "V3dDwuncertParameters",
    "V_3D_DWUNCERT_METADATA",
    "v_3d_dwuncert",
    "v_3d_dwuncert_params",
]
