# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_ECM_METADATA = Metadata(
    id="5765fcd4fd9cde03d3bff59f1b7e35b7ffb1d691.boutiques",
    name="3dECM",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dEcmParameters = typing.TypedDict('V3dEcmParameters', {
    "__STYXTYPE__": typing.Literal["3dECM"],
    "in_file": InputPathType,
    "autoclip": bool,
    "automask": bool,
    "eps": typing.NotRequired[float | None],
    "fecm": bool,
    "full": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "max_iter": typing.NotRequired[int | None],
    "memory": typing.NotRequired[float | None],
    "num_threads": typing.NotRequired[int | None],
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
    "out_file": typing.NotRequired[str | None],
    "polort": typing.NotRequired[int | None],
    "scale": typing.NotRequired[float | None],
    "shift": typing.NotRequired[float | None],
    "sparsity": typing.NotRequired[float | None],
    "thresh": typing.NotRequired[float | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dECM": v_3d_ecm_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dECM": v_3d_ecm_outputs,
    }.get(t)


class V3dEcmOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_ecm(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_file: OutputPathType
    """Output image file name."""
    out_file_: OutputPathType
    """Output file."""


def v_3d_ecm_params(
    in_file: InputPathType,
    autoclip: bool = False,
    automask: bool = False,
    eps: float | None = None,
    fecm: bool = False,
    full: bool = False,
    mask: InputPathType | None = None,
    max_iter: int | None = None,
    memory: float | None = None,
    num_threads: int | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    out_file: str | None = None,
    polort: int | None = None,
    scale: float | None = None,
    shift: float | None = None,
    sparsity: float | None = None,
    thresh: float | None = None,
) -> V3dEcmParameters:
    """
    Build parameters.
    
    Args:
        in_file: Input file to 3decm.
        autoclip: Clip off low-intensity regions in the dataset.
        automask: Mask the dataset to target brain-only voxels.
        eps: Sets the stopping criterion for the power iteration;\
            :math:`l2\\|v_\\text{old} - v_\\text{new}\\| < eps\\|v_\\text{old}\\|`;\
            default = 0.001.
        fecm: Fast centrality method; substantial speed increase but cannot\
            accommodate thresholding; automatically selected if -thresh or\
            -sparsity are not set.
        full: Full power method; enables thresholding; automatically selected\
            if -thresh or -sparsity are set.
        mask: Mask file to mask input data.
        max_iter: Sets the maximum number of iterations to use in the power\
            iteration; default = 1000.
        memory: Limit memory consumption on system by setting the amount of gb\
            to limit the algorithm to; default = 2gb.
        num_threads: Set number of threads.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        out_file: Output image file name.
        polort: No description provided.
        scale: Scale correlation coefficients in similarity matrix to after\
            shifting, x >= 0.0; default = 1.0 for -full, 0.5 for -fecm.
        shift: Shift correlation coefficients in similarity matrix to enforce\
            non-negativity, s >= 0.0; default = 0.0 for -full, 1.0 for -fecm.
        sparsity: Only take the top percent of connections.
        thresh: Threshold to exclude connections where corr <= thresh.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dECM",
        "in_file": in_file,
        "autoclip": autoclip,
        "automask": automask,
        "fecm": fecm,
        "full": full,
    }
    if eps is not None:
        params["eps"] = eps
    if mask is not None:
        params["mask"] = mask
    if max_iter is not None:
        params["max_iter"] = max_iter
    if memory is not None:
        params["memory"] = memory
    if num_threads is not None:
        params["num_threads"] = num_threads
    if outputtype is not None:
        params["outputtype"] = outputtype
    if out_file is not None:
        params["out_file"] = out_file
    if polort is not None:
        params["polort"] = polort
    if scale is not None:
        params["scale"] = scale
    if shift is not None:
        params["shift"] = shift
    if sparsity is not None:
        params["sparsity"] = sparsity
    if thresh is not None:
        params["thresh"] = thresh
    return params


def v_3d_ecm_cargs(
    params: V3dEcmParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dECM")
    cargs.append(execution.input_file(params.get("in_file")))
    if params.get("autoclip"):
        cargs.append("-autoclip")
    if params.get("automask"):
        cargs.append("-automask")
    if params.get("eps") is not None:
        cargs.extend([
            "-eps",
            str(params.get("eps"))
        ])
    if params.get("fecm"):
        cargs.append("-fecm")
    if params.get("full"):
        cargs.append("-full")
    if params.get("mask") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask"))
        ])
    if params.get("max_iter") is not None:
        cargs.extend([
            "-max_iter",
            str(params.get("max_iter"))
        ])
    if params.get("memory") is not None:
        cargs.extend([
            "-memory",
            str(params.get("memory"))
        ])
    if params.get("num_threads") is not None:
        cargs.append(str(params.get("num_threads")))
    if params.get("outputtype") is not None:
        cargs.append(params.get("outputtype"))
    if params.get("out_file") is not None:
        cargs.extend([
            "-prefix",
            params.get("out_file")
        ])
    if params.get("polort") is not None:
        cargs.extend([
            "-polort",
            str(params.get("polort"))
        ])
    if params.get("scale") is not None:
        cargs.extend([
            "-scale",
            str(params.get("scale"))
        ])
    if params.get("shift") is not None:
        cargs.extend([
            "-shift",
            str(params.get("shift"))
        ])
    if params.get("sparsity") is not None:
        cargs.extend([
            "-sparsity",
            str(params.get("sparsity"))
        ])
    if params.get("thresh") is not None:
        cargs.extend([
            "-thresh",
            str(params.get("thresh"))
        ])
    return cargs


def v_3d_ecm_outputs(
    params: V3dEcmParameters,
    execution: Execution,
) -> V3dEcmOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dEcmOutputs(
        root=execution.output_file("."),
        out_file=execution.output_file(pathlib.Path(params.get("in_file")).name + "_afni"),
        out_file_=execution.output_file("out_file"),
    )
    return ret


def v_3d_ecm_execute(
    params: V3dEcmParameters,
    execution: Execution,
) -> V3dEcmOutputs:
    """
    Performs degree centrality on a dataset using a given maskfile via the 3dECM
    command.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dEcmOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_ecm_cargs(params, execution)
    ret = v_3d_ecm_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_ecm(
    in_file: InputPathType,
    autoclip: bool = False,
    automask: bool = False,
    eps: float | None = None,
    fecm: bool = False,
    full: bool = False,
    mask: InputPathType | None = None,
    max_iter: int | None = None,
    memory: float | None = None,
    num_threads: int | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    out_file: str | None = None,
    polort: int | None = None,
    scale: float | None = None,
    shift: float | None = None,
    sparsity: float | None = None,
    thresh: float | None = None,
    runner: Runner | None = None,
) -> V3dEcmOutputs:
    """
    Performs degree centrality on a dataset using a given maskfile via the 3dECM
    command.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        in_file: Input file to 3decm.
        autoclip: Clip off low-intensity regions in the dataset.
        automask: Mask the dataset to target brain-only voxels.
        eps: Sets the stopping criterion for the power iteration;\
            :math:`l2\\|v_\\text{old} - v_\\text{new}\\| < eps\\|v_\\text{old}\\|`;\
            default = 0.001.
        fecm: Fast centrality method; substantial speed increase but cannot\
            accommodate thresholding; automatically selected if -thresh or\
            -sparsity are not set.
        full: Full power method; enables thresholding; automatically selected\
            if -thresh or -sparsity are set.
        mask: Mask file to mask input data.
        max_iter: Sets the maximum number of iterations to use in the power\
            iteration; default = 1000.
        memory: Limit memory consumption on system by setting the amount of gb\
            to limit the algorithm to; default = 2gb.
        num_threads: Set number of threads.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        out_file: Output image file name.
        polort: No description provided.
        scale: Scale correlation coefficients in similarity matrix to after\
            shifting, x >= 0.0; default = 1.0 for -full, 0.5 for -fecm.
        shift: Shift correlation coefficients in similarity matrix to enforce\
            non-negativity, s >= 0.0; default = 0.0 for -full, 1.0 for -fecm.
        sparsity: Only take the top percent of connections.
        thresh: Threshold to exclude connections where corr <= thresh.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dEcmOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_ECM_METADATA)
    params = v_3d_ecm_params(
        in_file=in_file,
        autoclip=autoclip,
        automask=automask,
        eps=eps,
        fecm=fecm,
        full=full,
        mask=mask,
        max_iter=max_iter,
        memory=memory,
        num_threads=num_threads,
        outputtype=outputtype,
        out_file=out_file,
        polort=polort,
        scale=scale,
        shift=shift,
        sparsity=sparsity,
        thresh=thresh,
    )
    return v_3d_ecm_execute(params, execution)


__all__ = [
    "V3dEcmOutputs",
    "V3dEcmParameters",
    "V_3D_ECM_METADATA",
    "v_3d_ecm",
    "v_3d_ecm_params",
]
