# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_EDU_01_SCALE_METADATA = Metadata(
    id="882d93a008679bc5297ea9ae14de61c1a4182b85.boutiques",
    name="3dEdu_01_scale",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dEdu01ScaleParameters = typing.TypedDict('V3dEdu01ScaleParameters', {
    "__STYXTYPE__": typing.Literal["3dEdu_01_scale"],
    "input": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "mult_factors": typing.NotRequired[list[float] | None],
    "option_flag": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dEdu_01_scale": v_3d_edu_01_scale_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dEdu_01_scale": v_3d_edu_01_scale_outputs,
    }.get(t)


class V3dEdu01ScaleOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_edu_01_scale(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    outfile: OutputPathType
    """Output scaled and/or masked copy of the [0]th volume of the input
    dataset"""


def v_3d_edu_01_scale_params(
    input_: InputPathType,
    mask: InputPathType | None = None,
    mult_factors: list[float] | None = None,
    option_flag: bool = False,
) -> V3dEdu01ScaleParameters:
    """
    Build parameters.
    
    Args:
        input_: Input dataset.
        mask: Mask dataset on same grid/data structure as the input dataset.
        mult_factors: Numerical factors for multiplying each voxel; each voxel\
            is multiplied by both A and B.
        option_flag: Option flag to do something.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dEdu_01_scale",
        "input": input_,
        "option_flag": option_flag,
    }
    if mask is not None:
        params["mask"] = mask
    if mult_factors is not None:
        params["mult_factors"] = mult_factors
    return params


def v_3d_edu_01_scale_cargs(
    params: V3dEdu01ScaleParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dEdu_01_scale")
    cargs.append(execution.input_file(params.get("input")))
    if params.get("mask") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask"))
        ])
    if params.get("mult_factors") is not None:
        cargs.extend([
            "-mult_facs",
            *map(str, params.get("mult_factors"))
        ])
    if params.get("option_flag"):
        cargs.append("-some_opt")
    return cargs


def v_3d_edu_01_scale_outputs(
    params: V3dEdu01ScaleParameters,
    execution: Execution,
) -> V3dEdu01ScaleOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dEdu01ScaleOutputs(
        root=execution.output_file("."),
        outfile=execution.output_file("OUT_edu_[1-9]*"),
    )
    return ret


def v_3d_edu_01_scale_execute(
    params: V3dEdu01ScaleParameters,
    execution: Execution,
) -> V3dEdu01ScaleOutputs:
    """
    Educational program to create a new AFNI program. Scales and masks dataset
    volumes.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dEdu01ScaleOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_edu_01_scale_cargs(params, execution)
    ret = v_3d_edu_01_scale_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_edu_01_scale(
    input_: InputPathType,
    mask: InputPathType | None = None,
    mult_factors: list[float] | None = None,
    option_flag: bool = False,
    runner: Runner | None = None,
) -> V3dEdu01ScaleOutputs:
    """
    Educational program to create a new AFNI program. Scales and masks dataset
    volumes.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_: Input dataset.
        mask: Mask dataset on same grid/data structure as the input dataset.
        mult_factors: Numerical factors for multiplying each voxel; each voxel\
            is multiplied by both A and B.
        option_flag: Option flag to do something.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dEdu01ScaleOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_EDU_01_SCALE_METADATA)
    params = v_3d_edu_01_scale_params(
        input_=input_,
        mask=mask,
        mult_factors=mult_factors,
        option_flag=option_flag,
    )
    return v_3d_edu_01_scale_execute(params, execution)


__all__ = [
    "V3dEdu01ScaleOutputs",
    "V3dEdu01ScaleParameters",
    "V_3D_EDU_01_SCALE_METADATA",
    "v_3d_edu_01_scale",
    "v_3d_edu_01_scale_params",
]
