# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_EXCHANGE_METADATA = Metadata(
    id="8ebdac99ebedc55c0168065b2a71ca0f78056aac.boutiques",
    name="3dExchange",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dExchangeParameters = typing.TypedDict('V3dExchangeParameters', {
    "__STYXTYPE__": typing.Literal["3dExchange"],
    "prefix": str,
    "infile": InputPathType,
    "mapfile": InputPathType,
    "version": bool,
    "help": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dExchange": v_3d_exchange_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dExchange": v_3d_exchange_outputs,
    }.get(t)


class V3dExchangeOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_exchange(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_head: OutputPathType
    """Output HEAD file"""
    output_brik: OutputPathType
    """Output BRIK file"""


def v_3d_exchange_params(
    prefix: str,
    infile: InputPathType,
    mapfile: InputPathType,
    version: bool = False,
    help_: bool = False,
) -> V3dExchangeParameters:
    """
    Build parameters.
    
    Args:
        prefix: Output prefix.
        infile: Input dataset. Acceptable data types are byte, short, and\
            floats.
        mapfile: Mapping columns. Input values in the first column, output\
            values in the second column.
        version: Print author and version info.
        help_: Print this help screen.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dExchange",
        "prefix": prefix,
        "infile": infile,
        "mapfile": mapfile,
        "version": version,
        "help": help_,
    }
    return params


def v_3d_exchange_cargs(
    params: V3dExchangeParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dExchange")
    cargs.extend([
        "-prefix",
        params.get("prefix")
    ])
    cargs.extend([
        "-input",
        execution.input_file(params.get("infile"))
    ])
    cargs.extend([
        "-map",
        execution.input_file(params.get("mapfile"))
    ])
    if params.get("version"):
        cargs.append("-ver")
    if params.get("help"):
        cargs.append("-help")
    return cargs


def v_3d_exchange_outputs(
    params: V3dExchangeParameters,
    execution: Execution,
) -> V3dExchangeOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dExchangeOutputs(
        root=execution.output_file("."),
        output_head=execution.output_file(params.get("prefix") + "+orig.HEAD"),
        output_brik=execution.output_file(params.get("prefix") + "+orig.BRIK"),
    )
    return ret


def v_3d_exchange_execute(
    params: V3dExchangeParameters,
    execution: Execution,
) -> V3dExchangeOutputs:
    """
    Replaces voxel values using a mapping file with specified columns.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dExchangeOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_exchange_cargs(params, execution)
    ret = v_3d_exchange_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_exchange(
    prefix: str,
    infile: InputPathType,
    mapfile: InputPathType,
    version: bool = False,
    help_: bool = False,
    runner: Runner | None = None,
) -> V3dExchangeOutputs:
    """
    Replaces voxel values using a mapping file with specified columns.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Output prefix.
        infile: Input dataset. Acceptable data types are byte, short, and\
            floats.
        mapfile: Mapping columns. Input values in the first column, output\
            values in the second column.
        version: Print author and version info.
        help_: Print this help screen.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dExchangeOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_EXCHANGE_METADATA)
    params = v_3d_exchange_params(
        prefix=prefix,
        infile=infile,
        mapfile=mapfile,
        version=version,
        help_=help_,
    )
    return v_3d_exchange_execute(params, execution)


__all__ = [
    "V3dExchangeOutputs",
    "V3dExchangeParameters",
    "V_3D_EXCHANGE_METADATA",
    "v_3d_exchange",
    "v_3d_exchange_params",
]
