# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_FDR_METADATA = Metadata(
    id="aabaf1707d0311895de132618ad782f134d28f72.boutiques",
    name="3dFDR",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dFdrParameters = typing.TypedDict('V3dFdrParameters', {
    "__STYXTYPE__": typing.Literal["3dFDR"],
    "input_file": InputPathType,
    "input1d_file": typing.NotRequired[InputPathType | None],
    "mask_file": typing.NotRequired[InputPathType | None],
    "mask_threshold": typing.NotRequired[float | None],
    "constant_type": typing.NotRequired[typing.Literal["cind", "cdep"] | None],
    "quiet": bool,
    "list": bool,
    "prefix": str,
    "mode_option": typing.NotRequired[typing.Literal["old", "new"] | None],
    "pmask": bool,
    "nopmask": bool,
    "force": bool,
    "float": bool,
    "qval": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dFDR": v_3d_fdr_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dFDR": v_3d_fdr_outputs,
    }.get(t)


class V3dFdrOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_fdr(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_brik: OutputPathType
    """Output dataset in BRIK format"""
    output_head: OutputPathType
    """Output dataset in HEAD format"""
    output_1d: OutputPathType
    """Output list of voxel q-values"""


def v_3d_fdr_params(
    input_file: InputPathType,
    prefix: str,
    input1d_file: InputPathType | None = None,
    mask_file: InputPathType | None = None,
    mask_threshold: float | None = None,
    constant_type: typing.Literal["cind", "cdep"] | None = None,
    quiet: bool = False,
    list_: bool = False,
    mode_option: typing.Literal["old", "new"] | None = None,
    pmask: bool = False,
    nopmask: bool = False,
    force: bool = False,
    float_: bool = False,
    qval: bool = False,
) -> V3dFdrParameters:
    """
    Build parameters.
    
    Args:
        input_file: Input 3D functional dataset filename.
        prefix: Use 'pname' for the output dataset prefix name.
        input1d_file: .1D file containing column of p-values.
        mask_file: Use mask values from file mname. If file mname contains more\
            than 1 sub-brick, the mask sub-brick must be specified. Generally\
            should be used to avoid counting non-brain voxels.
        mask_threshold: Only voxels whose corresponding mask value is greater\
            than or equal to the specified value in absolute terms will be\
            considered. Default is 1.
        constant_type: Set constant c(N): 1 for independent p-values (default)\
            or sum(1/i, i=1,...,N) for any joint distribution.
        quiet: Suppress screen output.
        list_: Write sorted list of voxel q-values to screen.
        mode_option: Use the old or new mode of operation. 'new' is now the\
            default.
        pmask: Ignore p=1 voxels (default in new mode).
        nopmask: Count p=1 voxels (default in old mode).
        force: Force conversion of all sub-bricks, treating them as p-values.
        float_: Force the output of z-scores in floating point format.
        qval: Force the output of q-values rather than z-scores.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dFDR",
        "input_file": input_file,
        "quiet": quiet,
        "list": list_,
        "prefix": prefix,
        "pmask": pmask,
        "nopmask": nopmask,
        "force": force,
        "float": float_,
        "qval": qval,
    }
    if input1d_file is not None:
        params["input1d_file"] = input1d_file
    if mask_file is not None:
        params["mask_file"] = mask_file
    if mask_threshold is not None:
        params["mask_threshold"] = mask_threshold
    if constant_type is not None:
        params["constant_type"] = constant_type
    if mode_option is not None:
        params["mode_option"] = mode_option
    return params


def v_3d_fdr_cargs(
    params: V3dFdrParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dFDR")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_file"))
    ])
    if params.get("input1d_file") is not None:
        cargs.extend([
            "-input1D",
            execution.input_file(params.get("input1d_file"))
        ])
    if params.get("mask_file") is not None:
        cargs.extend([
            "-mask_file",
            execution.input_file(params.get("mask_file"))
        ])
    if params.get("mask_threshold") is not None:
        cargs.extend([
            "-mask_thr",
            str(params.get("mask_threshold"))
        ])
    if params.get("constant_type") is not None:
        cargs.extend([
            "-c",
            params.get("constant_type")
        ])
    if params.get("quiet"):
        cargs.append("-quiet")
    if params.get("list"):
        cargs.append("-list")
    cargs.extend([
        "-prefix",
        params.get("prefix")
    ])
    if params.get("mode_option") is not None:
        cargs.extend([
            "-",
            params.get("mode_option")
        ])
    if params.get("pmask"):
        cargs.append("-pmask")
    if params.get("nopmask"):
        cargs.append("-nopmask")
    if params.get("force"):
        cargs.append("-force")
    if params.get("float"):
        cargs.append("-float")
    if params.get("qval"):
        cargs.append("-qval")
    return cargs


def v_3d_fdr_outputs(
    params: V3dFdrParameters,
    execution: Execution,
) -> V3dFdrOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dFdrOutputs(
        root=execution.output_file("."),
        output_brik=execution.output_file(params.get("prefix") + "+orig.BRIK"),
        output_head=execution.output_file(params.get("prefix") + "+orig.HEAD"),
        output_1d=execution.output_file(params.get("prefix") + ".1D"),
    )
    return ret


def v_3d_fdr_execute(
    params: V3dFdrParameters,
    execution: Execution,
) -> V3dFdrOutputs:
    """
    A tool for applying False Discovery Rate (FDR) thresholding to voxelwise
    statistics in 3D functional datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dFdrOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_fdr_cargs(params, execution)
    ret = v_3d_fdr_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_fdr(
    input_file: InputPathType,
    prefix: str,
    input1d_file: InputPathType | None = None,
    mask_file: InputPathType | None = None,
    mask_threshold: float | None = None,
    constant_type: typing.Literal["cind", "cdep"] | None = None,
    quiet: bool = False,
    list_: bool = False,
    mode_option: typing.Literal["old", "new"] | None = None,
    pmask: bool = False,
    nopmask: bool = False,
    force: bool = False,
    float_: bool = False,
    qval: bool = False,
    runner: Runner | None = None,
) -> V3dFdrOutputs:
    """
    A tool for applying False Discovery Rate (FDR) thresholding to voxelwise
    statistics in 3D functional datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Input 3D functional dataset filename.
        prefix: Use 'pname' for the output dataset prefix name.
        input1d_file: .1D file containing column of p-values.
        mask_file: Use mask values from file mname. If file mname contains more\
            than 1 sub-brick, the mask sub-brick must be specified. Generally\
            should be used to avoid counting non-brain voxels.
        mask_threshold: Only voxels whose corresponding mask value is greater\
            than or equal to the specified value in absolute terms will be\
            considered. Default is 1.
        constant_type: Set constant c(N): 1 for independent p-values (default)\
            or sum(1/i, i=1,...,N) for any joint distribution.
        quiet: Suppress screen output.
        list_: Write sorted list of voxel q-values to screen.
        mode_option: Use the old or new mode of operation. 'new' is now the\
            default.
        pmask: Ignore p=1 voxels (default in new mode).
        nopmask: Count p=1 voxels (default in old mode).
        force: Force conversion of all sub-bricks, treating them as p-values.
        float_: Force the output of z-scores in floating point format.
        qval: Force the output of q-values rather than z-scores.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dFdrOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_FDR_METADATA)
    params = v_3d_fdr_params(
        input_file=input_file,
        input1d_file=input1d_file,
        mask_file=mask_file,
        mask_threshold=mask_threshold,
        constant_type=constant_type,
        quiet=quiet,
        list_=list_,
        prefix=prefix,
        mode_option=mode_option,
        pmask=pmask,
        nopmask=nopmask,
        force=force,
        float_=float_,
        qval=qval,
    )
    return v_3d_fdr_execute(params, execution)


__all__ = [
    "V3dFdrOutputs",
    "V3dFdrParameters",
    "V_3D_FDR_METADATA",
    "v_3d_fdr",
    "v_3d_fdr_params",
]
