# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_FFT_METADATA = Metadata(
    id="251cf31407b8d42f4fb6ef0851808d440783f20f.boutiques",
    name="3dFFT",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dFftParameters = typing.TypedDict('V3dFftParameters', {
    "__STYXTYPE__": typing.Literal["3dFFT"],
    "dataset": InputPathType,
    "abs": bool,
    "phase": bool,
    "complex": bool,
    "inverse": bool,
    "Lx": typing.NotRequired[float | None],
    "Ly": typing.NotRequired[float | None],
    "Lz": typing.NotRequired[float | None],
    "altIN": bool,
    "altOUT": bool,
    "input": typing.NotRequired[InputPathType | None],
    "prefix": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dFFT": v_3d_fft_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dFFT": v_3d_fft_outputs,
    }.get(t)


class V3dFftOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_fft(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_dataset: OutputPathType | None
    """Output dataset generated by 3dFFT."""


def v_3d_fft_params(
    dataset: InputPathType,
    abs_: bool = False,
    phase: bool = False,
    complex_: bool = False,
    inverse: bool = False,
    lx: float | None = None,
    ly: float | None = None,
    lz: float | None = None,
    alt_in: bool = False,
    alt_out: bool = False,
    input_: InputPathType | None = None,
    prefix: str | None = None,
) -> V3dFftParameters:
    """
    Build parameters.
    
    Args:
        dataset: Input dataset (e.g., dataset.nii).
        abs_: Outputs the magnitude of the FFT (default).
        phase: Outputs the phase of the FFT (-PI..PI).
        complex_: Outputs the complex-valued FFT.
        inverse: Does the inverse FFT instead of the forward FFT.
        lx: Use FFT of length 'xx' in the x-direction.
        ly: Use FFT of length 'yy' in the y-direction.
        lz: Use FFT of length 'zz' in the z-direction.
        alt_in: Alternate signs of input data before FFT to bring zero\
            frequency from edge of FFT-space to center of grid for cosmetic\
            purposes.
        alt_out: Alternate signs of output data after FFT. Use '-altOUT' with\
            '-altIN' on the forward transform to get the signs of the recovered\
            image correct.
        input_: Read the input dataset from specified file instead of from the\
            last argument on the command line.
        prefix: Use specified prefix for the output dataset.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dFFT",
        "dataset": dataset,
        "abs": abs_,
        "phase": phase,
        "complex": complex_,
        "inverse": inverse,
        "altIN": alt_in,
        "altOUT": alt_out,
    }
    if lx is not None:
        params["Lx"] = lx
    if ly is not None:
        params["Ly"] = ly
    if lz is not None:
        params["Lz"] = lz
    if input_ is not None:
        params["input"] = input_
    if prefix is not None:
        params["prefix"] = prefix
    return params


def v_3d_fft_cargs(
    params: V3dFftParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dFFT")
    cargs.append(execution.input_file(params.get("dataset")))
    if params.get("abs"):
        cargs.append("--abs")
    if params.get("phase"):
        cargs.append("--phase")
    if params.get("complex"):
        cargs.append("--complex")
    if params.get("inverse"):
        cargs.append("--inverse")
    if params.get("Lx") is not None:
        cargs.extend([
            "--Lx",
            str(params.get("Lx"))
        ])
    if params.get("Ly") is not None:
        cargs.extend([
            "--Ly",
            str(params.get("Ly"))
        ])
    if params.get("Lz") is not None:
        cargs.extend([
            "--Lz",
            str(params.get("Lz"))
        ])
    if params.get("altIN"):
        cargs.append("--altIN")
    if params.get("altOUT"):
        cargs.append("--altOUT")
    if params.get("input") is not None:
        cargs.extend([
            "--input",
            execution.input_file(params.get("input"))
        ])
    if params.get("prefix") is not None:
        cargs.extend([
            "--prefix",
            params.get("prefix")
        ])
    return cargs


def v_3d_fft_outputs(
    params: V3dFftParameters,
    execution: Execution,
) -> V3dFftOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dFftOutputs(
        root=execution.output_file("."),
        output_dataset=execution.output_file(params.get("prefix") + ".nii.gz") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_fft_execute(
    params: V3dFftParameters,
    execution: Execution,
) -> V3dFftOutputs:
    """
    Performs the FFT of the input dataset in 3 directions (x, y, z) and produces the
    output dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dFftOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_fft_cargs(params, execution)
    ret = v_3d_fft_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_fft(
    dataset: InputPathType,
    abs_: bool = False,
    phase: bool = False,
    complex_: bool = False,
    inverse: bool = False,
    lx: float | None = None,
    ly: float | None = None,
    lz: float | None = None,
    alt_in: bool = False,
    alt_out: bool = False,
    input_: InputPathType | None = None,
    prefix: str | None = None,
    runner: Runner | None = None,
) -> V3dFftOutputs:
    """
    Performs the FFT of the input dataset in 3 directions (x, y, z) and produces the
    output dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input dataset (e.g., dataset.nii).
        abs_: Outputs the magnitude of the FFT (default).
        phase: Outputs the phase of the FFT (-PI..PI).
        complex_: Outputs the complex-valued FFT.
        inverse: Does the inverse FFT instead of the forward FFT.
        lx: Use FFT of length 'xx' in the x-direction.
        ly: Use FFT of length 'yy' in the y-direction.
        lz: Use FFT of length 'zz' in the z-direction.
        alt_in: Alternate signs of input data before FFT to bring zero\
            frequency from edge of FFT-space to center of grid for cosmetic\
            purposes.
        alt_out: Alternate signs of output data after FFT. Use '-altOUT' with\
            '-altIN' on the forward transform to get the signs of the recovered\
            image correct.
        input_: Read the input dataset from specified file instead of from the\
            last argument on the command line.
        prefix: Use specified prefix for the output dataset.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dFftOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_FFT_METADATA)
    params = v_3d_fft_params(
        dataset=dataset,
        abs_=abs_,
        phase=phase,
        complex_=complex_,
        inverse=inverse,
        lx=lx,
        ly=ly,
        lz=lz,
        alt_in=alt_in,
        alt_out=alt_out,
        input_=input_,
        prefix=prefix,
    )
    return v_3d_fft_execute(params, execution)


__all__ = [
    "V3dFftOutputs",
    "V3dFftParameters",
    "V_3D_FFT_METADATA",
    "v_3d_fft",
    "v_3d_fft_params",
]
