# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_LME_METADATA = Metadata(
    id="f4d10c5d90b0f7b7397fa43e05d3c57da29fce2c.boutiques",
    name="3dLME",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dLmeParameters = typing.TypedDict('V3dLmeParameters', {
    "__STYXTYPE__": typing.Literal["3dLME"],
    "PREFIX": str,
    "MODEL": str,
    "DATA_TABLE": str,
    "BOUNDS": typing.NotRequired[list[float] | None],
    "CIO_FLAG": bool,
    "COR_STR": typing.NotRequired[str | None],
    "CUTOFF": typing.NotRequired[float | None],
    "DBG_ARGS_FLAG": bool,
    "JOBS": typing.NotRequired[float | None],
    "GLT_CODE": typing.NotRequired[str | None],
    "GLT_LABEL": typing.NotRequired[str | None],
    "GLF_LABEL": typing.NotRequired[str | None],
    "GLF_CODE": typing.NotRequired[str | None],
    "ICC_FLAG": bool,
    "ICCB_FLAG": bool,
    "LOG_LIK_FLAG": bool,
    "LOGIT_FLAG": bool,
    "ML_FLAG": bool,
    "QVARS_CENTERS": typing.NotRequired[str | None],
    "QVARS": typing.NotRequired[str | None],
    "RANEFF": typing.NotRequired[str | None],
    "MASK": typing.NotRequired[InputPathType | None],
    "NUM_GLF": typing.NotRequired[float | None],
    "NUM_GLT": typing.NotRequired[float | None],
    "RESID": typing.NotRequired[str | None],
    "RE": typing.NotRequired[str | None],
    "REPREFIX": typing.NotRequired[str | None],
    "RIO_FLAG": bool,
    "SHOW_OPTIONS_FLAG": bool,
    "SS_TYPE": typing.NotRequired[float | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dLME": v_3d_lme_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dLME": v_3d_lme_outputs,
    }.get(t)


class V3dLmeOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_lme(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_nifti: OutputPathType
    """Output file in NIfTI format"""


def v_3d_lme_params(
    prefix: str,
    model: str,
    data_table: str,
    bounds: list[float] | None = None,
    cio_flag: bool = False,
    cor_str: str | None = None,
    cutoff: float | None = None,
    dbg_args_flag: bool = False,
    jobs: float | None = None,
    glt_code: str | None = None,
    glt_label: str | None = None,
    glf_label: str | None = None,
    glf_code: str | None = None,
    icc_flag: bool = False,
    iccb_flag: bool = False,
    log_lik_flag: bool = False,
    logit_flag: bool = False,
    ml_flag: bool = False,
    qvars_centers: str | None = None,
    qvars: str | None = None,
    raneff: str | None = None,
    mask: InputPathType | None = None,
    num_glf: float | None = None,
    num_glt: float | None = None,
    resid: str | None = None,
    re_: str | None = None,
    reprefix: str | None = None,
    rio_flag: bool = False,
    show_options_flag: bool = False,
    ss_type: float | None = None,
) -> V3dLmeParameters:
    """
    Build parameters.
    
    Args:
        prefix: Prefix for output files.
        model: Model formula describing the fixed effects.
        data_table: Data table description.
        bounds: Lower and upper bounds for outlier removal.
        cio_flag: Use AFNI's C io functions (default) or R's io functions with\
            -Rio.
        cor_str: Specify the correlation structure of the residuals.
        cutoff: Specify the cutoff value for accuracy in logistic regression\
            analysis.
        dbg_args_flag: Enable saving parameters for debugging.
        jobs: Number of jobs for parallel computing.
        glt_code: General linear test coding.
        glt_label: Label for general linear test.
        glf_label: Label for general linear F-test.
        glf_code: General linear F-test coding.
        icc_flag: Compute voxel-wise intra-class correlation.
        iccb_flag: Compute voxel-wise intra-class correlation with Bayesian\
            approach.
        log_lik_flag: Include voxel-wise log likelihood in the output.
        logit_flag: Perform voxel-wise logistic modeling.
        ml_flag: Use Maximum Likelihood estimation instead of REML.
        qvars_centers: Centering values for quantitative variables.
        qvars: Identify quantitative variables (or covariates).
        raneff: Specify the random effects.
        mask: Mask file for voxel processing.
        num_glf: Number of general linear F-tests.
        num_glt: Number of general linear t-tests.
        resid: Prefix for residuals output file.
        re_: List of variables whose random effects are saved in the output.
        reprefix: Prefix for random effects output file.
        rio_flag: Use R's io functions instead of AFNI's C io functions.
        show_options_flag: List of allowed options.
        ss_type: Specify the type for sums of squares in the F-statistics.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dLME",
        "PREFIX": prefix,
        "MODEL": model,
        "DATA_TABLE": data_table,
        "CIO_FLAG": cio_flag,
        "DBG_ARGS_FLAG": dbg_args_flag,
        "ICC_FLAG": icc_flag,
        "ICCB_FLAG": iccb_flag,
        "LOG_LIK_FLAG": log_lik_flag,
        "LOGIT_FLAG": logit_flag,
        "ML_FLAG": ml_flag,
        "RIO_FLAG": rio_flag,
        "SHOW_OPTIONS_FLAG": show_options_flag,
    }
    if bounds is not None:
        params["BOUNDS"] = bounds
    if cor_str is not None:
        params["COR_STR"] = cor_str
    if cutoff is not None:
        params["CUTOFF"] = cutoff
    if jobs is not None:
        params["JOBS"] = jobs
    if glt_code is not None:
        params["GLT_CODE"] = glt_code
    if glt_label is not None:
        params["GLT_LABEL"] = glt_label
    if glf_label is not None:
        params["GLF_LABEL"] = glf_label
    if glf_code is not None:
        params["GLF_CODE"] = glf_code
    if qvars_centers is not None:
        params["QVARS_CENTERS"] = qvars_centers
    if qvars is not None:
        params["QVARS"] = qvars
    if raneff is not None:
        params["RANEFF"] = raneff
    if mask is not None:
        params["MASK"] = mask
    if num_glf is not None:
        params["NUM_GLF"] = num_glf
    if num_glt is not None:
        params["NUM_GLT"] = num_glt
    if resid is not None:
        params["RESID"] = resid
    if re_ is not None:
        params["RE"] = re_
    if reprefix is not None:
        params["REPREFIX"] = reprefix
    if ss_type is not None:
        params["SS_TYPE"] = ss_type
    return params


def v_3d_lme_cargs(
    params: V3dLmeParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dLME")
    cargs.extend([
        "-prefix",
        params.get("PREFIX")
    ])
    cargs.extend([
        "-model",
        params.get("MODEL")
    ])
    cargs.extend([
        "-dataTable",
        params.get("DATA_TABLE")
    ])
    if params.get("BOUNDS") is not None:
        cargs.extend([
            "-bounds",
            *map(str, params.get("BOUNDS"))
        ])
    if params.get("CIO_FLAG"):
        cargs.append("-cio")
    if params.get("COR_STR") is not None:
        cargs.extend([
            "-corStr",
            params.get("COR_STR")
        ])
    if params.get("CUTOFF") is not None:
        cargs.extend([
            "-cutoff",
            str(params.get("CUTOFF"))
        ])
    if params.get("DBG_ARGS_FLAG"):
        cargs.append("-dbgArgs")
    if params.get("JOBS") is not None:
        cargs.extend([
            "-jobs",
            str(params.get("JOBS"))
        ])
    if params.get("GLT_CODE") is not None:
        cargs.extend([
            "-gltCode",
            params.get("GLT_CODE")
        ])
    if params.get("GLT_LABEL") is not None:
        cargs.extend([
            "-gltLabel",
            params.get("GLT_LABEL")
        ])
    if params.get("GLF_LABEL") is not None:
        cargs.extend([
            "-glfLabel",
            params.get("GLF_LABEL")
        ])
    if params.get("GLF_CODE") is not None:
        cargs.extend([
            "-glfCode",
            params.get("GLF_CODE")
        ])
    if params.get("ICC_FLAG"):
        cargs.append("-ICC")
    if params.get("ICCB_FLAG"):
        cargs.append("-ICCb")
    if params.get("LOG_LIK_FLAG"):
        cargs.append("-logLik")
    if params.get("LOGIT_FLAG"):
        cargs.append("-LOGIT")
    if params.get("ML_FLAG"):
        cargs.append("-ML")
    if params.get("QVARS_CENTERS") is not None:
        cargs.extend([
            "-qVarsCenters",
            params.get("QVARS_CENTERS")
        ])
    if params.get("QVARS") is not None:
        cargs.extend([
            "-qVars",
            params.get("QVARS")
        ])
    if params.get("RANEFF") is not None:
        cargs.extend([
            "-ranEff",
            params.get("RANEFF")
        ])
    if params.get("MASK") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("MASK"))
        ])
    if params.get("NUM_GLF") is not None:
        cargs.extend([
            "-num_glf",
            str(params.get("NUM_GLF"))
        ])
    if params.get("NUM_GLT") is not None:
        cargs.extend([
            "-num_glt",
            str(params.get("NUM_GLT"))
        ])
    if params.get("RESID") is not None:
        cargs.extend([
            "-resid",
            params.get("RESID")
        ])
    if params.get("RE") is not None:
        cargs.extend([
            "-RE",
            params.get("RE")
        ])
    if params.get("REPREFIX") is not None:
        cargs.extend([
            "-REprefix",
            params.get("REPREFIX")
        ])
    if params.get("RIO_FLAG"):
        cargs.append("-Rio")
    if params.get("SHOW_OPTIONS_FLAG"):
        cargs.append("-show_allowed_options")
    if params.get("SS_TYPE") is not None:
        cargs.extend([
            "-SS_type",
            str(params.get("SS_TYPE"))
        ])
    return cargs


def v_3d_lme_outputs(
    params: V3dLmeParameters,
    execution: Execution,
) -> V3dLmeOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dLmeOutputs(
        root=execution.output_file("."),
        output_nifti=execution.output_file(params.get("PREFIX") + ".nii"),
    )
    return ret


def v_3d_lme_execute(
    params: V3dLmeParameters,
    execution: Execution,
) -> V3dLmeOutputs:
    """
    AFNI Group Analysis Program with Linear Mixed-Effects Modeling Approach.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dLmeOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_lme_cargs(params, execution)
    ret = v_3d_lme_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_lme(
    prefix: str,
    model: str,
    data_table: str,
    bounds: list[float] | None = None,
    cio_flag: bool = False,
    cor_str: str | None = None,
    cutoff: float | None = None,
    dbg_args_flag: bool = False,
    jobs: float | None = None,
    glt_code: str | None = None,
    glt_label: str | None = None,
    glf_label: str | None = None,
    glf_code: str | None = None,
    icc_flag: bool = False,
    iccb_flag: bool = False,
    log_lik_flag: bool = False,
    logit_flag: bool = False,
    ml_flag: bool = False,
    qvars_centers: str | None = None,
    qvars: str | None = None,
    raneff: str | None = None,
    mask: InputPathType | None = None,
    num_glf: float | None = None,
    num_glt: float | None = None,
    resid: str | None = None,
    re_: str | None = None,
    reprefix: str | None = None,
    rio_flag: bool = False,
    show_options_flag: bool = False,
    ss_type: float | None = None,
    runner: Runner | None = None,
) -> V3dLmeOutputs:
    """
    AFNI Group Analysis Program with Linear Mixed-Effects Modeling Approach.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Prefix for output files.
        model: Model formula describing the fixed effects.
        data_table: Data table description.
        bounds: Lower and upper bounds for outlier removal.
        cio_flag: Use AFNI's C io functions (default) or R's io functions with\
            -Rio.
        cor_str: Specify the correlation structure of the residuals.
        cutoff: Specify the cutoff value for accuracy in logistic regression\
            analysis.
        dbg_args_flag: Enable saving parameters for debugging.
        jobs: Number of jobs for parallel computing.
        glt_code: General linear test coding.
        glt_label: Label for general linear test.
        glf_label: Label for general linear F-test.
        glf_code: General linear F-test coding.
        icc_flag: Compute voxel-wise intra-class correlation.
        iccb_flag: Compute voxel-wise intra-class correlation with Bayesian\
            approach.
        log_lik_flag: Include voxel-wise log likelihood in the output.
        logit_flag: Perform voxel-wise logistic modeling.
        ml_flag: Use Maximum Likelihood estimation instead of REML.
        qvars_centers: Centering values for quantitative variables.
        qvars: Identify quantitative variables (or covariates).
        raneff: Specify the random effects.
        mask: Mask file for voxel processing.
        num_glf: Number of general linear F-tests.
        num_glt: Number of general linear t-tests.
        resid: Prefix for residuals output file.
        re_: List of variables whose random effects are saved in the output.
        reprefix: Prefix for random effects output file.
        rio_flag: Use R's io functions instead of AFNI's C io functions.
        show_options_flag: List of allowed options.
        ss_type: Specify the type for sums of squares in the F-statistics.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dLmeOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_LME_METADATA)
    params = v_3d_lme_params(
        prefix=prefix,
        model=model,
        data_table=data_table,
        bounds=bounds,
        cio_flag=cio_flag,
        cor_str=cor_str,
        cutoff=cutoff,
        dbg_args_flag=dbg_args_flag,
        jobs=jobs,
        glt_code=glt_code,
        glt_label=glt_label,
        glf_label=glf_label,
        glf_code=glf_code,
        icc_flag=icc_flag,
        iccb_flag=iccb_flag,
        log_lik_flag=log_lik_flag,
        logit_flag=logit_flag,
        ml_flag=ml_flag,
        qvars_centers=qvars_centers,
        qvars=qvars,
        raneff=raneff,
        mask=mask,
        num_glf=num_glf,
        num_glt=num_glt,
        resid=resid,
        re_=re_,
        reprefix=reprefix,
        rio_flag=rio_flag,
        show_options_flag=show_options_flag,
        ss_type=ss_type,
    )
    return v_3d_lme_execute(params, execution)


__all__ = [
    "V3dLmeOutputs",
    "V3dLmeParameters",
    "V_3D_LME_METADATA",
    "v_3d_lme",
    "v_3d_lme_params",
]
