# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_MEMA_METADATA = Metadata(
    id="42d741bde9dc16f04484bfd186884378d78fc8f3.boutiques",
    name="3dMEMA",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dMemaParameters = typing.TypedDict('V3dMemaParameters', {
    "__STYXTYPE__": typing.Literal["3dMEMA"],
    "prefix": str,
    "jobs": typing.NotRequired[float | None],
    "set": list[str],
    "covariates": typing.NotRequired[InputPathType | None],
    "covariates_center": typing.NotRequired[str | None],
    "covariates_model": typing.NotRequired[str | None],
    "covariates_name": typing.NotRequired[list[str] | None],
    "groups": typing.NotRequired[list[str] | None],
    "cio": bool,
    "HKtest": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "max_zeros": typing.NotRequired[float | None],
    "missing_data": typing.NotRequired[list[str] | None],
    "model_outliers": bool,
    "n_nonzero": typing.NotRequired[float | None],
    "no_HKtest": bool,
    "no_model_outliers": bool,
    "no_residual_Z": bool,
    "residual_Z": bool,
    "Rio": bool,
    "equal_variance": bool,
    "unequal_variance": bool,
    "verb": typing.NotRequired[float | None],
    "dbgArgs": bool,
    "help": bool,
    "conditions": typing.NotRequired[list[str] | None],
    "no_tstat": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dMEMA": v_3d_mema_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dMEMA": v_3d_mema_outputs,
    }.get(t)


class V3dMemaOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_mema(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Output file from the analysis"""


def v_3d_mema_params(
    prefix: str,
    set_: list[str],
    jobs: float | None = None,
    covariates: InputPathType | None = None,
    covariates_center: str | None = None,
    covariates_model: str | None = None,
    covariates_name: list[str] | None = None,
    groups: list[str] | None = None,
    cio: bool = False,
    hktest: bool = False,
    mask: InputPathType | None = None,
    max_zeros: float | None = None,
    missing_data: list[str] | None = None,
    model_outliers: bool = False,
    n_nonzero: float | None = None,
    no_hktest: bool = False,
    no_model_outliers: bool = False,
    no_residual_z: bool = False,
    residual_z: bool = False,
    rio: bool = False,
    equal_variance: bool = False,
    unequal_variance: bool = False,
    verb: float | None = None,
    dbg_args: bool = False,
    help_: bool = False,
    conditions: list[str] | None = None,
    no_tstat: bool = False,
) -> V3dMemaParameters:
    """
    Build parameters.
    
    Args:
        prefix: Output prefix (just prefix, no view+suffix needed).
        set_: Set data for one of the test variables.
        jobs: Number of jobs for parallel computing.
        covariates: Specify the name of a text file containing a table for the\
            covariate(s).
        covariates_center: Specify the center values for covariates.
        covariates_model: Specify how covariates should be modeled.
        covariates_name: Specify the name of each covariate.
        groups: Label of groups, used for output naming.
        cio: Use AFNI's C io functions.
        hktest: Perform Hartung-Knapp adjustment for the output t-statistic.
        mask: Only process voxels inside the specified mask.
        max_zeros: Specify how many beta/t-statistics can be zero.
        missing_data: Specify missing data handling.
        model_outliers: Model outliers with a Laplace distribution.
        n_nonzero: Number of non-zero beta values required.
        no_hktest: Specify not to use Hartung-Knapp adjustment.
        no_model_outliers: Specify not to model outliers.
        no_residual_z: Do not output residuals and their Z values.
        residual_z: Output residuals and their Z values.
        rio: Use R's io functions.
        equal_variance: Assume same cross-subjects variability between groups.
        unequal_variance: Model cross-subject variability difference between\
            groups.
        verb: Specify verbosity level.
        dbg_args: Output missing data debug file.
        help_: Show help message.
        conditions: Name of 1 or 2 conditions, tasks, or GLTs.
        no_tstat: Do not compute t-statistics.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dMEMA",
        "prefix": prefix,
        "set": set_,
        "cio": cio,
        "HKtest": hktest,
        "model_outliers": model_outliers,
        "no_HKtest": no_hktest,
        "no_model_outliers": no_model_outliers,
        "no_residual_Z": no_residual_z,
        "residual_Z": residual_z,
        "Rio": rio,
        "equal_variance": equal_variance,
        "unequal_variance": unequal_variance,
        "dbgArgs": dbg_args,
        "help": help_,
        "no_tstat": no_tstat,
    }
    if jobs is not None:
        params["jobs"] = jobs
    if covariates is not None:
        params["covariates"] = covariates
    if covariates_center is not None:
        params["covariates_center"] = covariates_center
    if covariates_model is not None:
        params["covariates_model"] = covariates_model
    if covariates_name is not None:
        params["covariates_name"] = covariates_name
    if groups is not None:
        params["groups"] = groups
    if mask is not None:
        params["mask"] = mask
    if max_zeros is not None:
        params["max_zeros"] = max_zeros
    if missing_data is not None:
        params["missing_data"] = missing_data
    if n_nonzero is not None:
        params["n_nonzero"] = n_nonzero
    if verb is not None:
        params["verb"] = verb
    if conditions is not None:
        params["conditions"] = conditions
    return params


def v_3d_mema_cargs(
    params: V3dMemaParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dMEMA")
    cargs.extend([
        "-prefix",
        params.get("prefix")
    ])
    if params.get("jobs") is not None:
        cargs.extend([
            "-jobs",
            str(params.get("jobs"))
        ])
    cargs.extend([
        "-set",
        *params.get("set")
    ])
    if params.get("covariates") is not None:
        cargs.extend([
            "-covariates",
            execution.input_file(params.get("covariates"))
        ])
    if params.get("covariates_center") is not None:
        cargs.extend([
            "-covariates_center",
            params.get("covariates_center")
        ])
    if params.get("covariates_model") is not None:
        cargs.extend([
            "-covariates_model",
            params.get("covariates_model")
        ])
    if params.get("covariates_name") is not None:
        cargs.extend([
            "-covariates_name",
            *params.get("covariates_name")
        ])
    if params.get("groups") is not None:
        cargs.extend([
            "-groups",
            *params.get("groups")
        ])
    if params.get("cio"):
        cargs.append("-cio")
    if params.get("HKtest"):
        cargs.append("-HKtest")
    if params.get("mask") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask"))
        ])
    if params.get("max_zeros") is not None:
        cargs.extend([
            "-max_zeros",
            str(params.get("max_zeros"))
        ])
    if params.get("missing_data") is not None:
        cargs.extend([
            "-missing_data",
            *params.get("missing_data")
        ])
    if params.get("model_outliers"):
        cargs.append("-model_outliers")
    if params.get("n_nonzero") is not None:
        cargs.extend([
            "-n_nonzero",
            str(params.get("n_nonzero"))
        ])
    if params.get("no_HKtest"):
        cargs.append("-no_HKtest")
    if params.get("no_model_outliers"):
        cargs.append("-no_model_outliers")
    if params.get("no_residual_Z"):
        cargs.append("-no_residual_Z")
    if params.get("residual_Z"):
        cargs.append("-residual_Z")
    if params.get("Rio"):
        cargs.append("-Rio")
    if params.get("equal_variance"):
        cargs.append("-equal_variance")
    if params.get("unequal_variance"):
        cargs.append("-unequal_variance")
    if params.get("verb") is not None:
        cargs.extend([
            "-verb",
            str(params.get("verb"))
        ])
    if params.get("dbgArgs"):
        cargs.append("-dbgArgs")
    if params.get("help"):
        cargs.append("-help")
    if params.get("conditions") is not None:
        cargs.extend([
            "-conditions",
            *params.get("conditions")
        ])
    if params.get("no_tstat"):
        cargs.append("-no_tstat")
    return cargs


def v_3d_mema_outputs(
    params: V3dMemaParameters,
    execution: Execution,
) -> V3dMemaOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dMemaOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix") + ".nii.gz"),
    )
    return ret


def v_3d_mema_execute(
    params: V3dMemaParameters,
    execution: Execution,
) -> V3dMemaOutputs:
    """
    3dMEMA is a program for performing Mixed Effects Meta Analysis at group level
    that models both within- and across-subjects variability.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dMemaOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_mema_cargs(params, execution)
    ret = v_3d_mema_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_mema(
    prefix: str,
    set_: list[str],
    jobs: float | None = None,
    covariates: InputPathType | None = None,
    covariates_center: str | None = None,
    covariates_model: str | None = None,
    covariates_name: list[str] | None = None,
    groups: list[str] | None = None,
    cio: bool = False,
    hktest: bool = False,
    mask: InputPathType | None = None,
    max_zeros: float | None = None,
    missing_data: list[str] | None = None,
    model_outliers: bool = False,
    n_nonzero: float | None = None,
    no_hktest: bool = False,
    no_model_outliers: bool = False,
    no_residual_z: bool = False,
    residual_z: bool = False,
    rio: bool = False,
    equal_variance: bool = False,
    unequal_variance: bool = False,
    verb: float | None = None,
    dbg_args: bool = False,
    help_: bool = False,
    conditions: list[str] | None = None,
    no_tstat: bool = False,
    runner: Runner | None = None,
) -> V3dMemaOutputs:
    """
    3dMEMA is a program for performing Mixed Effects Meta Analysis at group level
    that models both within- and across-subjects variability.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Output prefix (just prefix, no view+suffix needed).
        set_: Set data for one of the test variables.
        jobs: Number of jobs for parallel computing.
        covariates: Specify the name of a text file containing a table for the\
            covariate(s).
        covariates_center: Specify the center values for covariates.
        covariates_model: Specify how covariates should be modeled.
        covariates_name: Specify the name of each covariate.
        groups: Label of groups, used for output naming.
        cio: Use AFNI's C io functions.
        hktest: Perform Hartung-Knapp adjustment for the output t-statistic.
        mask: Only process voxels inside the specified mask.
        max_zeros: Specify how many beta/t-statistics can be zero.
        missing_data: Specify missing data handling.
        model_outliers: Model outliers with a Laplace distribution.
        n_nonzero: Number of non-zero beta values required.
        no_hktest: Specify not to use Hartung-Knapp adjustment.
        no_model_outliers: Specify not to model outliers.
        no_residual_z: Do not output residuals and their Z values.
        residual_z: Output residuals and their Z values.
        rio: Use R's io functions.
        equal_variance: Assume same cross-subjects variability between groups.
        unequal_variance: Model cross-subject variability difference between\
            groups.
        verb: Specify verbosity level.
        dbg_args: Output missing data debug file.
        help_: Show help message.
        conditions: Name of 1 or 2 conditions, tasks, or GLTs.
        no_tstat: Do not compute t-statistics.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dMemaOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_MEMA_METADATA)
    params = v_3d_mema_params(
        prefix=prefix,
        jobs=jobs,
        set_=set_,
        covariates=covariates,
        covariates_center=covariates_center,
        covariates_model=covariates_model,
        covariates_name=covariates_name,
        groups=groups,
        cio=cio,
        hktest=hktest,
        mask=mask,
        max_zeros=max_zeros,
        missing_data=missing_data,
        model_outliers=model_outliers,
        n_nonzero=n_nonzero,
        no_hktest=no_hktest,
        no_model_outliers=no_model_outliers,
        no_residual_z=no_residual_z,
        residual_z=residual_z,
        rio=rio,
        equal_variance=equal_variance,
        unequal_variance=unequal_variance,
        verb=verb,
        dbg_args=dbg_args,
        help_=help_,
        conditions=conditions,
        no_tstat=no_tstat,
    )
    return v_3d_mema_execute(params, execution)


__all__ = [
    "V3dMemaOutputs",
    "V3dMemaParameters",
    "V_3D_MEMA_METADATA",
    "v_3d_mema",
    "v_3d_mema_params",
]
