# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_PVAL_METADATA = Metadata(
    id="724a7212deebf60511bbed100d1d685ab6d47da3.boutiques",
    name="3dPval",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dPvalParameters = typing.TypedDict('V3dPvalParameters', {
    "__STYXTYPE__": typing.Literal["3dPval"],
    "input_dataset": InputPathType,
    "zscore": bool,
    "log2": bool,
    "log10": bool,
    "qval": bool,
    "prefix": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dPval": v_3d_pval_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dPval": v_3d_pval_outputs,
    }.get(t)


class V3dPvalOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_pval(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType | None
    """Output dataset with converted statistical values. Default output filename
    is 'Pval.nii.gz'."""


def v_3d_pval_params(
    input_dataset: InputPathType,
    zscore: bool = False,
    log2: bool = False,
    log10: bool = False,
    qval: bool = False,
    prefix: str | None = None,
) -> V3dPvalParameters:
    """
    Build parameters.
    
    Args:
        input_dataset: Input dataset (e.g., InputDataset.nii).
        zscore: Convert statistic to a z-score instead, an N(0,1) deviate that\
            represents the same p-value.
        log2: Convert statistic to -log2(p).
        log10: Convert statistic to -log10(p).
        qval: Convert statistic to a q-value (FDR) instead. This option only\
            works with datasets that have FDR curves inserted in their headers.
        prefix: Prefix name for output file (default name is 'Pval').
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dPval",
        "input_dataset": input_dataset,
        "zscore": zscore,
        "log2": log2,
        "log10": log10,
        "qval": qval,
    }
    if prefix is not None:
        params["prefix"] = prefix
    return params


def v_3d_pval_cargs(
    params: V3dPvalParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dPval")
    cargs.append(execution.input_file(params.get("input_dataset")))
    if params.get("zscore"):
        cargs.append("-zscore")
    if params.get("log2"):
        cargs.append("-log2")
    if params.get("log10"):
        cargs.append("-log10")
    if params.get("qval"):
        cargs.append("-qval")
    if params.get("prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix")
        ])
    return cargs


def v_3d_pval_outputs(
    params: V3dPvalParameters,
    execution: Execution,
) -> V3dPvalOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dPvalOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix") + ".nii.gz") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_pval_execute(
    params: V3dPvalParameters,
    execution: Execution,
) -> V3dPvalOutputs:
    """
    Convert a dataset's statistical sub-bricks to p-values or other statistical
    representations.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dPvalOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_pval_cargs(params, execution)
    ret = v_3d_pval_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_pval(
    input_dataset: InputPathType,
    zscore: bool = False,
    log2: bool = False,
    log10: bool = False,
    qval: bool = False,
    prefix: str | None = None,
    runner: Runner | None = None,
) -> V3dPvalOutputs:
    """
    Convert a dataset's statistical sub-bricks to p-values or other statistical
    representations.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_dataset: Input dataset (e.g., InputDataset.nii).
        zscore: Convert statistic to a z-score instead, an N(0,1) deviate that\
            represents the same p-value.
        log2: Convert statistic to -log2(p).
        log10: Convert statistic to -log10(p).
        qval: Convert statistic to a q-value (FDR) instead. This option only\
            works with datasets that have FDR curves inserted in their headers.
        prefix: Prefix name for output file (default name is 'Pval').
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dPvalOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_PVAL_METADATA)
    params = v_3d_pval_params(
        input_dataset=input_dataset,
        zscore=zscore,
        log2=log2,
        log10=log10,
        qval=qval,
        prefix=prefix,
    )
    return v_3d_pval_execute(params, execution)


__all__ = [
    "V3dPvalOutputs",
    "V3dPvalParameters",
    "V_3D_PVAL_METADATA",
    "v_3d_pval",
    "v_3d_pval_params",
]
