# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_RETINO_PHASE_METADATA = Metadata(
    id="2d3b9af035089d0168b16f53cd54b736189187db.boutiques",
    name="3dRetinoPhase",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dRetinoPhaseParameters = typing.TypedDict('V3dRetinoPhaseParameters', {
    "__STYXTYPE__": typing.Literal["3dRetinoPhase"],
    "prefix": str,
    "dataset": InputPathType,
    "exp": typing.NotRequired[str | None],
    "con": typing.NotRequired[str | None],
    "clw": typing.NotRequired[str | None],
    "ccw": typing.NotRequired[str | None],
    "spectra": bool,
    "tstim": typing.NotRequired[float | None],
    "nrings": typing.NotRequired[float | None],
    "nwedges": typing.NotRequired[float | None],
    "ort_adjust": typing.NotRequired[float | None],
    "pre_stim": typing.NotRequired[float | None],
    "sum_adjust": typing.NotRequired[str | None],
    "phase_estimate": typing.NotRequired[str | None],
    "ref_ts": typing.NotRequired[InputPathType | None],
    "multi_ref_ts": typing.NotRequired[InputPathType | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dRetinoPhase": v_3d_retino_phase_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dRetinoPhase": v_3d_retino_phase_outputs,
    }.get(t)


class V3dRetinoPhaseOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_retino_phase(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    ecc_plus: OutputPathType
    """Output file for positive (expanding) eccentricity"""
    ecc_minus: OutputPathType
    """Output file for negative (contracting) eccentricity"""
    pol_plus: OutputPathType
    """Output file for clockwise polar angle mapping"""
    pol_minus: OutputPathType
    """Output file for counterclockwise polar angle mapping"""


def v_3d_retino_phase_params(
    prefix: str,
    dataset: InputPathType,
    exp: str | None = None,
    con: str | None = None,
    clw: str | None = None,
    ccw: str | None = None,
    spectra: bool = False,
    tstim: float | None = None,
    nrings: float | None = None,
    nwedges: float | None = None,
    ort_adjust: float | None = None,
    pre_stim: float | None = None,
    sum_adjust: str | None = None,
    phase_estimate: str | None = None,
    ref_ts: InputPathType | None = None,
    multi_ref_ts: InputPathType | None = None,
) -> V3dRetinoPhaseParameters:
    """
    Build parameters.
    
    Args:
        prefix: Prefix of output datasets.
        dataset: Time series from a retinotopy stimulus.
        exp: Expanding rings stimulus.
        con: Contracting rings stimulus.
        clw: Clockwise moving polar angle mapping stimulus.
        ccw: Counterclockwise moving polar angle mapping stimulus.
        spectra: Output amplitude and phase spectra datasets.
        tstim: Period of stimulus in seconds.
        nrings: Number of rings in the stimulus. Default is 1.
        nwedges: Number of wedges in the stimulus. Default is 1.
        ort_adjust: Number of DOF lost in detrending outside of this program.
        pre_stim: Blank period, in seconds, before stimulus began.
        sum_adjust: Adjust sum of angles for wrapping based on the angle\
            difference. Default is 'y'.
        phase_estimate: Method of phase estimation.
        ref_ts: 0 lag reference time series of response for DELAY phase\
            estimation method.
        multi_ref_ts: Multiple 0 lag reference time series. This allows you to\
            test multiple regressors.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dRetinoPhase",
        "prefix": prefix,
        "dataset": dataset,
        "spectra": spectra,
    }
    if exp is not None:
        params["exp"] = exp
    if con is not None:
        params["con"] = con
    if clw is not None:
        params["clw"] = clw
    if ccw is not None:
        params["ccw"] = ccw
    if tstim is not None:
        params["tstim"] = tstim
    if nrings is not None:
        params["nrings"] = nrings
    if nwedges is not None:
        params["nwedges"] = nwedges
    if ort_adjust is not None:
        params["ort_adjust"] = ort_adjust
    if pre_stim is not None:
        params["pre_stim"] = pre_stim
    if sum_adjust is not None:
        params["sum_adjust"] = sum_adjust
    if phase_estimate is not None:
        params["phase_estimate"] = phase_estimate
    if ref_ts is not None:
        params["ref_ts"] = ref_ts
    if multi_ref_ts is not None:
        params["multi_ref_ts"] = multi_ref_ts
    return params


def v_3d_retino_phase_cargs(
    params: V3dRetinoPhaseParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dRetinoPhase")
    cargs.append(params.get("prefix"))
    cargs.append(execution.input_file(params.get("dataset")))
    if params.get("exp") is not None:
        cargs.extend([
            "-exp",
            params.get("exp")
        ])
    if params.get("con") is not None:
        cargs.extend([
            "-con",
            params.get("con")
        ])
    if params.get("clw") is not None:
        cargs.extend([
            "-clw",
            params.get("clw")
        ])
    if params.get("ccw") is not None:
        cargs.extend([
            "-ccw",
            params.get("ccw")
        ])
    if params.get("spectra"):
        cargs.append("-spectra")
    if params.get("tstim") is not None:
        cargs.extend([
            "-Tstim",
            str(params.get("tstim"))
        ])
    if params.get("nrings") is not None:
        cargs.extend([
            "-nrings",
            str(params.get("nrings"))
        ])
    if params.get("nwedges") is not None:
        cargs.extend([
            "-nwedges",
            str(params.get("nwedges"))
        ])
    if params.get("ort_adjust") is not None:
        cargs.extend([
            "-ort_adjust",
            str(params.get("ort_adjust"))
        ])
    if params.get("pre_stim") is not None:
        cargs.extend([
            "-pre_stim",
            str(params.get("pre_stim"))
        ])
    if params.get("sum_adjust") is not None:
        cargs.extend([
            "-sum_adjust",
            params.get("sum_adjust")
        ])
    if params.get("phase_estimate") is not None:
        cargs.extend([
            "-phase_estimate",
            params.get("phase_estimate")
        ])
    if params.get("ref_ts") is not None:
        cargs.extend([
            "-ref_ts",
            execution.input_file(params.get("ref_ts"))
        ])
    if params.get("multi_ref_ts") is not None:
        cargs.extend([
            "-multi_ref_ts",
            execution.input_file(params.get("multi_ref_ts"))
        ])
    return cargs


def v_3d_retino_phase_outputs(
    params: V3dRetinoPhaseParameters,
    execution: Execution,
) -> V3dRetinoPhaseOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dRetinoPhaseOutputs(
        root=execution.output_file("."),
        ecc_plus=execution.output_file(params.get("prefix") + ".ecc+"),
        ecc_minus=execution.output_file(params.get("prefix") + ".ecc-"),
        pol_plus=execution.output_file(params.get("prefix") + ".pol+"),
        pol_minus=execution.output_file(params.get("prefix") + ".pol-"),
    )
    return ret


def v_3d_retino_phase_execute(
    params: V3dRetinoPhaseParameters,
    execution: Execution,
) -> V3dRetinoPhaseOutputs:
    """
    Process time series from retinotopy stimuli to create phase datasets and visual
    field angle datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dRetinoPhaseOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_retino_phase_cargs(params, execution)
    ret = v_3d_retino_phase_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_retino_phase(
    prefix: str,
    dataset: InputPathType,
    exp: str | None = None,
    con: str | None = None,
    clw: str | None = None,
    ccw: str | None = None,
    spectra: bool = False,
    tstim: float | None = None,
    nrings: float | None = None,
    nwedges: float | None = None,
    ort_adjust: float | None = None,
    pre_stim: float | None = None,
    sum_adjust: str | None = None,
    phase_estimate: str | None = None,
    ref_ts: InputPathType | None = None,
    multi_ref_ts: InputPathType | None = None,
    runner: Runner | None = None,
) -> V3dRetinoPhaseOutputs:
    """
    Process time series from retinotopy stimuli to create phase datasets and visual
    field angle datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Prefix of output datasets.
        dataset: Time series from a retinotopy stimulus.
        exp: Expanding rings stimulus.
        con: Contracting rings stimulus.
        clw: Clockwise moving polar angle mapping stimulus.
        ccw: Counterclockwise moving polar angle mapping stimulus.
        spectra: Output amplitude and phase spectra datasets.
        tstim: Period of stimulus in seconds.
        nrings: Number of rings in the stimulus. Default is 1.
        nwedges: Number of wedges in the stimulus. Default is 1.
        ort_adjust: Number of DOF lost in detrending outside of this program.
        pre_stim: Blank period, in seconds, before stimulus began.
        sum_adjust: Adjust sum of angles for wrapping based on the angle\
            difference. Default is 'y'.
        phase_estimate: Method of phase estimation.
        ref_ts: 0 lag reference time series of response for DELAY phase\
            estimation method.
        multi_ref_ts: Multiple 0 lag reference time series. This allows you to\
            test multiple regressors.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dRetinoPhaseOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_RETINO_PHASE_METADATA)
    params = v_3d_retino_phase_params(
        prefix=prefix,
        dataset=dataset,
        exp=exp,
        con=con,
        clw=clw,
        ccw=ccw,
        spectra=spectra,
        tstim=tstim,
        nrings=nrings,
        nwedges=nwedges,
        ort_adjust=ort_adjust,
        pre_stim=pre_stim,
        sum_adjust=sum_adjust,
        phase_estimate=phase_estimate,
        ref_ts=ref_ts,
        multi_ref_ts=multi_ref_ts,
    )
    return v_3d_retino_phase_execute(params, execution)


__all__ = [
    "V3dRetinoPhaseOutputs",
    "V3dRetinoPhaseParameters",
    "V_3D_RETINO_PHASE_METADATA",
    "v_3d_retino_phase",
    "v_3d_retino_phase_params",
]
