# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_SURF_MASK_METADATA = Metadata(
    id="8c0ff8c2071e2a01164c6a3e3d4790c519002089.boutiques",
    name="3dSurfMask",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dSurfMaskParameters = typing.TypedDict('V3dSurfMaskParameters', {
    "__STYXTYPE__": typing.Literal["3dSurfMask"],
    "surface_type": str,
    "surface_file": InputPathType,
    "prefix": str,
    "grid_parent": InputPathType,
    "fill_method": typing.NotRequired[str | None],
    "surface_volume": typing.NotRequired[InputPathType | None],
    "mask_only": bool,
    "flip_orientation": bool,
    "no_distance": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dSurfMask": v_3d_surf_mask_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dSurfMask": v_3d_surf_mask_outputs,
    }.get(t)


class V3dSurfMaskOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_surf_mask(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_mask: OutputPathType
    """Main output mask dataset."""
    distance_dataset: OutputPathType
    """Dataset reflecting voxel shortest distances to the surface."""


def v_3d_surf_mask_params(
    surface_type: str,
    surface_file: InputPathType,
    prefix: str,
    grid_parent: InputPathType,
    fill_method: str | None = None,
    surface_volume: InputPathType | None = None,
    mask_only: bool = False,
    flip_orientation: bool = False,
    no_distance: bool = False,
) -> V3dSurfMaskParameters:
    """
    Build parameters.
    
    Args:
        surface_type: Specify input surface.
        surface_file: Specify input surface filename.
        prefix: Prefix of output dataset.
        grid_parent: Specifies the grid for the output volume.
        fill_method: Fill method: SLOW or FAST (default: FAST).
        surface_volume: Specify the surface volume.
        mask_only: Produce an output dataset where voxels are 1 inside the\
            surface and 0 outside.
        flip_orientation: Flip triangle winding of surface mesh.
        no_distance: Do not compute the distances, just the mask from the first\
            step.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dSurfMask",
        "surface_type": surface_type,
        "surface_file": surface_file,
        "prefix": prefix,
        "grid_parent": grid_parent,
        "mask_only": mask_only,
        "flip_orientation": flip_orientation,
        "no_distance": no_distance,
    }
    if fill_method is not None:
        params["fill_method"] = fill_method
    if surface_volume is not None:
        params["surface_volume"] = surface_volume
    return params


def v_3d_surf_mask_cargs(
    params: V3dSurfMaskParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dSurfMask")
    cargs.append(params.get("surface_type"))
    cargs.append(execution.input_file(params.get("surface_file")))
    cargs.append(params.get("prefix"))
    cargs.append(execution.input_file(params.get("grid_parent")))
    if params.get("fill_method") is not None:
        cargs.extend([
            "-fill_method",
            params.get("fill_method")
        ])
    if params.get("surface_volume") is not None:
        cargs.extend([
            "-sv",
            execution.input_file(params.get("surface_volume"))
        ])
    if params.get("mask_only"):
        cargs.append("-mask_only")
    if params.get("flip_orientation"):
        cargs.append("-flip_orientation")
    if params.get("no_distance"):
        cargs.append("-no_dist")
    return cargs


def v_3d_surf_mask_outputs(
    params: V3dSurfMaskParameters,
    execution: Execution,
) -> V3dSurfMaskOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dSurfMaskOutputs(
        root=execution.output_file("."),
        output_mask=execution.output_file(params.get("prefix") + ".m+orig.BRIK"),
        distance_dataset=execution.output_file(params.get("prefix") + ".d+orig.BRIK"),
    )
    return ret


def v_3d_surf_mask_execute(
    params: V3dSurfMaskParameters,
    execution: Execution,
) -> V3dSurfMaskOutputs:
    """
    Creates volumetric datasets marking voxels based on their location relative to a
    surface.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dSurfMaskOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_surf_mask_cargs(params, execution)
    ret = v_3d_surf_mask_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_surf_mask(
    surface_type: str,
    surface_file: InputPathType,
    prefix: str,
    grid_parent: InputPathType,
    fill_method: str | None = None,
    surface_volume: InputPathType | None = None,
    mask_only: bool = False,
    flip_orientation: bool = False,
    no_distance: bool = False,
    runner: Runner | None = None,
) -> V3dSurfMaskOutputs:
    """
    Creates volumetric datasets marking voxels based on their location relative to a
    surface.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        surface_type: Specify input surface.
        surface_file: Specify input surface filename.
        prefix: Prefix of output dataset.
        grid_parent: Specifies the grid for the output volume.
        fill_method: Fill method: SLOW or FAST (default: FAST).
        surface_volume: Specify the surface volume.
        mask_only: Produce an output dataset where voxels are 1 inside the\
            surface and 0 outside.
        flip_orientation: Flip triangle winding of surface mesh.
        no_distance: Do not compute the distances, just the mask from the first\
            step.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dSurfMaskOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_SURF_MASK_METADATA)
    params = v_3d_surf_mask_params(
        surface_type=surface_type,
        surface_file=surface_file,
        prefix=prefix,
        grid_parent=grid_parent,
        fill_method=fill_method,
        surface_volume=surface_volume,
        mask_only=mask_only,
        flip_orientation=flip_orientation,
        no_distance=no_distance,
    )
    return v_3d_surf_mask_execute(params, execution)


__all__ = [
    "V3dSurfMaskOutputs",
    "V3dSurfMaskParameters",
    "V_3D_SURF_MASK_METADATA",
    "v_3d_surf_mask",
    "v_3d_surf_mask_params",
]
