# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_TCORRELATE_METADATA = Metadata(
    id="ecc97c11254ea3d0a351c5592302c585980958d1.boutiques",
    name="3dTcorrelate",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dTcorrelateParameters = typing.TypedDict('V3dTcorrelateParameters', {
    "__STYXTYPE__": typing.Literal["3dTcorrelate"],
    "xset": InputPathType,
    "yset": InputPathType,
    "pearson": bool,
    "spearman": bool,
    "quadrant": bool,
    "ktaub": bool,
    "covariance": bool,
    "partial": typing.NotRequired[InputPathType | None],
    "ycoef": bool,
    "fisher": bool,
    "polort": typing.NotRequired[int | None],
    "ort": typing.NotRequired[InputPathType | None],
    "autoclip": bool,
    "automask": bool,
    "zcensor": bool,
    "prefix": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dTcorrelate": v_3d_tcorrelate_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dTcorrelate": v_3d_tcorrelate_outputs,
    }.get(t)


class V3dTcorrelateOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_tcorrelate(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_file: OutputPathType | None
    """Output image file name."""


def v_3d_tcorrelate_params(
    xset: InputPathType,
    yset: InputPathType,
    pearson: bool = False,
    spearman: bool = False,
    quadrant: bool = False,
    ktaub: bool = False,
    covariance: bool = False,
    partial: InputPathType | None = None,
    ycoef: bool = False,
    fisher: bool = False,
    polort: int | None = None,
    ort: InputPathType | None = None,
    autoclip: bool = False,
    automask: bool = False,
    zcensor: bool = False,
    prefix: str | None = None,
) -> V3dTcorrelateParameters:
    """
    Build parameters.
    
    Args:
        xset: Input xset.
        yset: Input yset.
        pearson: Correlation is the normal pearson correlation coefficient.
        spearman: Correlation is the Spearman (rank) correlation coefficient.
        quadrant: Correlation is the quadrant coefficient.
        ktaub: Correlation is Kendall's tau_b coefficient. For continuous or\
            finely discretized data, tau_b and rank correlation are nearly\
            equivalent.
        covariance: Covariance instead of correlation. That would be Pearson\
            correlation without scaling by the product of the standard deviations.
        partial: Partial Pearson's correlation of X & Y, adjusting for Z (the\
            dataset provided here).
        ycoef: Least squares coefficient that best fits y(t) to x(t), after\
            detrending. That is, if yd(t) is the detrended y(t) and xd(t) is the\
            detrended x(t), then the ycoef value is from the OLSQ fit to xd(t) =\
            ycoef & y(t) + error.
        fisher: Apply the Fisher (inverse hyperbolic tangent) transformation to\
            correlation results. Does not make sense with ktaub, covariance, or\
            ycoef.
        polort: Remove polynomial trend of order m. Using m=-1 mean no\
            detrending; this is only useful fro data that has been preprocessed.
        ort: A 1D file. Also detrend using the columbs of the 1D file provided\
            here. Only one -ort option can be given, so if you would like to use\
            more than one, create a temporary file using 1dcat.
        autoclip: Clip off low-intensity regions in the two datasets, so that\
            the correlation is only computed between high-intensity (presumably\
            brain) voxels. The intensity level is determined the same way that\
            3dClipLevel works.
        automask: Clip off low-intensity regions in the two datasets, so that\
            the correlation is only computed between high-intensity (presumably\
            brain) voxels. The intensity level is determined the same way that\
            3dClipLevel works.
        zcensor: Omit (censor out) any time points where the xset volume is all\
            zero OR where the yset volume is all zero (in mask). Please note that\
            using -zcensor with any detrending is unlikely to be useful.
        prefix: Save output into a dataset with this prefix.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dTcorrelate",
        "xset": xset,
        "yset": yset,
        "pearson": pearson,
        "spearman": spearman,
        "quadrant": quadrant,
        "ktaub": ktaub,
        "covariance": covariance,
        "ycoef": ycoef,
        "fisher": fisher,
        "autoclip": autoclip,
        "automask": automask,
        "zcensor": zcensor,
    }
    if partial is not None:
        params["partial"] = partial
    if polort is not None:
        params["polort"] = polort
    if ort is not None:
        params["ort"] = ort
    if prefix is not None:
        params["prefix"] = prefix
    return params


def v_3d_tcorrelate_cargs(
    params: V3dTcorrelateParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dTcorrelate")
    cargs.append(execution.input_file(params.get("xset")))
    cargs.append(execution.input_file(params.get("yset")))
    if params.get("pearson"):
        cargs.append("-pearson")
    if params.get("spearman"):
        cargs.append("-spearman")
    if params.get("quadrant"):
        cargs.append("-quadrant")
    if params.get("ktaub"):
        cargs.append("-ktaub")
    if params.get("covariance"):
        cargs.append("-covariance")
    if params.get("partial") is not None:
        cargs.extend([
            "-partial",
            execution.input_file(params.get("partial"))
        ])
    if params.get("ycoef"):
        cargs.append("-ycoef")
    if params.get("fisher"):
        cargs.append("-Fisher")
    if params.get("polort") is not None:
        cargs.extend([
            "-polort",
            str(params.get("polort"))
        ])
    if params.get("ort") is not None:
        cargs.extend([
            "-ort",
            execution.input_file(params.get("ort"))
        ])
    if params.get("autoclip"):
        cargs.append("-autoclip")
    if params.get("automask"):
        cargs.append("-automask")
    if params.get("zcensor"):
        cargs.append("-zcensor")
    if params.get("prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix")
        ])
    return cargs


def v_3d_tcorrelate_outputs(
    params: V3dTcorrelateParameters,
    execution: Execution,
) -> V3dTcorrelateOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dTcorrelateOutputs(
        root=execution.output_file("."),
        out_file=execution.output_file(params.get("prefix")) if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_tcorrelate_execute(
    params: V3dTcorrelateParameters,
    execution: Execution,
) -> V3dTcorrelateOutputs:
    """
    3dTcorrelate. Computes the correlation coefficient between corresponding voxel
    time series in two input 3D+time datasets 'xset' and 'yset'.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dTcorrelateOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_tcorrelate_cargs(params, execution)
    ret = v_3d_tcorrelate_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_tcorrelate(
    xset: InputPathType,
    yset: InputPathType,
    pearson: bool = False,
    spearman: bool = False,
    quadrant: bool = False,
    ktaub: bool = False,
    covariance: bool = False,
    partial: InputPathType | None = None,
    ycoef: bool = False,
    fisher: bool = False,
    polort: int | None = None,
    ort: InputPathType | None = None,
    autoclip: bool = False,
    automask: bool = False,
    zcensor: bool = False,
    prefix: str | None = None,
    runner: Runner | None = None,
) -> V3dTcorrelateOutputs:
    """
    3dTcorrelate. Computes the correlation coefficient between corresponding voxel
    time series in two input 3D+time datasets 'xset' and 'yset'.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        xset: Input xset.
        yset: Input yset.
        pearson: Correlation is the normal pearson correlation coefficient.
        spearman: Correlation is the Spearman (rank) correlation coefficient.
        quadrant: Correlation is the quadrant coefficient.
        ktaub: Correlation is Kendall's tau_b coefficient. For continuous or\
            finely discretized data, tau_b and rank correlation are nearly\
            equivalent.
        covariance: Covariance instead of correlation. That would be Pearson\
            correlation without scaling by the product of the standard deviations.
        partial: Partial Pearson's correlation of X & Y, adjusting for Z (the\
            dataset provided here).
        ycoef: Least squares coefficient that best fits y(t) to x(t), after\
            detrending. That is, if yd(t) is the detrended y(t) and xd(t) is the\
            detrended x(t), then the ycoef value is from the OLSQ fit to xd(t) =\
            ycoef & y(t) + error.
        fisher: Apply the Fisher (inverse hyperbolic tangent) transformation to\
            correlation results. Does not make sense with ktaub, covariance, or\
            ycoef.
        polort: Remove polynomial trend of order m. Using m=-1 mean no\
            detrending; this is only useful fro data that has been preprocessed.
        ort: A 1D file. Also detrend using the columbs of the 1D file provided\
            here. Only one -ort option can be given, so if you would like to use\
            more than one, create a temporary file using 1dcat.
        autoclip: Clip off low-intensity regions in the two datasets, so that\
            the correlation is only computed between high-intensity (presumably\
            brain) voxels. The intensity level is determined the same way that\
            3dClipLevel works.
        automask: Clip off low-intensity regions in the two datasets, so that\
            the correlation is only computed between high-intensity (presumably\
            brain) voxels. The intensity level is determined the same way that\
            3dClipLevel works.
        zcensor: Omit (censor out) any time points where the xset volume is all\
            zero OR where the yset volume is all zero (in mask). Please note that\
            using -zcensor with any detrending is unlikely to be useful.
        prefix: Save output into a dataset with this prefix.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dTcorrelateOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_TCORRELATE_METADATA)
    params = v_3d_tcorrelate_params(
        xset=xset,
        yset=yset,
        pearson=pearson,
        spearman=spearman,
        quadrant=quadrant,
        ktaub=ktaub,
        covariance=covariance,
        partial=partial,
        ycoef=ycoef,
        fisher=fisher,
        polort=polort,
        ort=ort,
        autoclip=autoclip,
        automask=automask,
        zcensor=zcensor,
        prefix=prefix,
    )
    return v_3d_tcorrelate_execute(params, execution)


__all__ = [
    "V3dTcorrelateOutputs",
    "V3dTcorrelateParameters",
    "V_3D_TCORRELATE_METADATA",
    "v_3d_tcorrelate",
    "v_3d_tcorrelate_params",
]
