# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_TOY_PROG_METADATA = Metadata(
    id="5b79d4ff9e6891e041e9a3b68d176f2055097819.boutiques",
    name="3dToyProg",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dToyProgParameters = typing.TypedDict('V3dToyProgParameters', {
    "__STYXTYPE__": typing.Literal["3dToyProg"],
    "input_dataset": InputPathType,
    "output_prefix": typing.NotRequired[str | None],
    "mask_dataset": typing.NotRequired[InputPathType | None],
    "output_datum": typing.NotRequired[typing.Literal["float", "short"] | None],
    "mini_help": bool,
    "help": bool,
    "extreme_help": bool,
    "help_view": bool,
    "help_web": bool,
    "help_find": typing.NotRequired[str | None],
    "help_raw": bool,
    "help_spx": bool,
    "help_aspx": bool,
    "help_all_opts": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dToyProg": v_3d_toy_prog_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class V3dToyProgOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_toy_prog(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3d_toy_prog_params(
    input_dataset: InputPathType,
    output_prefix: str | None = None,
    mask_dataset: InputPathType | None = None,
    output_datum: typing.Literal["float", "short"] | None = None,
    mini_help: bool = False,
    help_: bool = False,
    extreme_help: bool = False,
    help_view: bool = False,
    help_web: bool = False,
    help_find: str | None = None,
    help_raw: bool = False,
    help_spx: bool = False,
    help_aspx: bool = False,
    help_all_opts: bool = False,
) -> V3dToyProgParameters:
    """
    Build parameters.
    
    Args:
        input_dataset: Reference dataset.
        output_prefix: Prefix of the output datasets.
        mask_dataset: Restrict analysis to non-zero voxels in the mask dataset.
        output_datum: Output datum type for one of the datasets. Choose from\
            'float' or 'short'. Default is 'float'.
        mini_help: Mini help, at time, same as -help in many cases.
        help_: The entire help output.
        extreme_help: Extreme help, same as -help in majority of cases.
        help_view: Open help in text editor. AFNI will try to find a GUI editor\
            on your machine. You can control which it should use by setting\
            environment variable AFNI_GUI_EDITOR.
        help_web: Open help in web browser. AFNI will try to find a browser on\
            your machine. You can control which it should use by setting\
            environment variable AFNI_GUI_EDITOR.
        help_find: Look for lines in this program's -help output that match\
            (approximately) WORD.
        help_raw: Help string unedited.
        help_spx: Help string in sphinx loveliness, but do not try to\
            autoformat.
        help_aspx: Help string in sphinx with autoformatting of options, etc.
        help_all_opts: Try to identify all options for the program from the\
            output of its -help option. Some options might be missed and others\
            misidentified. Use this output for hints only.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dToyProg",
        "input_dataset": input_dataset,
        "mini_help": mini_help,
        "help": help_,
        "extreme_help": extreme_help,
        "help_view": help_view,
        "help_web": help_web,
        "help_raw": help_raw,
        "help_spx": help_spx,
        "help_aspx": help_aspx,
        "help_all_opts": help_all_opts,
    }
    if output_prefix is not None:
        params["output_prefix"] = output_prefix
    if mask_dataset is not None:
        params["mask_dataset"] = mask_dataset
    if output_datum is not None:
        params["output_datum"] = output_datum
    if help_find is not None:
        params["help_find"] = help_find
    return params


def v_3d_toy_prog_cargs(
    params: V3dToyProgParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dToyProg")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_dataset"))
    ])
    if params.get("output_prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("output_prefix")
        ])
    if params.get("mask_dataset") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask_dataset"))
        ])
    if params.get("output_datum") is not None:
        cargs.extend([
            "-datum",
            params.get("output_datum")
        ])
    if params.get("mini_help"):
        cargs.append("-h")
    if params.get("help"):
        cargs.append("-help")
    if params.get("extreme_help"):
        cargs.append("-HELP")
    if params.get("help_view"):
        cargs.append("-h_view")
    if params.get("help_web"):
        cargs.append("-h_web")
    if params.get("help_find") is not None:
        cargs.extend([
            "-h_find",
            params.get("help_find")
        ])
    if params.get("help_raw"):
        cargs.append("-h_raw")
    if params.get("help_spx"):
        cargs.append("-h_spx")
    if params.get("help_aspx"):
        cargs.append("-h_aspx")
    if params.get("help_all_opts"):
        cargs.append("-all_opts")
    return cargs


def v_3d_toy_prog_outputs(
    params: V3dToyProgParameters,
    execution: Execution,
) -> V3dToyProgOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dToyProgOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3d_toy_prog_execute(
    params: V3dToyProgParameters,
    execution: Execution,
) -> V3dToyProgOutputs:
    """
    A program to illustrate dataset creation and manipulation in C using AFNI's API.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dToyProgOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_toy_prog_cargs(params, execution)
    ret = v_3d_toy_prog_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_toy_prog(
    input_dataset: InputPathType,
    output_prefix: str | None = None,
    mask_dataset: InputPathType | None = None,
    output_datum: typing.Literal["float", "short"] | None = None,
    mini_help: bool = False,
    help_: bool = False,
    extreme_help: bool = False,
    help_view: bool = False,
    help_web: bool = False,
    help_find: str | None = None,
    help_raw: bool = False,
    help_spx: bool = False,
    help_aspx: bool = False,
    help_all_opts: bool = False,
    runner: Runner | None = None,
) -> V3dToyProgOutputs:
    """
    A program to illustrate dataset creation and manipulation in C using AFNI's API.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_dataset: Reference dataset.
        output_prefix: Prefix of the output datasets.
        mask_dataset: Restrict analysis to non-zero voxels in the mask dataset.
        output_datum: Output datum type for one of the datasets. Choose from\
            'float' or 'short'. Default is 'float'.
        mini_help: Mini help, at time, same as -help in many cases.
        help_: The entire help output.
        extreme_help: Extreme help, same as -help in majority of cases.
        help_view: Open help in text editor. AFNI will try to find a GUI editor\
            on your machine. You can control which it should use by setting\
            environment variable AFNI_GUI_EDITOR.
        help_web: Open help in web browser. AFNI will try to find a browser on\
            your machine. You can control which it should use by setting\
            environment variable AFNI_GUI_EDITOR.
        help_find: Look for lines in this program's -help output that match\
            (approximately) WORD.
        help_raw: Help string unedited.
        help_spx: Help string in sphinx loveliness, but do not try to\
            autoformat.
        help_aspx: Help string in sphinx with autoformatting of options, etc.
        help_all_opts: Try to identify all options for the program from the\
            output of its -help option. Some options might be missed and others\
            misidentified. Use this output for hints only.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dToyProgOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_TOY_PROG_METADATA)
    params = v_3d_toy_prog_params(
        input_dataset=input_dataset,
        output_prefix=output_prefix,
        mask_dataset=mask_dataset,
        output_datum=output_datum,
        mini_help=mini_help,
        help_=help_,
        extreme_help=extreme_help,
        help_view=help_view,
        help_web=help_web,
        help_find=help_find,
        help_raw=help_raw,
        help_spx=help_spx,
        help_aspx=help_aspx,
        help_all_opts=help_all_opts,
    )
    return v_3d_toy_prog_execute(params, execution)


__all__ = [
    "V3dToyProgOutputs",
    "V3dToyProgParameters",
    "V_3D_TOY_PROG_METADATA",
    "v_3d_toy_prog",
    "v_3d_toy_prog_params",
]
