# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_TRACK_ID_METADATA = Metadata(
    id="3f64f0f6b5dc6322ed516320e5dec4b5ffc35c45.boutiques",
    name="3dTrackID",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dTrackIdParameters = typing.TypedDict('V3dTrackIdParameters', {
    "__STYXTYPE__": typing.Literal["3dTrackID"],
    "mode": typing.Literal["DET", "MINIP", "PROB"],
    "netrois": InputPathType,
    "prefix": str,
    "dti_in": typing.NotRequired[str | None],
    "dti_list": typing.NotRequired[InputPathType | None],
    "dti_extra": typing.NotRequired[str | None],
    "dti_search_no": bool,
    "hardi_gfa": typing.NotRequired[InputPathType | None],
    "hardi_dirs": typing.NotRequired[InputPathType | None],
    "hardi_pars": typing.NotRequired[str | None],
    "mask": typing.NotRequired[InputPathType | None],
    "thru_mask": typing.NotRequired[InputPathType | None],
    "targ_surf_stop": bool,
    "targ_surf_twixt": bool,
    "logic": typing.Literal["OR", "AND"],
    "mini_num": typing.NotRequired[float | None],
    "uncert": typing.NotRequired[InputPathType | None],
    "unc_min_fa": typing.NotRequired[float | None],
    "unc_min_v": typing.NotRequired[float | None],
    "algopt": typing.NotRequired[InputPathType | None],
    "alg_thresh_fa": typing.NotRequired[float | None],
    "alg_thresh_ang": typing.NotRequired[float | None],
    "alg_thresh_len": typing.NotRequired[float | None],
    "alg_nseed_x": typing.NotRequired[float | None],
    "alg_nseed_y": typing.NotRequired[float | None],
    "alg_nseed_z": typing.NotRequired[float | None],
    "alg_thresh_frac": typing.NotRequired[float | None],
    "alg_nseed_vox": typing.NotRequired[float | None],
    "alg_nmonte": typing.NotRequired[float | None],
    "extra_tr_par": bool,
    "uncut_at_rois": bool,
    "dump_rois": typing.NotRequired[typing.Literal["DUMP", "AFNI", "BOTH", "AFNI_MAP"] | None],
    "dump_no_labtab": bool,
    "dump_lab_consec": bool,
    "posteriori": bool,
    "rec_orig": bool,
    "do_trk_out": bool,
    "trk_opp_orient": bool,
    "nifti": bool,
    "no_indipair_out": bool,
    "write_rois": bool,
    "write_opts": bool,
    "pair_out_power": bool,
    "verb": typing.NotRequired[float | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dTrackID": v_3d_track_id_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dTrackID": v_3d_track_id_outputs,
    }.get(t)


class V3dTrackIdOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_track_id(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    indimap: OutputPathType
    """Output of INDIMAP"""
    pairmap: OutputPathType
    """Output of PAIRMAP"""
    grid: OutputPathType
    """Text file output of statistics of WM-ROIs"""
    niml_tract: OutputPathType
    """Track-like output for viewing in SUMA"""
    niml_dset: OutputPathType
    """Dataset output for use with *.niml.tract"""
    trk: OutputPathType
    """TrackVis-like output for viewing in TrackVis"""
    pairmap_labeltable: OutputPathType
    """Output of PAIRMAP labeltable"""
    roi_labels: OutputPathType
    """Output file of all ROI labels"""
    option_values: OutputPathType
    """Output of all option values"""


def v_3d_track_id_params(
    mode: typing.Literal["DET", "MINIP", "PROB"],
    netrois: InputPathType,
    prefix: str,
    logic: typing.Literal["OR", "AND"],
    dti_in: str | None = None,
    dti_list: InputPathType | None = None,
    dti_extra: str | None = None,
    dti_search_no: bool = False,
    hardi_gfa: InputPathType | None = None,
    hardi_dirs: InputPathType | None = None,
    hardi_pars: str | None = None,
    mask: InputPathType | None = None,
    thru_mask: InputPathType | None = None,
    targ_surf_stop: bool = False,
    targ_surf_twixt: bool = False,
    mini_num: float | None = None,
    uncert: InputPathType | None = None,
    unc_min_fa: float | None = None,
    unc_min_v: float | None = None,
    algopt: InputPathType | None = None,
    alg_thresh_fa: float | None = None,
    alg_thresh_ang: float | None = None,
    alg_thresh_len: float | None = None,
    alg_nseed_x: float | None = None,
    alg_nseed_y: float | None = None,
    alg_nseed_z: float | None = None,
    alg_thresh_frac: float | None = None,
    alg_nseed_vox: float | None = None,
    alg_nmonte: float | None = None,
    extra_tr_par: bool = False,
    uncut_at_rois: bool = False,
    dump_rois: typing.Literal["DUMP", "AFNI", "BOTH", "AFNI_MAP"] | None = None,
    dump_no_labtab: bool = False,
    dump_lab_consec: bool = False,
    posteriori: bool = False,
    rec_orig: bool = False,
    do_trk_out: bool = False,
    trk_opp_orient: bool = False,
    nifti: bool = False,
    no_indipair_out: bool = False,
    write_rois: bool = False,
    write_opts: bool = False,
    pair_out_power: bool = False,
    verb: float | None = None,
) -> V3dTrackIdParameters:
    """
    Build parameters.
    
    Args:
        mode: The mode of tracking: DET, MINIP, or PROB.
        netrois: Network ROI mask(s).
        prefix: Prefix for output files.
        logic: Control logic connections among target ROIs per network.
        dti_in: Input DTI volumes basename.
        dti_list: Alternative way to specify DTI input files, a NIML-formatted\
            text file.
        dti_extra: Option for extra scalar for WM skeleton thresholding.
        dti_search_no: Turn off automatic search for additional scalar files to\
            include in output.
        hardi_gfa: Single brik dataset with generalized FA (GFA) info.
        hardi_dirs: Directions file for HARDI data containing directions\
            components.
        hardi_pars: Prefix to search for scalar files naming format.
        mask: Mask within which tracking is done. Optional but highly\
            recommended.
        thru_mask: Extra restrictor mask through which paths are strictly\
            required to pass.
        targ_surf_stop: Make tracts stop at outer surfaces of the target ROIs.
        targ_surf_twixt: Make tracts stop just before entering target surfaces.
        mini_num: Number of whole brain Monte Carlo iterations for\
            mini-probabilistic tracking.
        uncert: Uncertainty values file.
        unc_min_fa: Minimum stdev for perturbing FA.
        unc_min_v: Minimum stdev for perturbing direction-vectors.
        algopt: Specify tracking parameter quantities file in ASCII.
        alg_thresh_fa: Set threshold for FA map or other WM proxy.
        alg_thresh_ang: Set maximum angle for turning during propagation.
        alg_thresh_len: Set minimum physical length of tracts to keep.
        alg_nseed_x: Number of seeds per voxel in x-direction.
        alg_nseed_y: Number of seeds per voxel in y-direction.
        alg_nseed_z: Number of seeds per voxel in z-direction.
        alg_thresh_frac: Value for thresholding the fraction of tracks through\
            a voxel for a given connection.
        alg_nseed_vox: Number of seeds per voxel per Monte Carlo iteration.
        alg_nmonte: Number of Monte Carlo iterations.
        extra_tr_par: Run three extra track parameter scalings for each\
            connection.
        uncut_at_rois: Keep entire track even if overshoots a target.
        dump_rois: Output individual masks of ROI connections.
        dump_no_labtab: Turn off label table use in ROI dump output.
        dump_lab_consec: DON'T apply numerical labels of original ROIs in dump\
            output.
        posteriori: Output individual files with number of tracks per voxel per\
            pair.
        rec_orig: Record dataset origin in header of *.trk file.
        do_trk_out: Output *.trk files for viewing in TrackVis.
        trk_opp_orient: Oppositize voxel_order for TRK files.
        nifti: Output files in *.nii.gz format.
        no_indipair_out: Do not output INDIMAP and PAIRMAP volumes.
        write_rois: Write out ROI labels.
        write_opts: Write out all option values.
        pair_out_power: Switch to use powers of two labelling for PAIRMAP.
        verb: Set verbosity level.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dTrackID",
        "mode": mode,
        "netrois": netrois,
        "prefix": prefix,
        "dti_search_no": dti_search_no,
        "targ_surf_stop": targ_surf_stop,
        "targ_surf_twixt": targ_surf_twixt,
        "logic": logic,
        "extra_tr_par": extra_tr_par,
        "uncut_at_rois": uncut_at_rois,
        "dump_no_labtab": dump_no_labtab,
        "dump_lab_consec": dump_lab_consec,
        "posteriori": posteriori,
        "rec_orig": rec_orig,
        "do_trk_out": do_trk_out,
        "trk_opp_orient": trk_opp_orient,
        "nifti": nifti,
        "no_indipair_out": no_indipair_out,
        "write_rois": write_rois,
        "write_opts": write_opts,
        "pair_out_power": pair_out_power,
    }
    if dti_in is not None:
        params["dti_in"] = dti_in
    if dti_list is not None:
        params["dti_list"] = dti_list
    if dti_extra is not None:
        params["dti_extra"] = dti_extra
    if hardi_gfa is not None:
        params["hardi_gfa"] = hardi_gfa
    if hardi_dirs is not None:
        params["hardi_dirs"] = hardi_dirs
    if hardi_pars is not None:
        params["hardi_pars"] = hardi_pars
    if mask is not None:
        params["mask"] = mask
    if thru_mask is not None:
        params["thru_mask"] = thru_mask
    if mini_num is not None:
        params["mini_num"] = mini_num
    if uncert is not None:
        params["uncert"] = uncert
    if unc_min_fa is not None:
        params["unc_min_fa"] = unc_min_fa
    if unc_min_v is not None:
        params["unc_min_v"] = unc_min_v
    if algopt is not None:
        params["algopt"] = algopt
    if alg_thresh_fa is not None:
        params["alg_thresh_fa"] = alg_thresh_fa
    if alg_thresh_ang is not None:
        params["alg_thresh_ang"] = alg_thresh_ang
    if alg_thresh_len is not None:
        params["alg_thresh_len"] = alg_thresh_len
    if alg_nseed_x is not None:
        params["alg_nseed_x"] = alg_nseed_x
    if alg_nseed_y is not None:
        params["alg_nseed_y"] = alg_nseed_y
    if alg_nseed_z is not None:
        params["alg_nseed_z"] = alg_nseed_z
    if alg_thresh_frac is not None:
        params["alg_thresh_frac"] = alg_thresh_frac
    if alg_nseed_vox is not None:
        params["alg_nseed_vox"] = alg_nseed_vox
    if alg_nmonte is not None:
        params["alg_nmonte"] = alg_nmonte
    if dump_rois is not None:
        params["dump_rois"] = dump_rois
    if verb is not None:
        params["verb"] = verb
    return params


def v_3d_track_id_cargs(
    params: V3dTrackIdParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dTrackID")
    cargs.append(params.get("mode"))
    cargs.append(execution.input_file(params.get("netrois")))
    cargs.append(params.get("prefix"))
    if params.get("dti_in") is not None:
        cargs.append(params.get("dti_in"))
    if params.get("dti_list") is not None:
        cargs.append(execution.input_file(params.get("dti_list")))
    if params.get("dti_extra") is not None:
        cargs.append(params.get("dti_extra"))
    if params.get("dti_search_no"):
        cargs.append("-dti_search_NO")
    if params.get("hardi_gfa") is not None:
        cargs.append(execution.input_file(params.get("hardi_gfa")))
    if params.get("hardi_dirs") is not None:
        cargs.append(execution.input_file(params.get("hardi_dirs")))
    if params.get("hardi_pars") is not None:
        cargs.append(params.get("hardi_pars"))
    if params.get("mask") is not None:
        cargs.append(execution.input_file(params.get("mask")))
    if params.get("thru_mask") is not None:
        cargs.append(execution.input_file(params.get("thru_mask")))
    if params.get("targ_surf_stop"):
        cargs.append("-targ_surf_stop")
    if params.get("targ_surf_twixt"):
        cargs.append("-targ_surf_twixt")
    cargs.append(params.get("logic"))
    if params.get("mini_num") is not None:
        cargs.append(str(params.get("mini_num")))
    if params.get("uncert") is not None:
        cargs.append(execution.input_file(params.get("uncert")))
    if params.get("unc_min_fa") is not None:
        cargs.append(str(params.get("unc_min_fa")))
    if params.get("unc_min_v") is not None:
        cargs.append(str(params.get("unc_min_v")))
    if params.get("algopt") is not None:
        cargs.append(execution.input_file(params.get("algopt")))
    if params.get("alg_thresh_fa") is not None:
        cargs.append(str(params.get("alg_thresh_fa")))
    if params.get("alg_thresh_ang") is not None:
        cargs.append(str(params.get("alg_thresh_ang")))
    if params.get("alg_thresh_len") is not None:
        cargs.append(str(params.get("alg_thresh_len")))
    if params.get("alg_nseed_x") is not None:
        cargs.append(str(params.get("alg_nseed_x")))
    if params.get("alg_nseed_y") is not None:
        cargs.append(str(params.get("alg_nseed_y")))
    if params.get("alg_nseed_z") is not None:
        cargs.append(str(params.get("alg_nseed_z")))
    if params.get("alg_thresh_frac") is not None:
        cargs.append(str(params.get("alg_thresh_frac")))
    if params.get("alg_nseed_vox") is not None:
        cargs.append(str(params.get("alg_nseed_vox")))
    if params.get("alg_nmonte") is not None:
        cargs.append(str(params.get("alg_nmonte")))
    if params.get("extra_tr_par"):
        cargs.append("-extra_tr_par")
    if params.get("uncut_at_rois"):
        cargs.append("-uncut_at_rois")
    if params.get("dump_rois") is not None:
        cargs.append(params.get("dump_rois"))
    if params.get("dump_no_labtab"):
        cargs.append("-dump_no_labtab")
    if params.get("dump_lab_consec"):
        cargs.append("-dump_lab_consec")
    if params.get("posteriori"):
        cargs.append("-posteriori")
    if params.get("rec_orig"):
        cargs.append("-rec_orig")
    if params.get("do_trk_out"):
        cargs.append("-do_trk_out")
    if params.get("trk_opp_orient"):
        cargs.append("-trk_opp_orient")
    if params.get("nifti"):
        cargs.append("-nifti")
    if params.get("no_indipair_out"):
        cargs.append("-no_indipair_out")
    if params.get("write_rois"):
        cargs.append("-write_rois")
    if params.get("write_opts"):
        cargs.append("-write_opts")
    if params.get("pair_out_power"):
        cargs.append("-pair_out_power")
    if params.get("verb") is not None:
        cargs.append(str(params.get("verb")))
    return cargs


def v_3d_track_id_outputs(
    params: V3dTrackIdParameters,
    execution: Execution,
) -> V3dTrackIdOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dTrackIdOutputs(
        root=execution.output_file("."),
        indimap=execution.output_file(params.get("prefix") + "_INDIMAP.nii.gz"),
        pairmap=execution.output_file(params.get("prefix") + "_PAIRMAP.nii.gz"),
        grid=execution.output_file(params.get("prefix") + ".grid"),
        niml_tract=execution.output_file(params.get("prefix") + ".niml.tract"),
        niml_dset=execution.output_file(params.get("prefix") + ".niml.dset"),
        trk=execution.output_file(params.get("prefix") + ".trk"),
        pairmap_labeltable=execution.output_file(params.get("prefix") + "_PAIRS.niml.lt"),
        roi_labels=execution.output_file(params.get("prefix") + "_roi.labs"),
        option_values=execution.output_file(params.get("prefix") + ".niml.opts"),
    )
    return ret


def v_3d_track_id_execute(
    params: V3dTrackIdParameters,
    execution: Execution,
) -> V3dTrackIdOutputs:
    """
    FACTID-based tractography code for AFNI, part of FATCAT.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dTrackIdOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_track_id_cargs(params, execution)
    ret = v_3d_track_id_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_track_id(
    mode: typing.Literal["DET", "MINIP", "PROB"],
    netrois: InputPathType,
    prefix: str,
    logic: typing.Literal["OR", "AND"],
    dti_in: str | None = None,
    dti_list: InputPathType | None = None,
    dti_extra: str | None = None,
    dti_search_no: bool = False,
    hardi_gfa: InputPathType | None = None,
    hardi_dirs: InputPathType | None = None,
    hardi_pars: str | None = None,
    mask: InputPathType | None = None,
    thru_mask: InputPathType | None = None,
    targ_surf_stop: bool = False,
    targ_surf_twixt: bool = False,
    mini_num: float | None = None,
    uncert: InputPathType | None = None,
    unc_min_fa: float | None = None,
    unc_min_v: float | None = None,
    algopt: InputPathType | None = None,
    alg_thresh_fa: float | None = None,
    alg_thresh_ang: float | None = None,
    alg_thresh_len: float | None = None,
    alg_nseed_x: float | None = None,
    alg_nseed_y: float | None = None,
    alg_nseed_z: float | None = None,
    alg_thresh_frac: float | None = None,
    alg_nseed_vox: float | None = None,
    alg_nmonte: float | None = None,
    extra_tr_par: bool = False,
    uncut_at_rois: bool = False,
    dump_rois: typing.Literal["DUMP", "AFNI", "BOTH", "AFNI_MAP"] | None = None,
    dump_no_labtab: bool = False,
    dump_lab_consec: bool = False,
    posteriori: bool = False,
    rec_orig: bool = False,
    do_trk_out: bool = False,
    trk_opp_orient: bool = False,
    nifti: bool = False,
    no_indipair_out: bool = False,
    write_rois: bool = False,
    write_opts: bool = False,
    pair_out_power: bool = False,
    verb: float | None = None,
    runner: Runner | None = None,
) -> V3dTrackIdOutputs:
    """
    FACTID-based tractography code for AFNI, part of FATCAT.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        mode: The mode of tracking: DET, MINIP, or PROB.
        netrois: Network ROI mask(s).
        prefix: Prefix for output files.
        logic: Control logic connections among target ROIs per network.
        dti_in: Input DTI volumes basename.
        dti_list: Alternative way to specify DTI input files, a NIML-formatted\
            text file.
        dti_extra: Option for extra scalar for WM skeleton thresholding.
        dti_search_no: Turn off automatic search for additional scalar files to\
            include in output.
        hardi_gfa: Single brik dataset with generalized FA (GFA) info.
        hardi_dirs: Directions file for HARDI data containing directions\
            components.
        hardi_pars: Prefix to search for scalar files naming format.
        mask: Mask within which tracking is done. Optional but highly\
            recommended.
        thru_mask: Extra restrictor mask through which paths are strictly\
            required to pass.
        targ_surf_stop: Make tracts stop at outer surfaces of the target ROIs.
        targ_surf_twixt: Make tracts stop just before entering target surfaces.
        mini_num: Number of whole brain Monte Carlo iterations for\
            mini-probabilistic tracking.
        uncert: Uncertainty values file.
        unc_min_fa: Minimum stdev for perturbing FA.
        unc_min_v: Minimum stdev for perturbing direction-vectors.
        algopt: Specify tracking parameter quantities file in ASCII.
        alg_thresh_fa: Set threshold for FA map or other WM proxy.
        alg_thresh_ang: Set maximum angle for turning during propagation.
        alg_thresh_len: Set minimum physical length of tracts to keep.
        alg_nseed_x: Number of seeds per voxel in x-direction.
        alg_nseed_y: Number of seeds per voxel in y-direction.
        alg_nseed_z: Number of seeds per voxel in z-direction.
        alg_thresh_frac: Value for thresholding the fraction of tracks through\
            a voxel for a given connection.
        alg_nseed_vox: Number of seeds per voxel per Monte Carlo iteration.
        alg_nmonte: Number of Monte Carlo iterations.
        extra_tr_par: Run three extra track parameter scalings for each\
            connection.
        uncut_at_rois: Keep entire track even if overshoots a target.
        dump_rois: Output individual masks of ROI connections.
        dump_no_labtab: Turn off label table use in ROI dump output.
        dump_lab_consec: DON'T apply numerical labels of original ROIs in dump\
            output.
        posteriori: Output individual files with number of tracks per voxel per\
            pair.
        rec_orig: Record dataset origin in header of *.trk file.
        do_trk_out: Output *.trk files for viewing in TrackVis.
        trk_opp_orient: Oppositize voxel_order for TRK files.
        nifti: Output files in *.nii.gz format.
        no_indipair_out: Do not output INDIMAP and PAIRMAP volumes.
        write_rois: Write out ROI labels.
        write_opts: Write out all option values.
        pair_out_power: Switch to use powers of two labelling for PAIRMAP.
        verb: Set verbosity level.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dTrackIdOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_TRACK_ID_METADATA)
    params = v_3d_track_id_params(
        mode=mode,
        netrois=netrois,
        prefix=prefix,
        dti_in=dti_in,
        dti_list=dti_list,
        dti_extra=dti_extra,
        dti_search_no=dti_search_no,
        hardi_gfa=hardi_gfa,
        hardi_dirs=hardi_dirs,
        hardi_pars=hardi_pars,
        mask=mask,
        thru_mask=thru_mask,
        targ_surf_stop=targ_surf_stop,
        targ_surf_twixt=targ_surf_twixt,
        logic=logic,
        mini_num=mini_num,
        uncert=uncert,
        unc_min_fa=unc_min_fa,
        unc_min_v=unc_min_v,
        algopt=algopt,
        alg_thresh_fa=alg_thresh_fa,
        alg_thresh_ang=alg_thresh_ang,
        alg_thresh_len=alg_thresh_len,
        alg_nseed_x=alg_nseed_x,
        alg_nseed_y=alg_nseed_y,
        alg_nseed_z=alg_nseed_z,
        alg_thresh_frac=alg_thresh_frac,
        alg_nseed_vox=alg_nseed_vox,
        alg_nmonte=alg_nmonte,
        extra_tr_par=extra_tr_par,
        uncut_at_rois=uncut_at_rois,
        dump_rois=dump_rois,
        dump_no_labtab=dump_no_labtab,
        dump_lab_consec=dump_lab_consec,
        posteriori=posteriori,
        rec_orig=rec_orig,
        do_trk_out=do_trk_out,
        trk_opp_orient=trk_opp_orient,
        nifti=nifti,
        no_indipair_out=no_indipair_out,
        write_rois=write_rois,
        write_opts=write_opts,
        pair_out_power=pair_out_power,
        verb=verb,
    )
    return v_3d_track_id_execute(params, execution)


__all__ = [
    "V3dTrackIdOutputs",
    "V3dTrackIdParameters",
    "V_3D_TRACK_ID_METADATA",
    "v_3d_track_id",
    "v_3d_track_id_params",
]
