# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_TSHIFT_METADATA = Metadata(
    id="fd213829ad2ee5b31fc3c535852e595608b30547.boutiques",
    name="3dTshift",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dTshiftParameters = typing.TypedDict('V3dTshiftParameters', {
    "__STYXTYPE__": typing.Literal["3dTshift"],
    "prefix": typing.NotRequired[str | None],
    "ignore": typing.NotRequired[int | None],
    "in_file": InputPathType,
    "interp": typing.NotRequired[typing.Literal["Fourier", "linear", "cubic", "quintic", "heptic"] | None],
    "num_threads": typing.NotRequired[int | None],
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
    "rlt": bool,
    "rltplus": bool,
    "slice_encoding_direction": typing.NotRequired[typing.Literal["k", "k-"] | None],
    "tpattern": typing.NotRequired[typing.Literal["alt+z", "altplus", "alt+z2", "alt-z", "altminus", "alt-z2", "seq+z", "seqplus", "seq-z", "seqminus"] | None],
    "tr": typing.NotRequired[float | None],
    "tslice": typing.NotRequired[int | None],
    "tzero": typing.NotRequired[float | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dTshift": v_3d_tshift_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dTshift": v_3d_tshift_outputs,
    }.get(t)


class V3dTshiftOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_tshift(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_file: OutputPathType | None
    """Output image file name."""
    timing_file: OutputPathType
    """Afni formatted timing file, if ``slice_timing`` is a list."""


def v_3d_tshift_params(
    in_file: InputPathType,
    prefix: str | None = None,
    ignore: int | None = None,
    interp: typing.Literal["Fourier", "linear", "cubic", "quintic", "heptic"] | None = None,
    num_threads: int | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    rlt: bool = False,
    rltplus: bool = False,
    slice_encoding_direction: typing.Literal["k", "k-"] | None = None,
    tpattern: typing.Literal["alt+z", "altplus", "alt+z2", "alt-z", "altminus", "alt-z2", "seq+z", "seqplus", "seq-z", "seqminus"] | None = None,
    tr: float | None = None,
    tslice: int | None = None,
    tzero: float | None = None,
) -> V3dTshiftParameters:
    """
    Build parameters.
    
    Args:
        in_file: Input file to 3dtshift.
        prefix: Prefix for output image file name.
        ignore: Ignore the first set of points specified.
        interp: 'fourier' or 'linear' or 'cubic' or 'quintic' or 'heptic'.\
            Different interpolation methods (see 3dtshift for details) default =\
            fourier.
        num_threads: Set number of threads.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        rlt: Before shifting, remove the mean and linear trend.
        rltplus: Before shifting, remove the mean and linear trend and later\
            put back the mean.
        slice_encoding_direction: 'k' or 'k-'. Direction in which slice_timing\
            is specified (default: k). if negative,slice_timing is defined in\
            reverse order, that is, the first entry corresponds to the slice with\
            the largest index, and the final entry corresponds to slice index zero.\
            only in effect when slice_timing is passed as list, not when it is\
            passed as file.
        tpattern: 'alt+z' or 'altplus' or 'alt+z2' or 'alt-z' or 'altminus' or\
            'alt-z2' or 'seq+z' or 'seqplus' or 'seq-z' or 'seqminus' or a string.\
            Use specified slice time pattern rather than one in header.
        tr: Manually set the tr. you can attach suffix "s" for seconds or "ms"\
            for milliseconds.
        tslice: Align each slice to time offset of given slice.
        tzero: Align each slice to given time offset.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dTshift",
        "in_file": in_file,
        "rlt": rlt,
        "rltplus": rltplus,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if ignore is not None:
        params["ignore"] = ignore
    if interp is not None:
        params["interp"] = interp
    if num_threads is not None:
        params["num_threads"] = num_threads
    if outputtype is not None:
        params["outputtype"] = outputtype
    if slice_encoding_direction is not None:
        params["slice_encoding_direction"] = slice_encoding_direction
    if tpattern is not None:
        params["tpattern"] = tpattern
    if tr is not None:
        params["tr"] = tr
    if tslice is not None:
        params["tslice"] = tslice
    if tzero is not None:
        params["tzero"] = tzero
    return params


def v_3d_tshift_cargs(
    params: V3dTshiftParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dTshift")
    if params.get("prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix")
        ])
    if params.get("ignore") is not None:
        cargs.extend([
            "-ignore",
            str(params.get("ignore"))
        ])
    cargs.append(execution.input_file(params.get("in_file")))
    if params.get("interp") is not None:
        cargs.extend([
            "-",
            params.get("interp")
        ])
    if params.get("num_threads") is not None:
        cargs.append(str(params.get("num_threads")))
    if params.get("outputtype") is not None:
        cargs.append(params.get("outputtype"))
    if params.get("rlt"):
        cargs.append("-rlt")
    if params.get("rltplus"):
        cargs.append("-rlt+")
    if params.get("slice_encoding_direction") is not None:
        cargs.append(params.get("slice_encoding_direction"))
    if params.get("tpattern") is not None:
        cargs.extend([
            "-tpattern",
            params.get("tpattern")
        ])
    if params.get("tr") is not None:
        cargs.extend([
            "-TR",
            str(params.get("tr"))
        ])
    if params.get("tslice") is not None:
        cargs.extend([
            "-slice",
            str(params.get("tslice"))
        ])
    if params.get("tzero") is not None:
        cargs.extend([
            "-tzero",
            str(params.get("tzero"))
        ])
    return cargs


def v_3d_tshift_outputs(
    params: V3dTshiftParameters,
    execution: Execution,
) -> V3dTshiftOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dTshiftOutputs(
        root=execution.output_file("."),
        out_file=execution.output_file(params.get("prefix")) if (params.get("prefix") is not None) else None,
        timing_file=execution.output_file("timing_file"),
    )
    return ret


def v_3d_tshift_execute(
    params: V3dTshiftParameters,
    execution: Execution,
) -> V3dTshiftOutputs:
    """
    Shifts voxel time series from input so that separate slices are aligned to the
    same temporal origin.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dTshiftOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_tshift_cargs(params, execution)
    ret = v_3d_tshift_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_tshift(
    in_file: InputPathType,
    prefix: str | None = None,
    ignore: int | None = None,
    interp: typing.Literal["Fourier", "linear", "cubic", "quintic", "heptic"] | None = None,
    num_threads: int | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    rlt: bool = False,
    rltplus: bool = False,
    slice_encoding_direction: typing.Literal["k", "k-"] | None = None,
    tpattern: typing.Literal["alt+z", "altplus", "alt+z2", "alt-z", "altminus", "alt-z2", "seq+z", "seqplus", "seq-z", "seqminus"] | None = None,
    tr: float | None = None,
    tslice: int | None = None,
    tzero: float | None = None,
    runner: Runner | None = None,
) -> V3dTshiftOutputs:
    """
    Shifts voxel time series from input so that separate slices are aligned to the
    same temporal origin.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        in_file: Input file to 3dtshift.
        prefix: Prefix for output image file name.
        ignore: Ignore the first set of points specified.
        interp: 'fourier' or 'linear' or 'cubic' or 'quintic' or 'heptic'.\
            Different interpolation methods (see 3dtshift for details) default =\
            fourier.
        num_threads: Set number of threads.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        rlt: Before shifting, remove the mean and linear trend.
        rltplus: Before shifting, remove the mean and linear trend and later\
            put back the mean.
        slice_encoding_direction: 'k' or 'k-'. Direction in which slice_timing\
            is specified (default: k). if negative,slice_timing is defined in\
            reverse order, that is, the first entry corresponds to the slice with\
            the largest index, and the final entry corresponds to slice index zero.\
            only in effect when slice_timing is passed as list, not when it is\
            passed as file.
        tpattern: 'alt+z' or 'altplus' or 'alt+z2' or 'alt-z' or 'altminus' or\
            'alt-z2' or 'seq+z' or 'seqplus' or 'seq-z' or 'seqminus' or a string.\
            Use specified slice time pattern rather than one in header.
        tr: Manually set the tr. you can attach suffix "s" for seconds or "ms"\
            for milliseconds.
        tslice: Align each slice to time offset of given slice.
        tzero: Align each slice to given time offset.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dTshiftOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_TSHIFT_METADATA)
    params = v_3d_tshift_params(
        prefix=prefix,
        ignore=ignore,
        in_file=in_file,
        interp=interp,
        num_threads=num_threads,
        outputtype=outputtype,
        rlt=rlt,
        rltplus=rltplus,
        slice_encoding_direction=slice_encoding_direction,
        tpattern=tpattern,
        tr=tr,
        tslice=tslice,
        tzero=tzero,
    )
    return v_3d_tshift_execute(params, execution)


__all__ = [
    "V3dTshiftOutputs",
    "V3dTshiftParameters",
    "V_3D_TSHIFT_METADATA",
    "v_3d_tshift",
    "v_3d_tshift_params",
]
