# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_TSTAT_METADATA = Metadata(
    id="d57f08b6e63dd68a1af0835dbc04abda819f48b9.boutiques",
    name="3dTstat",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dTstatParameters = typing.TypedDict('V3dTstatParameters', {
    "__STYXTYPE__": typing.Literal["3dTstat"],
    "in_file": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "num_threads": typing.NotRequired[int | None],
    "options": typing.NotRequired[str | None],
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
    "sum": bool,
    "abssum": bool,
    "sos": bool,
    "l2norm": bool,
    "mean": bool,
    "slope": bool,
    "stdev": bool,
    "stdevNOD": bool,
    "cvar": bool,
    "cvarNOD": bool,
    "cvarinv": bool,
    "cvarinvNOD": bool,
    "tsnr": bool,
    "MAD": bool,
    "DW": bool,
    "median": bool,
    "nzmedian": bool,
    "nzstdev": bool,
    "bmv": bool,
    "MSSD": bool,
    "MSSDsqrt": bool,
    "MASDx": bool,
    "min": bool,
    "max": bool,
    "absmax": bool,
    "signed_absmax": bool,
    "percentile": bool,
    "argmin": bool,
    "argmin1": bool,
    "argmax": bool,
    "argmax1": bool,
    "argabsmax": bool,
    "argabsmax1": bool,
    "duration": bool,
    "onset": bool,
    "offset": bool,
    "centroid": bool,
    "centduration": bool,
    "nzmean": bool,
    "zcount": bool,
    "nzcount": bool,
    "autocorr": bool,
    "autoreg": bool,
    "accumulate": bool,
    "centromean": bool,
    "skewness": bool,
    "kurtosis": bool,
    "firstvalue": bool,
    "tdiff": bool,
    "prefix": typing.NotRequired[str | None],
    "datum": typing.NotRequired[str | None],
    "nscale": bool,
    "basepercent": typing.NotRequired[float | None],
    "mask_mset": typing.NotRequired[InputPathType | None],
    "mrange": typing.NotRequired[str | None],
    "cmask": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dTstat": v_3d_tstat_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dTstat": v_3d_tstat_outputs,
    }.get(t)


class V3dTstatOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_tstat(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_file: OutputPathType | None
    """Output image file name."""


def v_3d_tstat_params(
    in_file: InputPathType,
    mask: InputPathType | None = None,
    num_threads: int | None = None,
    options: str | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    sum_: bool = False,
    abssum: bool = False,
    sos: bool = False,
    l2norm: bool = False,
    mean: bool = False,
    slope: bool = False,
    stdev: bool = False,
    stdev_nod: bool = False,
    cvar: bool = False,
    cvar_nod: bool = False,
    cvarinv: bool = False,
    cvarinv_nod: bool = False,
    tsnr: bool = False,
    mad: bool = False,
    dw: bool = False,
    median: bool = False,
    nzmedian: bool = False,
    nzstdev: bool = False,
    bmv: bool = False,
    mssd: bool = False,
    mssdsqrt: bool = False,
    masdx: bool = False,
    min_: bool = False,
    max_: bool = False,
    absmax: bool = False,
    signed_absmax: bool = False,
    percentile: bool = False,
    argmin: bool = False,
    argmin1: bool = False,
    argmax: bool = False,
    argmax1: bool = False,
    argabsmax: bool = False,
    argabsmax1: bool = False,
    duration: bool = False,
    onset: bool = False,
    offset: bool = False,
    centroid: bool = False,
    centduration: bool = False,
    nzmean: bool = False,
    zcount: bool = False,
    nzcount: bool = False,
    autocorr: bool = False,
    autoreg: bool = False,
    accumulate: bool = False,
    centromean: bool = False,
    skewness: bool = False,
    kurtosis: bool = False,
    firstvalue: bool = False,
    tdiff: bool = False,
    prefix: str | None = None,
    datum: str | None = None,
    nscale: bool = False,
    basepercent: float | None = None,
    mask_mset: InputPathType | None = None,
    mrange: str | None = None,
    cmask: str | None = None,
) -> V3dTstatParameters:
    """
    Build parameters.
    
    Args:
        in_file: Input file to 3dtstat.
        mask: Mask file.
        num_threads: Set number of threads.
        options: Selected statistical output.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        sum_: Compute sum of input voxels.
        abssum: Compute absolute sum of input voxels.
        sos: Compute sum of squares.
        l2norm: Compute L2 norm (sqrt(sum squares)).
        mean: Compute mean of input voxels.
        slope: Compute the slope of input voxels vs. time.
        stdev: Compute standard deviation of input voxels.
        stdev_nod: Compute standard deviation of input voxels without\
            detrending.
        cvar: Compute coefficient of variation of input voxels.
        cvar_nod: Compute coefficient of variation of input voxels without\
            detrending.
        cvarinv: Compute inverse coefficient of variation of input voxels.
        cvarinv_nod: Compute inverse coefficient of variation of input voxels\
            without detrending.
        tsnr: Compute temporal signal to noise ratio.
        mad: Compute median absolute deviation of input voxels.
        dw: Compute Durbin-Watson Statistic of input voxels.
        median: Compute median of input voxels.
        nzmedian: Compute median of non-zero input voxels.
        nzstdev: Compute standard deviation of non-zero input voxels.
        bmv: Compute biweight midvariance of input voxels.
        mssd: Compute mean of successive squared differences of input voxels.
        mssdsqrt: Compute square root of mean of successive squared differences\
            of input voxels.
        masdx: Compute median of absolute values of first time differences of\
            input voxels.
        min_: Compute minimum of input voxels.
        max_: Compute maximum of input voxels.
        absmax: Compute absolute maximum of input voxels.
        signed_absmax: Compute signed absolute maximum of input voxels.
        percentile: Compute the P-th percentile point of the data in each voxel\
            time series.
        argmin: Compute index of minimum of input voxels.
        argmin1: Compute index + 1 of minimum of input voxels.
        argmax: Compute index of maximum of input voxels.
        argmax1: Compute index + 1 of maximum of input voxels.
        argabsmax: Compute index of absolute maximum of input voxels.
        argabsmax1: Compute index + 1 of absolute maximum of input voxels.
        duration: Compute number of points around max above a threshold.
        onset: Compute beginning of duration around max where value exceeds\
            basepercent.
        offset: Compute end of duration around max where value exceeds\
            basepercent.
        centroid: Compute centroid of data time curves.
        centduration: Compute duration using centroid's index as center.
        nzmean: Compute mean of non-zero voxels.
        zcount: Count number of zero values at each voxel.
        nzcount: Count number of non-zero values at each voxel.
        autocorr: Compute autocorrelation function and return first n\
            coefficients.
        autoreg: Compute autoregression coefficients and return first n\
            coefficients.
        accumulate: Accumulate time series values (partial sums).
        centromean: Compute mean of middle 50% of voxel values.
        skewness: Measure of asymmetry in distribution.
        kurtosis: Measure of the 'tailedness' of the probability distribution.
        firstvalue: First value in dataset.
        tdiff: Take the first difference of each time series before further\
            processing.
        prefix: Use string 'p' for the prefix of the output dataset [DEFAULT =\
            'stat'].
        datum: Use data type 'd' for the type of storage of the output, where\
            'd' is one of 'byte', 'short', or 'float' [DEFAULT=float].
        nscale: Do not scale output values when datum is byte or short. Scaling\
            is done by default.
        basepercent: Percentage of maximum for duration calculation.
        mask_mset: Use the dataset 'mset' as a mask. Only voxels with nonzero\
            values in 'mset' will be printed from 'dataset'.
        mrange: Further restrict the voxels from 'mset' so that only those mask\
            values between 'a' and 'b' (inclusive) will be used.
        cmask: Execute the options enclosed in single quotes as a 3dcalc-like\
            program, and produce a mask from the resulting 3D brick.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dTstat",
        "in_file": in_file,
        "sum": sum_,
        "abssum": abssum,
        "sos": sos,
        "l2norm": l2norm,
        "mean": mean,
        "slope": slope,
        "stdev": stdev,
        "stdevNOD": stdev_nod,
        "cvar": cvar,
        "cvarNOD": cvar_nod,
        "cvarinv": cvarinv,
        "cvarinvNOD": cvarinv_nod,
        "tsnr": tsnr,
        "MAD": mad,
        "DW": dw,
        "median": median,
        "nzmedian": nzmedian,
        "nzstdev": nzstdev,
        "bmv": bmv,
        "MSSD": mssd,
        "MSSDsqrt": mssdsqrt,
        "MASDx": masdx,
        "min": min_,
        "max": max_,
        "absmax": absmax,
        "signed_absmax": signed_absmax,
        "percentile": percentile,
        "argmin": argmin,
        "argmin1": argmin1,
        "argmax": argmax,
        "argmax1": argmax1,
        "argabsmax": argabsmax,
        "argabsmax1": argabsmax1,
        "duration": duration,
        "onset": onset,
        "offset": offset,
        "centroid": centroid,
        "centduration": centduration,
        "nzmean": nzmean,
        "zcount": zcount,
        "nzcount": nzcount,
        "autocorr": autocorr,
        "autoreg": autoreg,
        "accumulate": accumulate,
        "centromean": centromean,
        "skewness": skewness,
        "kurtosis": kurtosis,
        "firstvalue": firstvalue,
        "tdiff": tdiff,
        "nscale": nscale,
    }
    if mask is not None:
        params["mask"] = mask
    if num_threads is not None:
        params["num_threads"] = num_threads
    if options is not None:
        params["options"] = options
    if outputtype is not None:
        params["outputtype"] = outputtype
    if prefix is not None:
        params["prefix"] = prefix
    if datum is not None:
        params["datum"] = datum
    if basepercent is not None:
        params["basepercent"] = basepercent
    if mask_mset is not None:
        params["mask_mset"] = mask_mset
    if mrange is not None:
        params["mrange"] = mrange
    if cmask is not None:
        params["cmask"] = cmask
    return params


def v_3d_tstat_cargs(
    params: V3dTstatParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dTstat")
    cargs.append(execution.input_file(params.get("in_file")))
    if params.get("mask") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask"))
        ])
    if params.get("num_threads") is not None:
        cargs.append(str(params.get("num_threads")))
    if params.get("options") is not None:
        cargs.append(params.get("options"))
    if params.get("outputtype") is not None:
        cargs.append(params.get("outputtype"))
    if params.get("sum"):
        cargs.append("-sum")
    if params.get("abssum"):
        cargs.append("-abssum")
    if params.get("sos"):
        cargs.append("-sos")
    if params.get("l2norm"):
        cargs.append("-l2norm")
    if params.get("mean"):
        cargs.append("-mean")
    if params.get("slope"):
        cargs.append("-slope")
    if params.get("stdev"):
        cargs.append("-stdev")
    if params.get("stdevNOD"):
        cargs.append("-stdevNOD")
    if params.get("cvar"):
        cargs.append("-cvar")
    if params.get("cvarNOD"):
        cargs.append("-cvarNOD")
    if params.get("cvarinv"):
        cargs.append("-cvarinv")
    if params.get("cvarinvNOD"):
        cargs.append("-cvarinvNOD")
    if params.get("tsnr"):
        cargs.append("-tsnr")
    if params.get("MAD"):
        cargs.append("-MAD")
    if params.get("DW"):
        cargs.append("-DW")
    if params.get("median"):
        cargs.append("-median")
    if params.get("nzmedian"):
        cargs.append("-nzmedian")
    if params.get("nzstdev"):
        cargs.append("-nzstdev")
    if params.get("bmv"):
        cargs.append("-bmv")
    if params.get("MSSD"):
        cargs.append("-MSSD")
    if params.get("MSSDsqrt"):
        cargs.append("-MSSDsqrt")
    if params.get("MASDx"):
        cargs.append("-MASDx")
    if params.get("min"):
        cargs.append("-min")
    if params.get("max"):
        cargs.append("-max")
    if params.get("absmax"):
        cargs.append("-absmax")
    if params.get("signed_absmax"):
        cargs.append("-signed_absmax")
    if params.get("percentile"):
        cargs.append("-percentile")
    if params.get("argmin"):
        cargs.append("-argmin")
    if params.get("argmin1"):
        cargs.append("-argmin1")
    if params.get("argmax"):
        cargs.append("-argmax")
    if params.get("argmax1"):
        cargs.append("-argmax1")
    if params.get("argabsmax"):
        cargs.append("-argabsmax")
    if params.get("argabsmax1"):
        cargs.append("-argabsmax1")
    if params.get("duration"):
        cargs.append("-duration")
    if params.get("onset"):
        cargs.append("-onset")
    if params.get("offset"):
        cargs.append("-offset")
    if params.get("centroid"):
        cargs.append("-centroid")
    if params.get("centduration"):
        cargs.append("-centduration")
    if params.get("nzmean"):
        cargs.append("-nzmean")
    if params.get("zcount"):
        cargs.append("-zcount")
    if params.get("nzcount"):
        cargs.append("-nzcount")
    if params.get("autocorr"):
        cargs.append("-autocorr")
    if params.get("autoreg"):
        cargs.append("-autoreg")
    if params.get("accumulate"):
        cargs.append("-accumulate")
    if params.get("centromean"):
        cargs.append("-centromean")
    if params.get("skewness"):
        cargs.append("-skewness")
    if params.get("kurtosis"):
        cargs.append("-kurtosis")
    if params.get("firstvalue"):
        cargs.append("-firstvalue")
    if params.get("tdiff"):
        cargs.append("-tdiff")
    if params.get("prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix")
        ])
    if params.get("datum") is not None:
        cargs.extend([
            "-datum",
            params.get("datum")
        ])
    if params.get("nscale"):
        cargs.append("-nscale")
    if params.get("basepercent") is not None:
        cargs.extend([
            "-basepercent",
            str(params.get("basepercent"))
        ])
    if params.get("mask_mset") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask_mset"))
        ])
    if params.get("mrange") is not None:
        cargs.extend([
            "-mrange",
            params.get("mrange")
        ])
    if params.get("cmask") is not None:
        cargs.extend([
            "-cmask",
            params.get("cmask")
        ])
    return cargs


def v_3d_tstat_outputs(
    params: V3dTstatParameters,
    execution: Execution,
) -> V3dTstatOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dTstatOutputs(
        root=execution.output_file("."),
        out_file=execution.output_file(params.get("prefix")) if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_tstat_execute(
    params: V3dTstatParameters,
    execution: Execution,
) -> V3dTstatOutputs:
    """
    Compute voxel-wise statistics using AFNI 3dTstat command.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dTstatOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_tstat_cargs(params, execution)
    ret = v_3d_tstat_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_tstat(
    in_file: InputPathType,
    mask: InputPathType | None = None,
    num_threads: int | None = None,
    options: str | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    sum_: bool = False,
    abssum: bool = False,
    sos: bool = False,
    l2norm: bool = False,
    mean: bool = False,
    slope: bool = False,
    stdev: bool = False,
    stdev_nod: bool = False,
    cvar: bool = False,
    cvar_nod: bool = False,
    cvarinv: bool = False,
    cvarinv_nod: bool = False,
    tsnr: bool = False,
    mad: bool = False,
    dw: bool = False,
    median: bool = False,
    nzmedian: bool = False,
    nzstdev: bool = False,
    bmv: bool = False,
    mssd: bool = False,
    mssdsqrt: bool = False,
    masdx: bool = False,
    min_: bool = False,
    max_: bool = False,
    absmax: bool = False,
    signed_absmax: bool = False,
    percentile: bool = False,
    argmin: bool = False,
    argmin1: bool = False,
    argmax: bool = False,
    argmax1: bool = False,
    argabsmax: bool = False,
    argabsmax1: bool = False,
    duration: bool = False,
    onset: bool = False,
    offset: bool = False,
    centroid: bool = False,
    centduration: bool = False,
    nzmean: bool = False,
    zcount: bool = False,
    nzcount: bool = False,
    autocorr: bool = False,
    autoreg: bool = False,
    accumulate: bool = False,
    centromean: bool = False,
    skewness: bool = False,
    kurtosis: bool = False,
    firstvalue: bool = False,
    tdiff: bool = False,
    prefix: str | None = None,
    datum: str | None = None,
    nscale: bool = False,
    basepercent: float | None = None,
    mask_mset: InputPathType | None = None,
    mrange: str | None = None,
    cmask: str | None = None,
    runner: Runner | None = None,
) -> V3dTstatOutputs:
    """
    Compute voxel-wise statistics using AFNI 3dTstat command.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        in_file: Input file to 3dtstat.
        mask: Mask file.
        num_threads: Set number of threads.
        options: Selected statistical output.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        sum_: Compute sum of input voxels.
        abssum: Compute absolute sum of input voxels.
        sos: Compute sum of squares.
        l2norm: Compute L2 norm (sqrt(sum squares)).
        mean: Compute mean of input voxels.
        slope: Compute the slope of input voxels vs. time.
        stdev: Compute standard deviation of input voxels.
        stdev_nod: Compute standard deviation of input voxels without\
            detrending.
        cvar: Compute coefficient of variation of input voxels.
        cvar_nod: Compute coefficient of variation of input voxels without\
            detrending.
        cvarinv: Compute inverse coefficient of variation of input voxels.
        cvarinv_nod: Compute inverse coefficient of variation of input voxels\
            without detrending.
        tsnr: Compute temporal signal to noise ratio.
        mad: Compute median absolute deviation of input voxels.
        dw: Compute Durbin-Watson Statistic of input voxels.
        median: Compute median of input voxels.
        nzmedian: Compute median of non-zero input voxels.
        nzstdev: Compute standard deviation of non-zero input voxels.
        bmv: Compute biweight midvariance of input voxels.
        mssd: Compute mean of successive squared differences of input voxels.
        mssdsqrt: Compute square root of mean of successive squared differences\
            of input voxels.
        masdx: Compute median of absolute values of first time differences of\
            input voxels.
        min_: Compute minimum of input voxels.
        max_: Compute maximum of input voxels.
        absmax: Compute absolute maximum of input voxels.
        signed_absmax: Compute signed absolute maximum of input voxels.
        percentile: Compute the P-th percentile point of the data in each voxel\
            time series.
        argmin: Compute index of minimum of input voxels.
        argmin1: Compute index + 1 of minimum of input voxels.
        argmax: Compute index of maximum of input voxels.
        argmax1: Compute index + 1 of maximum of input voxels.
        argabsmax: Compute index of absolute maximum of input voxels.
        argabsmax1: Compute index + 1 of absolute maximum of input voxels.
        duration: Compute number of points around max above a threshold.
        onset: Compute beginning of duration around max where value exceeds\
            basepercent.
        offset: Compute end of duration around max where value exceeds\
            basepercent.
        centroid: Compute centroid of data time curves.
        centduration: Compute duration using centroid's index as center.
        nzmean: Compute mean of non-zero voxels.
        zcount: Count number of zero values at each voxel.
        nzcount: Count number of non-zero values at each voxel.
        autocorr: Compute autocorrelation function and return first n\
            coefficients.
        autoreg: Compute autoregression coefficients and return first n\
            coefficients.
        accumulate: Accumulate time series values (partial sums).
        centromean: Compute mean of middle 50% of voxel values.
        skewness: Measure of asymmetry in distribution.
        kurtosis: Measure of the 'tailedness' of the probability distribution.
        firstvalue: First value in dataset.
        tdiff: Take the first difference of each time series before further\
            processing.
        prefix: Use string 'p' for the prefix of the output dataset [DEFAULT =\
            'stat'].
        datum: Use data type 'd' for the type of storage of the output, where\
            'd' is one of 'byte', 'short', or 'float' [DEFAULT=float].
        nscale: Do not scale output values when datum is byte or short. Scaling\
            is done by default.
        basepercent: Percentage of maximum for duration calculation.
        mask_mset: Use the dataset 'mset' as a mask. Only voxels with nonzero\
            values in 'mset' will be printed from 'dataset'.
        mrange: Further restrict the voxels from 'mset' so that only those mask\
            values between 'a' and 'b' (inclusive) will be used.
        cmask: Execute the options enclosed in single quotes as a 3dcalc-like\
            program, and produce a mask from the resulting 3D brick.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dTstatOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_TSTAT_METADATA)
    params = v_3d_tstat_params(
        in_file=in_file,
        mask=mask,
        num_threads=num_threads,
        options=options,
        outputtype=outputtype,
        sum_=sum_,
        abssum=abssum,
        sos=sos,
        l2norm=l2norm,
        mean=mean,
        slope=slope,
        stdev=stdev,
        stdev_nod=stdev_nod,
        cvar=cvar,
        cvar_nod=cvar_nod,
        cvarinv=cvarinv,
        cvarinv_nod=cvarinv_nod,
        tsnr=tsnr,
        mad=mad,
        dw=dw,
        median=median,
        nzmedian=nzmedian,
        nzstdev=nzstdev,
        bmv=bmv,
        mssd=mssd,
        mssdsqrt=mssdsqrt,
        masdx=masdx,
        min_=min_,
        max_=max_,
        absmax=absmax,
        signed_absmax=signed_absmax,
        percentile=percentile,
        argmin=argmin,
        argmin1=argmin1,
        argmax=argmax,
        argmax1=argmax1,
        argabsmax=argabsmax,
        argabsmax1=argabsmax1,
        duration=duration,
        onset=onset,
        offset=offset,
        centroid=centroid,
        centduration=centduration,
        nzmean=nzmean,
        zcount=zcount,
        nzcount=nzcount,
        autocorr=autocorr,
        autoreg=autoreg,
        accumulate=accumulate,
        centromean=centromean,
        skewness=skewness,
        kurtosis=kurtosis,
        firstvalue=firstvalue,
        tdiff=tdiff,
        prefix=prefix,
        datum=datum,
        nscale=nscale,
        basepercent=basepercent,
        mask_mset=mask_mset,
        mrange=mrange,
        cmask=cmask,
    )
    return v_3d_tstat_execute(params, execution)


__all__ = [
    "V3dTstatOutputs",
    "V3dTstatParameters",
    "V_3D_TSTAT_METADATA",
    "v_3d_tstat",
    "v_3d_tstat_params",
]
