# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_VOL2_SURF_METADATA = Metadata(
    id="22298e050bc0d8df23c0654204a19a2ced97ccfa.boutiques",
    name="3dVol2Surf",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dVol2SurfParameters = typing.TypedDict('V3dVol2SurfParameters', {
    "__STYXTYPE__": typing.Literal["3dVol2Surf"],
    "spec_file": InputPathType,
    "sv": InputPathType,
    "grid_parent": InputPathType,
    "map_func": str,
    "surf_A": str,
    "surf_B": typing.NotRequired[str | None],
    "out_1D": typing.NotRequired[str | None],
    "out_niml": typing.NotRequired[str | None],
    "use_norms": bool,
    "norm_len": typing.NotRequired[float | None],
    "first_node": typing.NotRequired[float | None],
    "last_node": typing.NotRequired[float | None],
    "debug_level": typing.NotRequired[float | None],
    "dnode": typing.NotRequired[float | None],
    "f_steps": typing.NotRequired[float | None],
    "f_index": typing.NotRequired[str | None],
    "f_p1_mm": typing.NotRequired[float | None],
    "f_pn_mm": typing.NotRequired[float | None],
    "f_p1_fr": typing.NotRequired[float | None],
    "f_pn_fr": typing.NotRequired[float | None],
    "skip_col_nodes": bool,
    "skip_col_1dindex": bool,
    "skip_col_i": bool,
    "skip_col_j": bool,
    "skip_col_k": bool,
    "skip_col_vals": bool,
    "no_headers": bool,
    "save_seg_coords": typing.NotRequired[str | None],
    "cmask": typing.NotRequired[str | None],
    "gp_index": typing.NotRequired[float | None],
    "oob_index": typing.NotRequired[float | None],
    "oob_value": typing.NotRequired[float | None],
    "oom_value": typing.NotRequired[float | None],
    "outcols_afni_nsd": bool,
    "outcols_1_result": bool,
    "outcols_results": bool,
    "outcols_nsd_format": bool,
    "help": bool,
    "hist": bool,
    "version": bool,
    "keep_norm_dir": bool,
    "reverse_norm_dir": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dVol2Surf": v_3d_vol2_surf_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dVol2Surf": v_3d_vol2_surf_outputs,
    }.get(t)


class V3dVol2SurfOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_vol2_surf(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_1d_file: OutputPathType | None
    """1D output file"""
    out_niml_file: OutputPathType | None
    """NIML output file"""
    seg_coords_file: OutputPathType | None
    """Segment coordinates output file"""


def v_3d_vol2_surf_params(
    spec_file: InputPathType,
    sv: InputPathType,
    grid_parent: InputPathType,
    map_func: str,
    surf_a: str,
    surf_b: str | None = None,
    out_1_d: str | None = None,
    out_niml: str | None = None,
    use_norms: bool = False,
    norm_len: float | None = None,
    first_node: float | None = None,
    last_node: float | None = None,
    debug_level: float | None = None,
    dnode: float | None = None,
    f_steps: float | None = None,
    f_index: str | None = None,
    f_p1_mm: float | None = None,
    f_pn_mm: float | None = None,
    f_p1_fr: float | None = None,
    f_pn_fr: float | None = None,
    skip_col_nodes: bool = False,
    skip_col_1dindex: bool = False,
    skip_col_i: bool = False,
    skip_col_j: bool = False,
    skip_col_k: bool = False,
    skip_col_vals: bool = False,
    no_headers: bool = False,
    save_seg_coords: str | None = None,
    cmask: str | None = None,
    gp_index: float | None = None,
    oob_index: float | None = None,
    oob_value: float | None = None,
    oom_value: float | None = None,
    outcols_afni_nsd: bool = False,
    outcols_1_result: bool = False,
    outcols_results: bool = False,
    outcols_nsd_format: bool = False,
    help_: bool = False,
    hist: bool = False,
    version: bool = False,
    keep_norm_dir: bool = False,
    reverse_norm_dir: bool = False,
) -> V3dVol2SurfParameters:
    """
    Build parameters.
    
    Args:
        spec_file: SUMA spec file.
        sv: AFNI volume dataset mapped by the surface.
        grid_parent: AFNI volume dataset used as a grid and orientation master\
            for output.
        map_func: Filter for values along the segment.
        surf_a: Name of surface A from the spec file.
        surf_b: Name of surface B from the spec file.
        out_1_d: Specify a 1D file for the output.
        out_niml: Specify a niml file for the output.
        use_norms: Use normals for second surface.
        norm_len: Length for node normals.
        first_node: Skip all previous nodes.
        last_node: Skip all following nodes.
        debug_level: Verbose output level.
        dnode: Node for debug.
        f_steps: Number of steps along each segment (defines the number of\
            evenly spaced points along each segment).
        f_index: Whether to use all segment point values or only those\
            corresponding to unique volume voxels.
        f_p1_mm: Distance in millimeters to add to the first point of each line\
            segment.
        f_pn_mm: Distance in millimeters to add to the second point of each\
            line segment.
        f_p1_fr: Fractional distance to add to the first point of each line\
            segment.
        f_pn_fr: Fractional distance to add to the second point of each line\
            segment.
        skip_col_nodes: Do not output node column.
        skip_col_1dindex: Do not output 1dindex column.
        skip_col_i: Do not output i column.
        skip_col_j: Do not output j column.
        skip_col_k: Do not output k column.
        skip_col_vals: Do not output vals column.
        no_headers: Do not output column headers.
        save_seg_coords: Save segment coordinates to a file.
        cmask: Command for dataset mask.
        gp_index: Choose grid_parent sub-brick.
        oob_index: Specify default index for out of bounds nodes.
        oob_value: Specify default value for out of bounds nodes.
        oom_value: Specify default value for out of mask nodes.
        outcols_afni_nsd: Output nodes and one result column.
        outcols_1_result: Output only one result column.
        outcols_results: Output only all result columns.
        outcols_nsd_format: Output nodes and all results (NI_SURF_DSET format).
        help_: Show this help.
        hist: Show revision history.
        version: Show version information.
        keep_norm_dir: Keep the direction of the normals.
        reverse_norm_dir: Reverse the normal directions.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dVol2Surf",
        "spec_file": spec_file,
        "sv": sv,
        "grid_parent": grid_parent,
        "map_func": map_func,
        "surf_A": surf_a,
        "use_norms": use_norms,
        "skip_col_nodes": skip_col_nodes,
        "skip_col_1dindex": skip_col_1dindex,
        "skip_col_i": skip_col_i,
        "skip_col_j": skip_col_j,
        "skip_col_k": skip_col_k,
        "skip_col_vals": skip_col_vals,
        "no_headers": no_headers,
        "outcols_afni_nsd": outcols_afni_nsd,
        "outcols_1_result": outcols_1_result,
        "outcols_results": outcols_results,
        "outcols_nsd_format": outcols_nsd_format,
        "help": help_,
        "hist": hist,
        "version": version,
        "keep_norm_dir": keep_norm_dir,
        "reverse_norm_dir": reverse_norm_dir,
    }
    if surf_b is not None:
        params["surf_B"] = surf_b
    if out_1_d is not None:
        params["out_1D"] = out_1_d
    if out_niml is not None:
        params["out_niml"] = out_niml
    if norm_len is not None:
        params["norm_len"] = norm_len
    if first_node is not None:
        params["first_node"] = first_node
    if last_node is not None:
        params["last_node"] = last_node
    if debug_level is not None:
        params["debug_level"] = debug_level
    if dnode is not None:
        params["dnode"] = dnode
    if f_steps is not None:
        params["f_steps"] = f_steps
    if f_index is not None:
        params["f_index"] = f_index
    if f_p1_mm is not None:
        params["f_p1_mm"] = f_p1_mm
    if f_pn_mm is not None:
        params["f_pn_mm"] = f_pn_mm
    if f_p1_fr is not None:
        params["f_p1_fr"] = f_p1_fr
    if f_pn_fr is not None:
        params["f_pn_fr"] = f_pn_fr
    if save_seg_coords is not None:
        params["save_seg_coords"] = save_seg_coords
    if cmask is not None:
        params["cmask"] = cmask
    if gp_index is not None:
        params["gp_index"] = gp_index
    if oob_index is not None:
        params["oob_index"] = oob_index
    if oob_value is not None:
        params["oob_value"] = oob_value
    if oom_value is not None:
        params["oom_value"] = oom_value
    return params


def v_3d_vol2_surf_cargs(
    params: V3dVol2SurfParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dVol2Surf")
    cargs.append(execution.input_file(params.get("spec_file")))
    cargs.extend([
        "-sv",
        execution.input_file(params.get("sv"))
    ])
    cargs.extend([
        "-grid_parent",
        execution.input_file(params.get("grid_parent"))
    ])
    cargs.extend([
        "-map_func",
        params.get("map_func")
    ])
    cargs.extend([
        "-surf_A",
        params.get("surf_A")
    ])
    if params.get("surf_B") is not None:
        cargs.extend([
            "-surf_B",
            params.get("surf_B")
        ])
    if params.get("out_1D") is not None:
        cargs.extend([
            "-out_1D",
            params.get("out_1D")
        ])
    if params.get("out_niml") is not None:
        cargs.extend([
            "-out_niml",
            params.get("out_niml")
        ])
    if params.get("use_norms"):
        cargs.append("-use_norms")
    if params.get("norm_len") is not None:
        cargs.extend([
            "-norm_len",
            str(params.get("norm_len"))
        ])
    if params.get("first_node") is not None:
        cargs.extend([
            "-first_node",
            str(params.get("first_node"))
        ])
    if params.get("last_node") is not None:
        cargs.extend([
            "-last_node",
            str(params.get("last_node"))
        ])
    if params.get("debug_level") is not None:
        cargs.extend([
            "-debug",
            str(params.get("debug_level"))
        ])
    if params.get("dnode") is not None:
        cargs.extend([
            "-dnode",
            str(params.get("dnode"))
        ])
    if params.get("f_steps") is not None:
        cargs.extend([
            "-f_steps",
            str(params.get("f_steps"))
        ])
    if params.get("f_index") is not None:
        cargs.extend([
            "-f_index",
            params.get("f_index")
        ])
    if params.get("f_p1_mm") is not None:
        cargs.extend([
            "-f_p1_mm",
            str(params.get("f_p1_mm"))
        ])
    if params.get("f_pn_mm") is not None:
        cargs.extend([
            "-f_pn_mm",
            str(params.get("f_pn_mm"))
        ])
    if params.get("f_p1_fr") is not None:
        cargs.extend([
            "-f_p1_fr",
            str(params.get("f_p1_fr"))
        ])
    if params.get("f_pn_fr") is not None:
        cargs.extend([
            "-f_pn_fr",
            str(params.get("f_pn_fr"))
        ])
    if params.get("skip_col_nodes"):
        cargs.append("-skip_col_nodes")
    if params.get("skip_col_1dindex"):
        cargs.append("-skip_col_1dindex")
    if params.get("skip_col_i"):
        cargs.append("-skip_col_i")
    if params.get("skip_col_j"):
        cargs.append("-skip_col_j")
    if params.get("skip_col_k"):
        cargs.append("-skip_col_k")
    if params.get("skip_col_vals"):
        cargs.append("-skip_col_vals")
    if params.get("no_headers"):
        cargs.append("-no_headers")
    if params.get("save_seg_coords") is not None:
        cargs.extend([
            "-save_seg_coords",
            params.get("save_seg_coords")
        ])
    if params.get("cmask") is not None:
        cargs.extend([
            "-cmask",
            params.get("cmask")
        ])
    if params.get("gp_index") is not None:
        cargs.extend([
            "-gp_index",
            str(params.get("gp_index"))
        ])
    if params.get("oob_index") is not None:
        cargs.extend([
            "-oob_index",
            str(params.get("oob_index"))
        ])
    if params.get("oob_value") is not None:
        cargs.extend([
            "-oob_value",
            str(params.get("oob_value"))
        ])
    if params.get("oom_value") is not None:
        cargs.extend([
            "-oom_value",
            str(params.get("oom_value"))
        ])
    if params.get("outcols_afni_nsd"):
        cargs.append("-outcols_afni_NSD")
    if params.get("outcols_1_result"):
        cargs.append("-outcols_1_result")
    if params.get("outcols_results"):
        cargs.append("-outcols_results")
    if params.get("outcols_nsd_format"):
        cargs.append("-outcols_NSD_format")
    if params.get("help"):
        cargs.append("-help")
    if params.get("hist"):
        cargs.append("-hist")
    if params.get("version"):
        cargs.append("-version")
    if params.get("keep_norm_dir"):
        cargs.append("-keep_norm_dir")
    if params.get("reverse_norm_dir"):
        cargs.append("-reverse_norm_dir")
    return cargs


def v_3d_vol2_surf_outputs(
    params: V3dVol2SurfParameters,
    execution: Execution,
) -> V3dVol2SurfOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dVol2SurfOutputs(
        root=execution.output_file("."),
        out_1d_file=execution.output_file(params.get("out_1D")) if (params.get("out_1D") is not None) else None,
        out_niml_file=execution.output_file(params.get("out_niml")) if (params.get("out_niml") is not None) else None,
        seg_coords_file=execution.output_file(params.get("save_seg_coords")) if (params.get("save_seg_coords") is not None) else None,
    )
    return ret


def v_3d_vol2_surf_execute(
    params: V3dVol2SurfParameters,
    execution: Execution,
) -> V3dVol2SurfOutputs:
    """
    Map data from a volume domain to a surface domain.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dVol2SurfOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_vol2_surf_cargs(params, execution)
    ret = v_3d_vol2_surf_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_vol2_surf(
    spec_file: InputPathType,
    sv: InputPathType,
    grid_parent: InputPathType,
    map_func: str,
    surf_a: str,
    surf_b: str | None = None,
    out_1_d: str | None = None,
    out_niml: str | None = None,
    use_norms: bool = False,
    norm_len: float | None = None,
    first_node: float | None = None,
    last_node: float | None = None,
    debug_level: float | None = None,
    dnode: float | None = None,
    f_steps: float | None = None,
    f_index: str | None = None,
    f_p1_mm: float | None = None,
    f_pn_mm: float | None = None,
    f_p1_fr: float | None = None,
    f_pn_fr: float | None = None,
    skip_col_nodes: bool = False,
    skip_col_1dindex: bool = False,
    skip_col_i: bool = False,
    skip_col_j: bool = False,
    skip_col_k: bool = False,
    skip_col_vals: bool = False,
    no_headers: bool = False,
    save_seg_coords: str | None = None,
    cmask: str | None = None,
    gp_index: float | None = None,
    oob_index: float | None = None,
    oob_value: float | None = None,
    oom_value: float | None = None,
    outcols_afni_nsd: bool = False,
    outcols_1_result: bool = False,
    outcols_results: bool = False,
    outcols_nsd_format: bool = False,
    help_: bool = False,
    hist: bool = False,
    version: bool = False,
    keep_norm_dir: bool = False,
    reverse_norm_dir: bool = False,
    runner: Runner | None = None,
) -> V3dVol2SurfOutputs:
    """
    Map data from a volume domain to a surface domain.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        spec_file: SUMA spec file.
        sv: AFNI volume dataset mapped by the surface.
        grid_parent: AFNI volume dataset used as a grid and orientation master\
            for output.
        map_func: Filter for values along the segment.
        surf_a: Name of surface A from the spec file.
        surf_b: Name of surface B from the spec file.
        out_1_d: Specify a 1D file for the output.
        out_niml: Specify a niml file for the output.
        use_norms: Use normals for second surface.
        norm_len: Length for node normals.
        first_node: Skip all previous nodes.
        last_node: Skip all following nodes.
        debug_level: Verbose output level.
        dnode: Node for debug.
        f_steps: Number of steps along each segment (defines the number of\
            evenly spaced points along each segment).
        f_index: Whether to use all segment point values or only those\
            corresponding to unique volume voxels.
        f_p1_mm: Distance in millimeters to add to the first point of each line\
            segment.
        f_pn_mm: Distance in millimeters to add to the second point of each\
            line segment.
        f_p1_fr: Fractional distance to add to the first point of each line\
            segment.
        f_pn_fr: Fractional distance to add to the second point of each line\
            segment.
        skip_col_nodes: Do not output node column.
        skip_col_1dindex: Do not output 1dindex column.
        skip_col_i: Do not output i column.
        skip_col_j: Do not output j column.
        skip_col_k: Do not output k column.
        skip_col_vals: Do not output vals column.
        no_headers: Do not output column headers.
        save_seg_coords: Save segment coordinates to a file.
        cmask: Command for dataset mask.
        gp_index: Choose grid_parent sub-brick.
        oob_index: Specify default index for out of bounds nodes.
        oob_value: Specify default value for out of bounds nodes.
        oom_value: Specify default value for out of mask nodes.
        outcols_afni_nsd: Output nodes and one result column.
        outcols_1_result: Output only one result column.
        outcols_results: Output only all result columns.
        outcols_nsd_format: Output nodes and all results (NI_SURF_DSET format).
        help_: Show this help.
        hist: Show revision history.
        version: Show version information.
        keep_norm_dir: Keep the direction of the normals.
        reverse_norm_dir: Reverse the normal directions.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dVol2SurfOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_VOL2_SURF_METADATA)
    params = v_3d_vol2_surf_params(
        spec_file=spec_file,
        sv=sv,
        grid_parent=grid_parent,
        map_func=map_func,
        surf_a=surf_a,
        surf_b=surf_b,
        out_1_d=out_1_d,
        out_niml=out_niml,
        use_norms=use_norms,
        norm_len=norm_len,
        first_node=first_node,
        last_node=last_node,
        debug_level=debug_level,
        dnode=dnode,
        f_steps=f_steps,
        f_index=f_index,
        f_p1_mm=f_p1_mm,
        f_pn_mm=f_pn_mm,
        f_p1_fr=f_p1_fr,
        f_pn_fr=f_pn_fr,
        skip_col_nodes=skip_col_nodes,
        skip_col_1dindex=skip_col_1dindex,
        skip_col_i=skip_col_i,
        skip_col_j=skip_col_j,
        skip_col_k=skip_col_k,
        skip_col_vals=skip_col_vals,
        no_headers=no_headers,
        save_seg_coords=save_seg_coords,
        cmask=cmask,
        gp_index=gp_index,
        oob_index=oob_index,
        oob_value=oob_value,
        oom_value=oom_value,
        outcols_afni_nsd=outcols_afni_nsd,
        outcols_1_result=outcols_1_result,
        outcols_results=outcols_results,
        outcols_nsd_format=outcols_nsd_format,
        help_=help_,
        hist=hist,
        version=version,
        keep_norm_dir=keep_norm_dir,
        reverse_norm_dir=reverse_norm_dir,
    )
    return v_3d_vol2_surf_execute(params, execution)


__all__ = [
    "V3dVol2SurfOutputs",
    "V3dVol2SurfParameters",
    "V_3D_VOL2_SURF_METADATA",
    "v_3d_vol2_surf",
    "v_3d_vol2_surf_params",
]
