# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_WARP_DRIVE_METADATA = Metadata(
    id="33208eefe90260d6cab1186f27531c4689ab5559.boutiques",
    name="3dWarpDrive",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dWarpDriveParameters = typing.TypedDict('V3dWarpDriveParameters', {
    "__STYXTYPE__": typing.Literal["3dWarpDrive"],
    "dataset": InputPathType,
    "base_dataset": InputPathType,
    "prefix": str,
    "shift_only": bool,
    "shift_rotate": bool,
    "shift_rotate_scale": bool,
    "affine_general": bool,
    "bilinear_general": bool,
    "linear": bool,
    "cubic": bool,
    "NN": bool,
    "quintic": bool,
    "input_dataset": typing.NotRequired[InputPathType | None],
    "verbosity_flag": bool,
    "summary_file": typing.NotRequired[str | None],
    "max_iterations": typing.NotRequired[int | None],
    "delta": typing.NotRequired[float | None],
    "weight": typing.NotRequired[str | None],
    "convergence_thresh": typing.NotRequired[float | None],
    "twopass": bool,
    "final_mode": typing.NotRequired[str | None],
    "parfix": typing.NotRequired[list[str] | None],
    "oned_file": typing.NotRequired[InputPathType | None],
    "float_format": bool,
    "coarserot_init": bool,
    "oned_matrix_save": typing.NotRequired[InputPathType | None],
    "sdu_order": bool,
    "sud_order": bool,
    "dsu_order": bool,
    "dus_order": bool,
    "usd_order": bool,
    "uds_order": bool,
    "supper_s_matrix": bool,
    "slower_s_matrix": bool,
    "ashift": bool,
    "bshift": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dWarpDrive": v_3d_warp_drive_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dWarpDrive": v_3d_warp_drive_outputs,
    }.get(t)


class V3dWarpDriveOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_warp_drive(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_dataset: OutputPathType
    """Warped dataset output"""
    output_summary: OutputPathType | None
    """Summary of calculations"""
    oned_output_file: OutputPathType | None
    """File with warping parameters"""
    matrix_output_file: OutputPathType | None
    """File with transformation matrices"""


def v_3d_warp_drive_params(
    dataset: InputPathType,
    base_dataset: InputPathType,
    prefix: str,
    shift_only: bool = False,
    shift_rotate: bool = False,
    shift_rotate_scale: bool = False,
    affine_general: bool = False,
    bilinear_general: bool = False,
    linear: bool = False,
    cubic: bool = False,
    nn: bool = False,
    quintic: bool = False,
    input_dataset: InputPathType | None = None,
    verbosity_flag: bool = False,
    summary_file: str | None = None,
    max_iterations: int | None = None,
    delta: float | None = None,
    weight: str | None = None,
    convergence_thresh: float | None = None,
    twopass: bool = False,
    final_mode: str | None = None,
    parfix: list[str] | None = None,
    oned_file: InputPathType | None = None,
    float_format: bool = False,
    coarserot_init: bool = False,
    oned_matrix_save: InputPathType | None = None,
    sdu_order: bool = False,
    sud_order: bool = False,
    dsu_order: bool = False,
    dus_order: bool = False,
    usd_order: bool = False,
    uds_order: bool = False,
    supper_s_matrix: bool = False,
    slower_s_matrix: bool = False,
    ashift: bool = False,
    bshift: bool = False,
) -> V3dWarpDriveParameters:
    """
    Build parameters.
    
    Args:
        dataset: Input dataset.
        base_dataset: Load dataset as the base to which the input dataset will\
            be matched. This is a mandatory option.
        prefix: Sets the prefix of the output dataset. If 'NULL', no output\
            dataset is written.
        shift_only: 3 parameters (shifts).
        shift_rotate: 6 parameters (shifts + angles).
        shift_rotate_scale: 9 parameters (shifts + angles + scale factors).
        affine_general: 12 parameters (3 shifts + 3x3 matrix).
        bilinear_general: 39 parameters (3 + 3x3 + 3x3x3). Not implemented and\
            will never be.
        linear: Linear interpolation method.
        cubic: Cubic interpolation method.
        nn: Nearest neighbor interpolation method [default].
        quintic: Quintic interpolation method.
        input_dataset: Specify the input dataset anywhere in the command line\
            option list.
        verbosity_flag: Print out lots of information along the way.
        summary_file: Save summary of calculations into text file. If value is\
            '-', summary goes to stdout.
        max_iterations: Allow up to 'm' iterations for convergence.
        delta: Distance, in voxel size, used to compute image derivatives using\
            finite differences. [Default=1.0].
        weight: Set the weighting applied to each voxel proportional to the\
            brick specified here. [Default=computed by program from base].
        convergence_thresh: Set the convergence parameter to be RMS 't' voxels\
            movement between iterations. [Default=0.03].
        twopass: Do the parameter estimation in two passes, coarse-but-fast\
            first, then fine-but-slow second.
        final_mode: Set the final warp to be interpolated using 'mode'.
        parfix: Fix the n'th parameter of the warp model to the value 'v'. More\
            than one -parfix option can be used.
        oned_file: Write out the warping parameters to this file.
        float_format: Write output dataset in float format, even if input\
            dataset is short or byte.
        coarserot_init: Initialize shift+rotation parameters by a brute force\
            coarse search.
        oned_matrix_save: Save base-to-input transformation matrices in\
            specified file. If the file does not end in '.1D', the program will\
            append '.aff12.1D'.
        sdu_order: Set the order of the matrix multiplication for the affine\
            transformations (S=triangular shear, D=diagonal scaling matrix,\
            U=rotation matrix).
        sud_order: Set the order of the matrix multiplication for the affine\
            transformations (S=triangular shear, U=rotation matrix, D=diagonal\
            scaling matrix).
        dsu_order: Set the order of the matrix multiplication for the affine\
            transformations (D=diagonal scaling matrix, S=triangular shear,\
            U=rotation matrix).
        dus_order: Set the order of the matrix multiplication for the affine\
            transformations (D=diagonal scaling matrix, U=rotation matrix,\
            S=triangular shear).
        usd_order: Set the order of the matrix multiplication for the affine\
            transformations (U=rotation matrix, S=triangular shear, D=diagonal\
            scaling matrix).
        uds_order: Set the order of the matrix multiplication for the affine\
            transformations (U=rotation matrix, D=diagonal scaling matrix,\
            S=triangular shear).
        supper_s_matrix: Set the S matrix to be upper triangular.
        slower_s_matrix: Set the S matrix to be lower triangular.
        ashift: Apply the shift parameters after the matrix transformation.
        bshift: Apply the shift parameters before the matrix transformation.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dWarpDrive",
        "dataset": dataset,
        "base_dataset": base_dataset,
        "prefix": prefix,
        "shift_only": shift_only,
        "shift_rotate": shift_rotate,
        "shift_rotate_scale": shift_rotate_scale,
        "affine_general": affine_general,
        "bilinear_general": bilinear_general,
        "linear": linear,
        "cubic": cubic,
        "NN": nn,
        "quintic": quintic,
        "verbosity_flag": verbosity_flag,
        "twopass": twopass,
        "float_format": float_format,
        "coarserot_init": coarserot_init,
        "sdu_order": sdu_order,
        "sud_order": sud_order,
        "dsu_order": dsu_order,
        "dus_order": dus_order,
        "usd_order": usd_order,
        "uds_order": uds_order,
        "supper_s_matrix": supper_s_matrix,
        "slower_s_matrix": slower_s_matrix,
        "ashift": ashift,
        "bshift": bshift,
    }
    if input_dataset is not None:
        params["input_dataset"] = input_dataset
    if summary_file is not None:
        params["summary_file"] = summary_file
    if max_iterations is not None:
        params["max_iterations"] = max_iterations
    if delta is not None:
        params["delta"] = delta
    if weight is not None:
        params["weight"] = weight
    if convergence_thresh is not None:
        params["convergence_thresh"] = convergence_thresh
    if final_mode is not None:
        params["final_mode"] = final_mode
    if parfix is not None:
        params["parfix"] = parfix
    if oned_file is not None:
        params["oned_file"] = oned_file
    if oned_matrix_save is not None:
        params["oned_matrix_save"] = oned_matrix_save
    return params


def v_3d_warp_drive_cargs(
    params: V3dWarpDriveParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dWarpDrive")
    cargs.append(execution.input_file(params.get("dataset")))
    cargs.extend([
        "-base",
        execution.input_file(params.get("base_dataset"))
    ])
    cargs.extend([
        "-prefix",
        params.get("prefix")
    ])
    if params.get("shift_only"):
        cargs.append("-shift_only")
    if params.get("shift_rotate"):
        cargs.append("-shift_rotate")
    if params.get("shift_rotate_scale"):
        cargs.append("-shift_rotate_scale")
    if params.get("affine_general"):
        cargs.append("-affine_general")
    if params.get("bilinear_general"):
        cargs.append("-bilinear_general")
    if params.get("linear"):
        cargs.append("-linear")
    if params.get("cubic"):
        cargs.append("-cubic")
    if params.get("NN"):
        cargs.append("-NN")
    if params.get("quintic"):
        cargs.append("-quintic")
    if params.get("input_dataset") is not None:
        cargs.extend([
            "-input",
            execution.input_file(params.get("input_dataset"))
        ])
    if params.get("verbosity_flag"):
        cargs.append("-verb")
    if params.get("summary_file") is not None:
        cargs.extend([
            "-summ",
            params.get("summary_file")
        ])
    if params.get("max_iterations") is not None:
        cargs.extend([
            "-maxite",
            str(params.get("max_iterations"))
        ])
    if params.get("delta") is not None:
        cargs.extend([
            "-delta",
            str(params.get("delta"))
        ])
    if params.get("weight") is not None:
        cargs.extend([
            "-weight",
            params.get("weight")
        ])
    if params.get("convergence_thresh") is not None:
        cargs.extend([
            "-thresh",
            str(params.get("convergence_thresh"))
        ])
    if params.get("twopass"):
        cargs.append("-twopass")
    if params.get("final_mode") is not None:
        cargs.extend([
            "-final",
            params.get("final_mode")
        ])
    if params.get("parfix") is not None:
        cargs.extend([
            "-parfix",
            *params.get("parfix")
        ])
    if params.get("oned_file") is not None:
        cargs.extend([
            "-1Dfile",
            execution.input_file(params.get("oned_file"))
        ])
    if params.get("float_format"):
        cargs.append("-float")
    if params.get("coarserot_init"):
        cargs.append("-coarserot")
    if params.get("oned_matrix_save") is not None:
        cargs.extend([
            "-1Dmatrix_save",
            execution.input_file(params.get("oned_matrix_save"))
        ])
    if params.get("sdu_order"):
        cargs.append("-SDU")
    if params.get("sud_order"):
        cargs.append("-SUD")
    if params.get("dsu_order"):
        cargs.append("-DSU")
    if params.get("dus_order"):
        cargs.append("-DUS")
    if params.get("usd_order"):
        cargs.append("-USD")
    if params.get("uds_order"):
        cargs.append("-UDS")
    if params.get("supper_s_matrix"):
        cargs.append("-Supper")
    if params.get("slower_s_matrix"):
        cargs.append("-Slower")
    if params.get("ashift"):
        cargs.append("-ashift")
    if params.get("bshift"):
        cargs.append("-bshift")
    return cargs


def v_3d_warp_drive_outputs(
    params: V3dWarpDriveParameters,
    execution: Execution,
) -> V3dWarpDriveOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dWarpDriveOutputs(
        root=execution.output_file("."),
        output_dataset=execution.output_file(params.get("prefix") + "+orig"),
        output_summary=execution.output_file(params.get("summary_file")) if (params.get("summary_file") is not None) else None,
        oned_output_file=execution.output_file(pathlib.Path(params.get("oned_file")).name) if (params.get("oned_file") is not None) else None,
        matrix_output_file=execution.output_file(pathlib.Path(params.get("oned_matrix_save")).name) if (params.get("oned_matrix_save") is not None) else None,
    )
    return ret


def v_3d_warp_drive_execute(
    params: V3dWarpDriveParameters,
    execution: Execution,
) -> V3dWarpDriveOutputs:
    """
    Warp a dataset to match another one (the base) using an affine transformation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dWarpDriveOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_warp_drive_cargs(params, execution)
    ret = v_3d_warp_drive_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_warp_drive(
    dataset: InputPathType,
    base_dataset: InputPathType,
    prefix: str,
    shift_only: bool = False,
    shift_rotate: bool = False,
    shift_rotate_scale: bool = False,
    affine_general: bool = False,
    bilinear_general: bool = False,
    linear: bool = False,
    cubic: bool = False,
    nn: bool = False,
    quintic: bool = False,
    input_dataset: InputPathType | None = None,
    verbosity_flag: bool = False,
    summary_file: str | None = None,
    max_iterations: int | None = None,
    delta: float | None = None,
    weight: str | None = None,
    convergence_thresh: float | None = None,
    twopass: bool = False,
    final_mode: str | None = None,
    parfix: list[str] | None = None,
    oned_file: InputPathType | None = None,
    float_format: bool = False,
    coarserot_init: bool = False,
    oned_matrix_save: InputPathType | None = None,
    sdu_order: bool = False,
    sud_order: bool = False,
    dsu_order: bool = False,
    dus_order: bool = False,
    usd_order: bool = False,
    uds_order: bool = False,
    supper_s_matrix: bool = False,
    slower_s_matrix: bool = False,
    ashift: bool = False,
    bshift: bool = False,
    runner: Runner | None = None,
) -> V3dWarpDriveOutputs:
    """
    Warp a dataset to match another one (the base) using an affine transformation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input dataset.
        base_dataset: Load dataset as the base to which the input dataset will\
            be matched. This is a mandatory option.
        prefix: Sets the prefix of the output dataset. If 'NULL', no output\
            dataset is written.
        shift_only: 3 parameters (shifts).
        shift_rotate: 6 parameters (shifts + angles).
        shift_rotate_scale: 9 parameters (shifts + angles + scale factors).
        affine_general: 12 parameters (3 shifts + 3x3 matrix).
        bilinear_general: 39 parameters (3 + 3x3 + 3x3x3). Not implemented and\
            will never be.
        linear: Linear interpolation method.
        cubic: Cubic interpolation method.
        nn: Nearest neighbor interpolation method [default].
        quintic: Quintic interpolation method.
        input_dataset: Specify the input dataset anywhere in the command line\
            option list.
        verbosity_flag: Print out lots of information along the way.
        summary_file: Save summary of calculations into text file. If value is\
            '-', summary goes to stdout.
        max_iterations: Allow up to 'm' iterations for convergence.
        delta: Distance, in voxel size, used to compute image derivatives using\
            finite differences. [Default=1.0].
        weight: Set the weighting applied to each voxel proportional to the\
            brick specified here. [Default=computed by program from base].
        convergence_thresh: Set the convergence parameter to be RMS 't' voxels\
            movement between iterations. [Default=0.03].
        twopass: Do the parameter estimation in two passes, coarse-but-fast\
            first, then fine-but-slow second.
        final_mode: Set the final warp to be interpolated using 'mode'.
        parfix: Fix the n'th parameter of the warp model to the value 'v'. More\
            than one -parfix option can be used.
        oned_file: Write out the warping parameters to this file.
        float_format: Write output dataset in float format, even if input\
            dataset is short or byte.
        coarserot_init: Initialize shift+rotation parameters by a brute force\
            coarse search.
        oned_matrix_save: Save base-to-input transformation matrices in\
            specified file. If the file does not end in '.1D', the program will\
            append '.aff12.1D'.
        sdu_order: Set the order of the matrix multiplication for the affine\
            transformations (S=triangular shear, D=diagonal scaling matrix,\
            U=rotation matrix).
        sud_order: Set the order of the matrix multiplication for the affine\
            transformations (S=triangular shear, U=rotation matrix, D=diagonal\
            scaling matrix).
        dsu_order: Set the order of the matrix multiplication for the affine\
            transformations (D=diagonal scaling matrix, S=triangular shear,\
            U=rotation matrix).
        dus_order: Set the order of the matrix multiplication for the affine\
            transformations (D=diagonal scaling matrix, U=rotation matrix,\
            S=triangular shear).
        usd_order: Set the order of the matrix multiplication for the affine\
            transformations (U=rotation matrix, S=triangular shear, D=diagonal\
            scaling matrix).
        uds_order: Set the order of the matrix multiplication for the affine\
            transformations (U=rotation matrix, D=diagonal scaling matrix,\
            S=triangular shear).
        supper_s_matrix: Set the S matrix to be upper triangular.
        slower_s_matrix: Set the S matrix to be lower triangular.
        ashift: Apply the shift parameters after the matrix transformation.
        bshift: Apply the shift parameters before the matrix transformation.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dWarpDriveOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_WARP_DRIVE_METADATA)
    params = v_3d_warp_drive_params(
        dataset=dataset,
        base_dataset=base_dataset,
        prefix=prefix,
        shift_only=shift_only,
        shift_rotate=shift_rotate,
        shift_rotate_scale=shift_rotate_scale,
        affine_general=affine_general,
        bilinear_general=bilinear_general,
        linear=linear,
        cubic=cubic,
        nn=nn,
        quintic=quintic,
        input_dataset=input_dataset,
        verbosity_flag=verbosity_flag,
        summary_file=summary_file,
        max_iterations=max_iterations,
        delta=delta,
        weight=weight,
        convergence_thresh=convergence_thresh,
        twopass=twopass,
        final_mode=final_mode,
        parfix=parfix,
        oned_file=oned_file,
        float_format=float_format,
        coarserot_init=coarserot_init,
        oned_matrix_save=oned_matrix_save,
        sdu_order=sdu_order,
        sud_order=sud_order,
        dsu_order=dsu_order,
        dus_order=dus_order,
        usd_order=usd_order,
        uds_order=uds_order,
        supper_s_matrix=supper_s_matrix,
        slower_s_matrix=slower_s_matrix,
        ashift=ashift,
        bshift=bshift,
    )
    return v_3d_warp_drive_execute(params, execution)


__all__ = [
    "V3dWarpDriveOutputs",
    "V3dWarpDriveParameters",
    "V_3D_WARP_DRIVE_METADATA",
    "v_3d_warp_drive",
    "v_3d_warp_drive_params",
]
