# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_WILCOXON_METADATA = Metadata(
    id="0faf7a4a5820da0066cc57696be816f569b8025d.boutiques",
    name="3dWilcoxon",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dWilcoxonParameters = typing.TypedDict('V3dWilcoxonParameters', {
    "__STYXTYPE__": typing.Literal["3dWilcoxon"],
    "workmem": typing.NotRequired[float | None],
    "voxel": typing.NotRequired[float | None],
    "dset1_x": list[InputPathType],
    "dset2_y": list[InputPathType],
    "output_prefix": str,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dWilcoxon": v_3d_wilcoxon_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dWilcoxon": v_3d_wilcoxon_outputs,
    }.get(t)


class V3dWilcoxonOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3d_wilcoxon(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Estimated population delta and Wilcoxon signed-rank statistics"""


def v_3d_wilcoxon_params(
    dset1_x: list[InputPathType],
    dset2_y: list[InputPathType],
    output_prefix: str,
    workmem: float | None = None,
    voxel: float | None = None,
) -> V3dWilcoxonParameters:
    """
    Build parameters.
    
    Args:
        dset1_x: Data set for X observations. The user must specify 1 and only\
            1 sub-brick with each -dset command.
        dset2_y: Data set for Y observations. The user must specify 1 and only\
            1 sub-brick with each -dset command.
        output_prefix: Estimated population delta and Wilcoxon signed-rank\
            statistics are written to file.
        workmem: Number of megabytes of RAM to use for statistical workspace.
        voxel: Screen output for voxel # num.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dWilcoxon",
        "dset1_x": dset1_x,
        "dset2_y": dset2_y,
        "output_prefix": output_prefix,
    }
    if workmem is not None:
        params["workmem"] = workmem
    if voxel is not None:
        params["voxel"] = voxel
    return params


def v_3d_wilcoxon_cargs(
    params: V3dWilcoxonParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dWilcoxon")
    if params.get("workmem") is not None:
        cargs.extend([
            "-workmem",
            str(params.get("workmem"))
        ])
    if params.get("voxel") is not None:
        cargs.extend([
            "-voxel",
            str(params.get("voxel"))
        ])
    cargs.extend([
        "-dset 1",
        *[execution.input_file(f) for f in params.get("dset1_x")]
    ])
    cargs.extend([
        "-dset 2",
        *[execution.input_file(f) for f in params.get("dset2_y")]
    ])
    cargs.extend([
        "-out",
        params.get("output_prefix")
    ])
    return cargs


def v_3d_wilcoxon_outputs(
    params: V3dWilcoxonParameters,
    execution: Execution,
) -> V3dWilcoxonOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dWilcoxonOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("output_prefix")),
    )
    return ret


def v_3d_wilcoxon_execute(
    params: V3dWilcoxonParameters,
    execution: Execution,
) -> V3dWilcoxonOutputs:
    """
    Nonparametric Wilcoxon signed-rank test for paired comparisons of two samples.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dWilcoxonOutputs`).
    """
    params = execution.params(params)
    cargs = v_3d_wilcoxon_cargs(params, execution)
    ret = v_3d_wilcoxon_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_wilcoxon(
    dset1_x: list[InputPathType],
    dset2_y: list[InputPathType],
    output_prefix: str,
    workmem: float | None = None,
    voxel: float | None = None,
    runner: Runner | None = None,
) -> V3dWilcoxonOutputs:
    """
    Nonparametric Wilcoxon signed-rank test for paired comparisons of two samples.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dset1_x: Data set for X observations. The user must specify 1 and only\
            1 sub-brick with each -dset command.
        dset2_y: Data set for Y observations. The user must specify 1 and only\
            1 sub-brick with each -dset command.
        output_prefix: Estimated population delta and Wilcoxon signed-rank\
            statistics are written to file.
        workmem: Number of megabytes of RAM to use for statistical workspace.
        voxel: Screen output for voxel # num.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dWilcoxonOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_WILCOXON_METADATA)
    params = v_3d_wilcoxon_params(
        workmem=workmem,
        voxel=voxel,
        dset1_x=dset1_x,
        dset2_y=dset2_y,
        output_prefix=output_prefix,
    )
    return v_3d_wilcoxon_execute(params, execution)


__all__ = [
    "V3dWilcoxonOutputs",
    "V3dWilcoxonParameters",
    "V_3D_WILCOXON_METADATA",
    "v_3d_wilcoxon",
    "v_3d_wilcoxon_params",
]
