# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DBUCKET_METADATA = Metadata(
    id="209f280cf80f67eec54b9e248d877666d290d19c.boutiques",
    name="3dbucket",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dbucketParameters = typing.TypedDict('V3dbucketParameters', {
    "__STYXTYPE__": typing.Literal["3dbucket"],
    "prefix": typing.NotRequired[str | None],
    "output": typing.NotRequired[str | None],
    "session": typing.NotRequired[str | None],
    "glueto": typing.NotRequired[str | None],
    "aglueto": typing.NotRequired[str | None],
    "dry": bool,
    "verbose": bool,
    "fbuc": bool,
    "abuc": bool,
    "input_files": list[str],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dbucket": v_3dbucket_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class V3dbucketOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3dbucket(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3dbucket_params(
    input_files: list[str],
    prefix: str | None = None,
    output: str | None = None,
    session: str | None = None,
    glueto: str | None = None,
    aglueto: str | None = None,
    dry: bool = False,
    verbose: bool = False,
    fbuc: bool = False,
    abuc: bool = False,
) -> V3dbucketParameters:
    """
    Build parameters.
    
    Args:
        input_files: Input datasets with optional sub-brick selection.
        prefix: Use 'pname' for the output dataset prefix name.
        output: Use 'pname' for the output dataset prefix name.
        session: Use 'dir' for the output dataset session directory.\
            [default='./'=current working directory].
        glueto: Append bricks to the end of the 'fname' dataset.
        aglueto: If fname dataset does not exist, create it (like -prefix).\
            Otherwise append to fname (like -glueto).
        dry: Execute a 'dry run'; only print out what would be done.
        verbose: Print out some verbose output as the program proceeds.
        fbuc: Create a functional bucket.
        abuc: Create an anatomical bucket. If neither of these options is\
            given, the output type is determined from the first input type.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dbucket",
        "dry": dry,
        "verbose": verbose,
        "fbuc": fbuc,
        "abuc": abuc,
        "input_files": input_files,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if output is not None:
        params["output"] = output
    if session is not None:
        params["session"] = session
    if glueto is not None:
        params["glueto"] = glueto
    if aglueto is not None:
        params["aglueto"] = aglueto
    return params


def v_3dbucket_cargs(
    params: V3dbucketParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dbucket")
    if params.get("prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix")
        ])
    if params.get("output") is not None:
        cargs.extend([
            "-output",
            params.get("output")
        ])
    if params.get("session") is not None:
        cargs.extend([
            "-session",
            params.get("session")
        ])
    if params.get("glueto") is not None:
        cargs.extend([
            "-glueto",
            params.get("glueto")
        ])
    if params.get("aglueto") is not None:
        cargs.extend([
            "-aglueto",
            params.get("aglueto")
        ])
    if params.get("dry"):
        cargs.append("-dry")
    if params.get("verbose"):
        cargs.append("-verb")
    if params.get("fbuc"):
        cargs.append("-fbuc")
    if params.get("abuc"):
        cargs.append("-abuc")
    cargs.extend(params.get("input_files"))
    return cargs


def v_3dbucket_outputs(
    params: V3dbucketParameters,
    execution: Execution,
) -> V3dbucketOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dbucketOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3dbucket_execute(
    params: V3dbucketParameters,
    execution: Execution,
) -> V3dbucketOutputs:
    """
    Concatenate sub-bricks from input datasets into one big bucket dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dbucketOutputs`).
    """
    params = execution.params(params)
    cargs = v_3dbucket_cargs(params, execution)
    ret = v_3dbucket_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dbucket(
    input_files: list[str],
    prefix: str | None = None,
    output: str | None = None,
    session: str | None = None,
    glueto: str | None = None,
    aglueto: str | None = None,
    dry: bool = False,
    verbose: bool = False,
    fbuc: bool = False,
    abuc: bool = False,
    runner: Runner | None = None,
) -> V3dbucketOutputs:
    """
    Concatenate sub-bricks from input datasets into one big bucket dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input datasets with optional sub-brick selection.
        prefix: Use 'pname' for the output dataset prefix name.
        output: Use 'pname' for the output dataset prefix name.
        session: Use 'dir' for the output dataset session directory.\
            [default='./'=current working directory].
        glueto: Append bricks to the end of the 'fname' dataset.
        aglueto: If fname dataset does not exist, create it (like -prefix).\
            Otherwise append to fname (like -glueto).
        dry: Execute a 'dry run'; only print out what would be done.
        verbose: Print out some verbose output as the program proceeds.
        fbuc: Create a functional bucket.
        abuc: Create an anatomical bucket. If neither of these options is\
            given, the output type is determined from the first input type.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dbucketOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DBUCKET_METADATA)
    params = v_3dbucket_params(
        prefix=prefix,
        output=output,
        session=session,
        glueto=glueto,
        aglueto=aglueto,
        dry=dry,
        verbose=verbose,
        fbuc=fbuc,
        abuc=abuc,
        input_files=input_files,
    )
    return v_3dbucket_execute(params, execution)


__all__ = [
    "V3dbucketOutputs",
    "V3dbucketParameters",
    "V_3DBUCKET_METADATA",
    "v_3dbucket",
    "v_3dbucket_params",
]
