# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DCOPY_METADATA = Metadata(
    id="e98a1c9847dec3677d06d7e807d877bc22078336.boutiques",
    name="3dcopy",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dcopyParameters = typing.TypedDict('V3dcopyParameters', {
    "__STYXTYPE__": typing.Literal["3dcopy"],
    "verbose": bool,
    "denote": bool,
    "old_prefix": str,
    "view": typing.NotRequired[str | None],
    "new_prefix": str,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dcopy": v_3dcopy_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class V3dcopyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3dcopy(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3dcopy_params(
    old_prefix: str,
    new_prefix: str,
    verbose: bool = False,
    denote: bool = False,
    view: str | None = None,
) -> V3dcopyParameters:
    """
    Build parameters.
    
    Args:
        old_prefix: Old dataset prefix (and view if specific dataset view is to\
            be copied).
        new_prefix: New dataset prefix or directory path.
        verbose: Print progress reports.
        denote: Remove any Notes from the file.
        view: Specified view (orig, acpc, tlrc).
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dcopy",
        "verbose": verbose,
        "denote": denote,
        "old_prefix": old_prefix,
        "new_prefix": new_prefix,
    }
    if view is not None:
        params["view"] = view
    return params


def v_3dcopy_cargs(
    params: V3dcopyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dcopy")
    if params.get("verbose"):
        cargs.append("-verb")
    if params.get("denote"):
        cargs.append("-denote")
    if params.get("view") is not None:
        cargs.extend([
            "+",
            params.get("old_prefix") + params.get("view")
        ])
    cargs.append(params.get("new_prefix"))
    return cargs


def v_3dcopy_outputs(
    params: V3dcopyParameters,
    execution: Execution,
) -> V3dcopyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dcopyOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3dcopy_execute(
    params: V3dcopyParameters,
    execution: Execution,
) -> V3dcopyOutputs:
    """
    3dcopy copies datasets with or without altering prefixes and converting formats.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dcopyOutputs`).
    """
    params = execution.params(params)
    cargs = v_3dcopy_cargs(params, execution)
    ret = v_3dcopy_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dcopy(
    old_prefix: str,
    new_prefix: str,
    verbose: bool = False,
    denote: bool = False,
    view: str | None = None,
    runner: Runner | None = None,
) -> V3dcopyOutputs:
    """
    3dcopy copies datasets with or without altering prefixes and converting formats.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        old_prefix: Old dataset prefix (and view if specific dataset view is to\
            be copied).
        new_prefix: New dataset prefix or directory path.
        verbose: Print progress reports.
        denote: Remove any Notes from the file.
        view: Specified view (orig, acpc, tlrc).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dcopyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DCOPY_METADATA)
    params = v_3dcopy_params(
        verbose=verbose,
        denote=denote,
        old_prefix=old_prefix,
        view=view,
        new_prefix=new_prefix,
    )
    return v_3dcopy_execute(params, execution)


__all__ = [
    "V3dcopyOutputs",
    "V3dcopyParameters",
    "V_3DCOPY_METADATA",
    "v_3dcopy",
    "v_3dcopy_params",
]
