# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DDOT_METADATA = Metadata(
    id="4a668d35fe20645df0c5d29ea0e2920f566ca390.boutiques",
    name="3ddot",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3ddotParameters = typing.TypedDict('V3ddotParameters', {
    "__STYXTYPE__": typing.Literal["3ddot"],
    "input_datasets": list[InputPathType],
    "mask": typing.NotRequired[InputPathType | None],
    "mrange": typing.NotRequired[list[float] | None],
    "demean": bool,
    "docor": bool,
    "dodot": bool,
    "docoef": bool,
    "dosums": bool,
    "doeta2": bool,
    "dodice": bool,
    "show_labels": bool,
    "upper": bool,
    "full": bool,
    "1D": bool,
    "NIML": bool,
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3ddot": v_3ddot_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3ddot": v_3ddot_outputs,
    }.get(t)


class V3ddotOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3ddot(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    result: OutputPathType
    """Resulting coefficient or statistical values printed to stdout"""


def v_3ddot_params(
    input_datasets: list[InputPathType],
    mask: InputPathType | None = None,
    mrange: list[float] | None = None,
    demean: bool = False,
    docor: bool = False,
    dodot: bool = False,
    docoef: bool = False,
    dosums: bool = False,
    doeta2: bool = False,
    dodice: bool = False,
    show_labels: bool = False,
    upper: bool = False,
    full: bool = False,
    v_1_d: bool = False,
    niml: bool = False,
) -> V3ddotParameters:
    """
    Build parameters.
    
    Args:
        input_datasets: List of input datasets to be used (e.g. img1+orig,\
            img2+orig).
        mask: Dataset to be used as a mask; only voxels with nonzero values\
            will be averaged.
        mrange: Restrict mask values to those between a and b (inclusive) for\
            masking purposes.
        demean: Remove the mean from each volume prior to computing the\
            correlation.
        docor: Return the correlation coefficient (default).
        dodot: Return the dot product (unscaled).
        docoef: Return the least square fit coefficients {a,b}.
        dosums: Return xbar, ybar, variance, covariance, and correlation\
            coefficient.
        doeta2: Return eta-squared (Cohen, NeuroImage 2008).
        dodice: Return the Dice coefficient (the Sorensen-Dice index).
        show_labels: Print sub-brick labels to help identify what is being\
            correlated.
        upper: Compute upper triangular matrix.
        full: Compute the whole matrix.
        v_1_d: Add comment headings for the 1D format.
        niml: Write output in NIML 1D format.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3ddot",
        "input_datasets": input_datasets,
        "demean": demean,
        "docor": docor,
        "dodot": dodot,
        "docoef": docoef,
        "dosums": dosums,
        "doeta2": doeta2,
        "dodice": dodice,
        "show_labels": show_labels,
        "upper": upper,
        "full": full,
        "1D": v_1_d,
        "NIML": niml,
    }
    if mask is not None:
        params["mask"] = mask
    if mrange is not None:
        params["mrange"] = mrange
    return params


def v_3ddot_cargs(
    params: V3ddotParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3ddot")
    cargs.extend([execution.input_file(f) for f in params.get("input_datasets")])
    if params.get("mask") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask"))
        ])
    if params.get("mrange") is not None:
        cargs.extend([
            "-mrange",
            *map(str, params.get("mrange"))
        ])
    if params.get("demean"):
        cargs.append("-demean")
    if params.get("docor"):
        cargs.append("-docor")
    if params.get("dodot"):
        cargs.append("-dodot")
    if params.get("docoef"):
        cargs.append("-docoef")
    if params.get("dosums"):
        cargs.append("-dosums")
    if params.get("doeta2"):
        cargs.append("-doeta2")
    if params.get("dodice"):
        cargs.append("-dodice")
    if params.get("show_labels"):
        cargs.append("-show_labels")
    if params.get("upper"):
        cargs.append("-upper")
    if params.get("full"):
        cargs.append("-full")
    if params.get("1D"):
        cargs.append("-1D")
    if params.get("NIML"):
        cargs.append("-NIML")
    return cargs


def v_3ddot_outputs(
    params: V3ddotParameters,
    execution: Execution,
) -> V3ddotOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3ddotOutputs(
        root=execution.output_file("."),
        result=execution.output_file("stdout"),
    )
    return ret


def v_3ddot_execute(
    params: V3ddotParameters,
    execution: Execution,
) -> V3ddotOutputs:
    """
    Computes correlation coefficients between sub-brick pairs.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3ddotOutputs`).
    """
    params = execution.params(params)
    cargs = v_3ddot_cargs(params, execution)
    ret = v_3ddot_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3ddot(
    input_datasets: list[InputPathType],
    mask: InputPathType | None = None,
    mrange: list[float] | None = None,
    demean: bool = False,
    docor: bool = False,
    dodot: bool = False,
    docoef: bool = False,
    dosums: bool = False,
    doeta2: bool = False,
    dodice: bool = False,
    show_labels: bool = False,
    upper: bool = False,
    full: bool = False,
    v_1_d: bool = False,
    niml: bool = False,
    runner: Runner | None = None,
) -> V3ddotOutputs:
    """
    Computes correlation coefficients between sub-brick pairs.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_datasets: List of input datasets to be used (e.g. img1+orig,\
            img2+orig).
        mask: Dataset to be used as a mask; only voxels with nonzero values\
            will be averaged.
        mrange: Restrict mask values to those between a and b (inclusive) for\
            masking purposes.
        demean: Remove the mean from each volume prior to computing the\
            correlation.
        docor: Return the correlation coefficient (default).
        dodot: Return the dot product (unscaled).
        docoef: Return the least square fit coefficients {a,b}.
        dosums: Return xbar, ybar, variance, covariance, and correlation\
            coefficient.
        doeta2: Return eta-squared (Cohen, NeuroImage 2008).
        dodice: Return the Dice coefficient (the Sorensen-Dice index).
        show_labels: Print sub-brick labels to help identify what is being\
            correlated.
        upper: Compute upper triangular matrix.
        full: Compute the whole matrix.
        v_1_d: Add comment headings for the 1D format.
        niml: Write output in NIML 1D format.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3ddotOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DDOT_METADATA)
    params = v_3ddot_params(
        input_datasets=input_datasets,
        mask=mask,
        mrange=mrange,
        demean=demean,
        docor=docor,
        dodot=dodot,
        docoef=docoef,
        dosums=dosums,
        doeta2=doeta2,
        dodice=dodice,
        show_labels=show_labels,
        upper=upper,
        full=full,
        v_1_d=v_1_d,
        niml=niml,
    )
    return v_3ddot_execute(params, execution)


__all__ = [
    "V3ddotOutputs",
    "V3ddotParameters",
    "V_3DDOT_METADATA",
    "v_3ddot",
    "v_3ddot_params",
]
