# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DFIM__METADATA = Metadata(
    id="fc1b029ae0a8def8888aac6bc72283bb5b04bcf9.boutiques",
    name="3dfim+",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dfimParameters = typing.TypedDict('V3dfimParameters', {
    "__STYXTYPE__": typing.Literal["3dfim+"],
    "infile": InputPathType,
    "input1dfile": typing.NotRequired[InputPathType | None],
    "maskfile": typing.NotRequired[InputPathType | None],
    "first_image": typing.NotRequired[float | None],
    "last_image": typing.NotRequired[float | None],
    "baseline_polynomial": typing.NotRequired[float | None],
    "threshold": typing.NotRequired[float | None],
    "cdisp_value": typing.NotRequired[float | None],
    "ort_file": typing.NotRequired[InputPathType | None],
    "ideal_file": InputPathType,
    "output_params": typing.NotRequired[list[str] | None],
    "output_bucket": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dfim+": v_3dfim__cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dfim+": v_3dfim__outputs,
    }.get(t)


class V3dfimOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3dfim_(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    outfile_tlrc_head: OutputPathType | None
    """Output bucket dataset containing fit parameters, in TLRC space."""
    outfile_tlrc_brk: OutputPathType | None
    """Output bucket dataset containing fit parameters, in TLRC space."""
    outfile_orig_head: OutputPathType | None
    """Output bucket dataset containing fit parameters, in original space."""
    outfile_orig_brk: OutputPathType | None
    """Output bucket dataset containing fit parameters, in original space."""


def v_3dfim__params(
    infile: InputPathType,
    ideal_file: InputPathType,
    input1dfile: InputPathType | None = None,
    maskfile: InputPathType | None = None,
    first_image: float | None = None,
    last_image: float | None = None,
    baseline_polynomial: float | None = None,
    threshold: float | None = None,
    cdisp_value: float | None = None,
    ort_file: InputPathType | None = None,
    output_params: list[str] | None = None,
    output_bucket: str | None = None,
) -> V3dfimParameters:
    """
    Build parameters.
    
    Args:
        infile: Filename of input 3d+time dataset.
        ideal_file: Input ideal time series file name. Can be used multiple\
            times.
        input1dfile: Filename of single (fMRI) .1D time series.
        maskfile: Filename of 3d mask dataset.
        first_image: Number of first dataset image to use in the\
            cross-correlation procedure (default = 0).
        last_image: Number of last dataset image to use in the\
            cross-correlation procedure (default = last).
        baseline_polynomial: Degree of polynomial corresponding to the baseline\
            model (default: 1). Use -1 for no baseline model.
        threshold: FIM internal mask threshold value (0 <= p <= 1) to get rid\
            of low intensity voxels (default: 0.0999).
        cdisp_value: Write (to screen) results for voxels whose correlation\
            stat. > cval (0 <= cval <= 1; default: disabled).
        ort_file: Input ort time series file name. Can be used multiple times.
        output_params: Output the specified parameter. Can be used multiple\
            times. Possible values are: 'Fit Coef', 'Best Index', '% Change',\
            'Baseline', 'Correlation', '% From Ave', 'Average', '% From Top',\
            'Topline', 'Sigma Resid', 'All', 'Spearman CC', 'Quadrant CC'.
        output_bucket: Create one AFNI 'bucket' dataset containing the\
            parameters of interest, as specified by the '-out' commands. The output\
            'bucket' dataset is written to a file with the prefix name bprefix.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dfim+",
        "infile": infile,
        "ideal_file": ideal_file,
    }
    if input1dfile is not None:
        params["input1dfile"] = input1dfile
    if maskfile is not None:
        params["maskfile"] = maskfile
    if first_image is not None:
        params["first_image"] = first_image
    if last_image is not None:
        params["last_image"] = last_image
    if baseline_polynomial is not None:
        params["baseline_polynomial"] = baseline_polynomial
    if threshold is not None:
        params["threshold"] = threshold
    if cdisp_value is not None:
        params["cdisp_value"] = cdisp_value
    if ort_file is not None:
        params["ort_file"] = ort_file
    if output_params is not None:
        params["output_params"] = output_params
    if output_bucket is not None:
        params["output_bucket"] = output_bucket
    return params


def v_3dfim__cargs(
    params: V3dfimParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dfim+")
    cargs.append(execution.input_file(params.get("infile")))
    if params.get("input1dfile") is not None:
        cargs.extend([
            "-input1D",
            execution.input_file(params.get("input1dfile"))
        ])
    if params.get("maskfile") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("maskfile"))
        ])
    if params.get("first_image") is not None:
        cargs.extend([
            "-nfirst",
            str(params.get("first_image"))
        ])
    if params.get("last_image") is not None:
        cargs.extend([
            "-nlast",
            str(params.get("last_image"))
        ])
    if params.get("baseline_polynomial") is not None:
        cargs.extend([
            "-polort",
            str(params.get("baseline_polynomial"))
        ])
    if params.get("threshold") is not None:
        cargs.extend([
            "-fim_thr",
            str(params.get("threshold"))
        ])
    if params.get("cdisp_value") is not None:
        cargs.extend([
            "-cdisp",
            str(params.get("cdisp_value"))
        ])
    if params.get("ort_file") is not None:
        cargs.extend([
            "-ort_file",
            execution.input_file(params.get("ort_file"))
        ])
    cargs.extend([
        "-ideal_file",
        execution.input_file(params.get("ideal_file"))
    ])
    if params.get("output_params") is not None:
        cargs.extend([
            "-out",
            *params.get("output_params")
        ])
    if params.get("output_bucket") is not None:
        cargs.extend([
            "-bucket",
            params.get("output_bucket")
        ])
    return cargs


def v_3dfim__outputs(
    params: V3dfimParameters,
    execution: Execution,
) -> V3dfimOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dfimOutputs(
        root=execution.output_file("."),
        outfile_tlrc_head=execution.output_file(params.get("output_bucket") + "+tlrc.HEAD") if (params.get("output_bucket") is not None) else None,
        outfile_tlrc_brk=execution.output_file(params.get("output_bucket") + "+tlrc.BRIK") if (params.get("output_bucket") is not None) else None,
        outfile_orig_head=execution.output_file(params.get("output_bucket") + "+orig.HEAD") if (params.get("output_bucket") is not None) else None,
        outfile_orig_brk=execution.output_file(params.get("output_bucket") + "+orig.BRIK") if (params.get("output_bucket") is not None) else None,
    )
    return ret


def v_3dfim__execute(
    params: V3dfimParameters,
    execution: Execution,
) -> V3dfimOutputs:
    """
    Program to calculate the cross-correlation of an ideal reference waveform with
    the measured FMRI time series for each voxel.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dfimOutputs`).
    """
    params = execution.params(params)
    cargs = v_3dfim__cargs(params, execution)
    ret = v_3dfim__outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dfim_(
    infile: InputPathType,
    ideal_file: InputPathType,
    input1dfile: InputPathType | None = None,
    maskfile: InputPathType | None = None,
    first_image: float | None = None,
    last_image: float | None = None,
    baseline_polynomial: float | None = None,
    threshold: float | None = None,
    cdisp_value: float | None = None,
    ort_file: InputPathType | None = None,
    output_params: list[str] | None = None,
    output_bucket: str | None = None,
    runner: Runner | None = None,
) -> V3dfimOutputs:
    """
    Program to calculate the cross-correlation of an ideal reference waveform with
    the measured FMRI time series for each voxel.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Filename of input 3d+time dataset.
        ideal_file: Input ideal time series file name. Can be used multiple\
            times.
        input1dfile: Filename of single (fMRI) .1D time series.
        maskfile: Filename of 3d mask dataset.
        first_image: Number of first dataset image to use in the\
            cross-correlation procedure (default = 0).
        last_image: Number of last dataset image to use in the\
            cross-correlation procedure (default = last).
        baseline_polynomial: Degree of polynomial corresponding to the baseline\
            model (default: 1). Use -1 for no baseline model.
        threshold: FIM internal mask threshold value (0 <= p <= 1) to get rid\
            of low intensity voxels (default: 0.0999).
        cdisp_value: Write (to screen) results for voxels whose correlation\
            stat. > cval (0 <= cval <= 1; default: disabled).
        ort_file: Input ort time series file name. Can be used multiple times.
        output_params: Output the specified parameter. Can be used multiple\
            times. Possible values are: 'Fit Coef', 'Best Index', '% Change',\
            'Baseline', 'Correlation', '% From Ave', 'Average', '% From Top',\
            'Topline', 'Sigma Resid', 'All', 'Spearman CC', 'Quadrant CC'.
        output_bucket: Create one AFNI 'bucket' dataset containing the\
            parameters of interest, as specified by the '-out' commands. The output\
            'bucket' dataset is written to a file with the prefix name bprefix.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dfimOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DFIM__METADATA)
    params = v_3dfim__params(
        infile=infile,
        input1dfile=input1dfile,
        maskfile=maskfile,
        first_image=first_image,
        last_image=last_image,
        baseline_polynomial=baseline_polynomial,
        threshold=threshold,
        cdisp_value=cdisp_value,
        ort_file=ort_file,
        ideal_file=ideal_file,
        output_params=output_params,
        output_bucket=output_bucket,
    )
    return v_3dfim__execute(params, execution)


__all__ = [
    "V3dfimOutputs",
    "V3dfimParameters",
    "V_3DFIM__METADATA",
    "v_3dfim_",
    "v_3dfim__params",
]
