# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DHISTOG_METADATA = Metadata(
    id="992d25c6f72b404f788d8f27f20442680bbe9bdd.boutiques",
    name="3dhistog",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dhistogParameters = typing.TypedDict('V3dhistogParameters', {
    "__STYXTYPE__": typing.Literal["3dhistog"],
    "dataset": InputPathType,
    "nbin": typing.NotRequired[float | None],
    "dind": typing.NotRequired[float | None],
    "omit": typing.NotRequired[list[float] | None],
    "mask": typing.NotRequired[InputPathType | None],
    "roi_mask": typing.NotRequired[InputPathType | None],
    "doall": bool,
    "noempty": bool,
    "notitle": bool,
    "log10": bool,
    "pdf": bool,
    "min": typing.NotRequired[float | None],
    "max": typing.NotRequired[float | None],
    "igfac": bool,
    "int": bool,
    "float": bool,
    "unq": typing.NotRequired[str | None],
    "prefix": typing.NotRequired[str | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dhistog": v_3dhistog_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dhistog": v_3dhistog_outputs,
    }.get(t)


class V3dhistogOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3dhistog(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    histogram_output: OutputPathType
    """Histogram output when -prefix option is used"""


def v_3dhistog_params(
    dataset: InputPathType,
    nbin: float | None = None,
    dind: float | None = None,
    omit: list[float] | None = None,
    mask: InputPathType | None = None,
    roi_mask: InputPathType | None = None,
    doall: bool = False,
    noempty: bool = False,
    notitle: bool = False,
    log10: bool = False,
    pdf: bool = False,
    min_: float | None = None,
    max_: float | None = None,
    igfac: bool = False,
    int_: bool = False,
    float_: bool = False,
    unq: str | None = None,
    prefix: str | None = None,
) -> V3dhistogParameters:
    """
    Build parameters.
    
    Args:
        dataset: Input dataset.
        nbin: Use specified number of bins.
        dind: Use data from specified sub-brick index.
        omit: Omit specified value from the count.
        mask: Use mask dataset to determine which voxels to use.
        roi_mask: Create histogram for each non-zero value in 'r' dataset.
        doall: Include all sub-bricks in the calculation.
        noempty: Only output bins that are not empty.
        notitle: Leave the title line off the output.
        log10: Output log10() of the counts.
        pdf: Output the counts divided by the number of samples.
        min_: Specify minimum (inclusive) of histogram.
        max_: Specify maximum (inclusive) of histogram.
        igfac: Ignore sub-brick scale factors and histogram-ize the 'raw' data.
        int_: Treat data and output as integers.
        float_: Treat data and output as floats.
        unq: Writes out the sorted unique values to file.
        prefix: Write a copy of the histogram into specified file.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dhistog",
        "dataset": dataset,
        "doall": doall,
        "noempty": noempty,
        "notitle": notitle,
        "log10": log10,
        "pdf": pdf,
        "igfac": igfac,
        "int": int_,
        "float": float_,
    }
    if nbin is not None:
        params["nbin"] = nbin
    if dind is not None:
        params["dind"] = dind
    if omit is not None:
        params["omit"] = omit
    if mask is not None:
        params["mask"] = mask
    if roi_mask is not None:
        params["roi_mask"] = roi_mask
    if min_ is not None:
        params["min"] = min_
    if max_ is not None:
        params["max"] = max_
    if unq is not None:
        params["unq"] = unq
    if prefix is not None:
        params["prefix"] = prefix
    return params


def v_3dhistog_cargs(
    params: V3dhistogParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dhistog")
    cargs.append(execution.input_file(params.get("dataset")))
    if params.get("nbin") is not None:
        cargs.extend([
            "-nbin",
            str(params.get("nbin"))
        ])
    if params.get("dind") is not None:
        cargs.extend([
            "-dind",
            str(params.get("dind"))
        ])
    if params.get("omit") is not None:
        cargs.extend([
            "-omit",
            *map(str, params.get("omit"))
        ])
    if params.get("mask") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask"))
        ])
    if params.get("roi_mask") is not None:
        cargs.extend([
            "-roi_mask",
            execution.input_file(params.get("roi_mask"))
        ])
    if params.get("doall"):
        cargs.append("-doall")
    if params.get("noempty"):
        cargs.append("-noempty")
    if params.get("notitle"):
        cargs.append("-notitle")
    if params.get("log10"):
        cargs.append("-log10")
    if params.get("pdf"):
        cargs.append("-pdf")
    if params.get("min") is not None:
        cargs.extend([
            "-min",
            str(params.get("min"))
        ])
    if params.get("max") is not None:
        cargs.extend([
            "-max",
            str(params.get("max"))
        ])
    if params.get("igfac"):
        cargs.append("-igfac")
    if params.get("int"):
        cargs.append("-int")
    if params.get("float"):
        cargs.append("-float")
    if params.get("unq") is not None:
        cargs.extend([
            "-unq",
            params.get("unq")
        ])
    if params.get("prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix")
        ])
    return cargs


def v_3dhistog_outputs(
    params: V3dhistogParameters,
    execution: Execution,
) -> V3dhistogOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dhistogOutputs(
        root=execution.output_file("."),
        histogram_output=execution.output_file("HOUT.1D"),
    )
    return ret


def v_3dhistog_execute(
    params: V3dhistogParameters,
    execution: Execution,
) -> V3dhistogOutputs:
    """
    Compute histogram of a 3D dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dhistogOutputs`).
    """
    params = execution.params(params)
    cargs = v_3dhistog_cargs(params, execution)
    ret = v_3dhistog_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dhistog(
    dataset: InputPathType,
    nbin: float | None = None,
    dind: float | None = None,
    omit: list[float] | None = None,
    mask: InputPathType | None = None,
    roi_mask: InputPathType | None = None,
    doall: bool = False,
    noempty: bool = False,
    notitle: bool = False,
    log10: bool = False,
    pdf: bool = False,
    min_: float | None = None,
    max_: float | None = None,
    igfac: bool = False,
    int_: bool = False,
    float_: bool = False,
    unq: str | None = None,
    prefix: str | None = None,
    runner: Runner | None = None,
) -> V3dhistogOutputs:
    """
    Compute histogram of a 3D dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input dataset.
        nbin: Use specified number of bins.
        dind: Use data from specified sub-brick index.
        omit: Omit specified value from the count.
        mask: Use mask dataset to determine which voxels to use.
        roi_mask: Create histogram for each non-zero value in 'r' dataset.
        doall: Include all sub-bricks in the calculation.
        noempty: Only output bins that are not empty.
        notitle: Leave the title line off the output.
        log10: Output log10() of the counts.
        pdf: Output the counts divided by the number of samples.
        min_: Specify minimum (inclusive) of histogram.
        max_: Specify maximum (inclusive) of histogram.
        igfac: Ignore sub-brick scale factors and histogram-ize the 'raw' data.
        int_: Treat data and output as integers.
        float_: Treat data and output as floats.
        unq: Writes out the sorted unique values to file.
        prefix: Write a copy of the histogram into specified file.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dhistogOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DHISTOG_METADATA)
    params = v_3dhistog_params(
        dataset=dataset,
        nbin=nbin,
        dind=dind,
        omit=omit,
        mask=mask,
        roi_mask=roi_mask,
        doall=doall,
        noempty=noempty,
        notitle=notitle,
        log10=log10,
        pdf=pdf,
        min_=min_,
        max_=max_,
        igfac=igfac,
        int_=int_,
        float_=float_,
        unq=unq,
        prefix=prefix,
    )
    return v_3dhistog_execute(params, execution)


__all__ = [
    "V3dhistogOutputs",
    "V3dhistogParameters",
    "V_3DHISTOG_METADATA",
    "v_3dhistog",
    "v_3dhistog_params",
]
