# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DPC_METADATA = Metadata(
    id="aa84aba2b62d9b7a4e468237b32c0eb69d2496f8.boutiques",
    name="3dpc",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dpcParameters = typing.TypedDict('V3dpcParameters', {
    "__STYXTYPE__": typing.Literal["3dpc"],
    "datasets": list[InputPathType],
    "dmean": bool,
    "vmean": bool,
    "vnorm": bool,
    "normalize": bool,
    "nscale": bool,
    "pcsave": typing.NotRequired[str | None],
    "reduce": typing.NotRequired[list[str] | None],
    "prefix": typing.NotRequired[str | None],
    "dummy_lines": typing.NotRequired[int | None],
    "verbose": bool,
    "quiet": bool,
    "eigonly": bool,
    "float": bool,
    "mask": typing.NotRequired[InputPathType | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "3dpc": v_3dpc_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "3dpc": v_3dpc_outputs,
    }.get(t)


class V3dpcOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v_3dpc(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_dataset: OutputPathType | None
    """Output dataset file"""
    output_header: OutputPathType | None
    """Output dataset header file"""
    output_eig: OutputPathType | None
    """File with computed eigenvalues"""
    output_vec: OutputPathType | None
    """File with all eigen-timeseries"""
    output_individual_vec: OutputPathType | None
    """File with individual eigenvalue timeseries"""


def v_3dpc_params(
    datasets: list[InputPathType],
    dmean: bool = False,
    vmean: bool = False,
    vnorm: bool = False,
    normalize: bool = False,
    nscale: bool = False,
    pcsave: str | None = None,
    reduce: list[str] | None = None,
    prefix: str | None = None,
    dummy_lines: int | None = None,
    verbose: bool = False,
    quiet: bool = False,
    eigonly: bool = False,
    float_: bool = False,
    mask: InputPathType | None = None,
) -> V3dpcParameters:
    """
    Build parameters.
    
    Args:
        datasets: Input dataset(s) with sub-brick selector list support.
        dmean: Remove the mean from each input brick (across space).
        vmean: Remove the mean from each input voxel (across bricks).
        vnorm: L2 normalize each input voxel time series.
        normalize: L2 normalize each input brick (after mean subtraction).
        nscale: Scale the covariance matrix by the number of samples.
        pcsave: 'sss' is the number of components to save in the output.
        reduce: Compute a dimensionally reduced dataset with top 'r'\
            eigenvalues and write to disk in dataset 'pp'.
        prefix: Name for the output dataset.
        dummy_lines: Add 'ddd' dummy lines to the top of each *.1D file.
        verbose: Print progress reports during the computations.
        quiet: Don't print progress reports.
        eigonly: Only compute eigenvalues, write them to 'pname'_eig.1D, then\
            stop.
        float_: Save eigen-bricks as floats (default = shorts).
        mask: Use the 0 sub-brick of dataset 'mset' as a mask indicating which\
            voxels to analyze.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "3dpc",
        "datasets": datasets,
        "dmean": dmean,
        "vmean": vmean,
        "vnorm": vnorm,
        "normalize": normalize,
        "nscale": nscale,
        "verbose": verbose,
        "quiet": quiet,
        "eigonly": eigonly,
        "float": float_,
    }
    if pcsave is not None:
        params["pcsave"] = pcsave
    if reduce is not None:
        params["reduce"] = reduce
    if prefix is not None:
        params["prefix"] = prefix
    if dummy_lines is not None:
        params["dummy_lines"] = dummy_lines
    if mask is not None:
        params["mask"] = mask
    return params


def v_3dpc_cargs(
    params: V3dpcParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dpc")
    cargs.extend([execution.input_file(f) for f in params.get("datasets")])
    if params.get("dmean"):
        cargs.append("-dmean")
    if params.get("vmean"):
        cargs.append("-vmean")
    if params.get("vnorm"):
        cargs.append("-vnorm")
    if params.get("normalize"):
        cargs.append("-normalize")
    if params.get("nscale"):
        cargs.append("-nscale")
    if params.get("pcsave") is not None:
        cargs.extend([
            "-pcsave",
            params.get("pcsave")
        ])
    if params.get("reduce") is not None:
        cargs.extend([
            "-reduce",
            *params.get("reduce")
        ])
    if params.get("prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix")
        ])
    if params.get("dummy_lines") is not None:
        cargs.extend([
            "-1ddum",
            str(params.get("dummy_lines"))
        ])
    if params.get("verbose"):
        cargs.append("-verbose")
    if params.get("quiet"):
        cargs.append("-quiet")
    if params.get("eigonly"):
        cargs.append("-eigonly")
    if params.get("float"):
        cargs.append("-float")
    if params.get("mask") is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask"))
        ])
    return cargs


def v_3dpc_outputs(
    params: V3dpcParameters,
    execution: Execution,
) -> V3dpcOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dpcOutputs(
        root=execution.output_file("."),
        output_dataset=execution.output_file(params.get("prefix") + "+orig.BRIK") if (params.get("prefix") is not None) else None,
        output_header=execution.output_file(params.get("prefix") + "+orig.HEAD") if (params.get("prefix") is not None) else None,
        output_eig=execution.output_file(params.get("prefix") + "_eig.1D") if (params.get("prefix") is not None) else None,
        output_vec=execution.output_file(params.get("prefix") + "_vec.1D") if (params.get("prefix") is not None) else None,
        output_individual_vec=execution.output_file(params.get("prefix") + "[NN].1D") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3dpc_execute(
    params: V3dpcParameters,
    execution: Execution,
) -> V3dpcOutputs:
    """
    Principal Component Analysis of 3D Datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V3dpcOutputs`).
    """
    params = execution.params(params)
    cargs = v_3dpc_cargs(params, execution)
    ret = v_3dpc_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dpc(
    datasets: list[InputPathType],
    dmean: bool = False,
    vmean: bool = False,
    vnorm: bool = False,
    normalize: bool = False,
    nscale: bool = False,
    pcsave: str | None = None,
    reduce: list[str] | None = None,
    prefix: str | None = None,
    dummy_lines: int | None = None,
    verbose: bool = False,
    quiet: bool = False,
    eigonly: bool = False,
    float_: bool = False,
    mask: InputPathType | None = None,
    runner: Runner | None = None,
) -> V3dpcOutputs:
    """
    Principal Component Analysis of 3D Datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        datasets: Input dataset(s) with sub-brick selector list support.
        dmean: Remove the mean from each input brick (across space).
        vmean: Remove the mean from each input voxel (across bricks).
        vnorm: L2 normalize each input voxel time series.
        normalize: L2 normalize each input brick (after mean subtraction).
        nscale: Scale the covariance matrix by the number of samples.
        pcsave: 'sss' is the number of components to save in the output.
        reduce: Compute a dimensionally reduced dataset with top 'r'\
            eigenvalues and write to disk in dataset 'pp'.
        prefix: Name for the output dataset.
        dummy_lines: Add 'ddd' dummy lines to the top of each *.1D file.
        verbose: Print progress reports during the computations.
        quiet: Don't print progress reports.
        eigonly: Only compute eigenvalues, write them to 'pname'_eig.1D, then\
            stop.
        float_: Save eigen-bricks as floats (default = shorts).
        mask: Use the 0 sub-brick of dataset 'mset' as a mask indicating which\
            voxels to analyze.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dpcOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DPC_METADATA)
    params = v_3dpc_params(
        datasets=datasets,
        dmean=dmean,
        vmean=vmean,
        vnorm=vnorm,
        normalize=normalize,
        nscale=nscale,
        pcsave=pcsave,
        reduce=reduce,
        prefix=prefix,
        dummy_lines=dummy_lines,
        verbose=verbose,
        quiet=quiet,
        eigonly=eigonly,
        float_=float_,
        mask=mask,
    )
    return v_3dpc_execute(params, execution)


__all__ = [
    "V3dpcOutputs",
    "V3dpcParameters",
    "V_3DPC_METADATA",
    "v_3dpc",
    "v_3dpc_params",
]
