# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__4_DAVERAGE_METADATA = Metadata(
    id="48ae0996463928a201144da1e797f6f4415ed5c4.boutiques",
    name="@4Daverage",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V4DaverageParameters = typing.TypedDict('V4DaverageParameters', {
    "__STYXTYPE__": typing.Literal["@4Daverage"],
    "output_prefix": str,
    "input_files": list[InputPathType],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@4Daverage": v__4_daverage_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
    }.get(t)


class V4DaverageOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__4_daverage(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__4_daverage_params(
    output_prefix: str,
    input_files: list[InputPathType],
) -> V4DaverageParameters:
    """
    Build parameters.
    
    Args:
        output_prefix: Prefix for the output 3D+t brick.
        input_files: List of 3D+t brick filenames to be averaged (e.g.,\
            brick1+orig, brick2+orig). Can use wildcards.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@4Daverage",
        "output_prefix": output_prefix,
        "input_files": input_files,
    }
    return params


def v__4_daverage_cargs(
    params: V4DaverageParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@4Daverage")
    cargs.append(params.get("output_prefix"))
    cargs.extend([execution.input_file(f) for f in params.get("input_files")])
    return cargs


def v__4_daverage_outputs(
    params: V4DaverageParameters,
    execution: Execution,
) -> V4DaverageOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V4DaverageOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__4_daverage_execute(
    params: V4DaverageParameters,
    execution: Execution,
) -> V4DaverageOutputs:
    """
    Script for computing average 3D+time bricks using 3Dcalc.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `V4DaverageOutputs`).
    """
    params = execution.params(params)
    cargs = v__4_daverage_cargs(params, execution)
    ret = v__4_daverage_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__4_daverage(
    output_prefix: str,
    input_files: list[InputPathType],
    runner: Runner | None = None,
) -> V4DaverageOutputs:
    """
    Script for computing average 3D+time bricks using 3Dcalc.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        output_prefix: Prefix for the output 3D+t brick.
        input_files: List of 3D+t brick filenames to be averaged (e.g.,\
            brick1+orig, brick2+orig). Can use wildcards.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V4DaverageOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__4_DAVERAGE_METADATA)
    params = v__4_daverage_params(
        output_prefix=output_prefix,
        input_files=input_files,
    )
    return v__4_daverage_execute(params, execution)


__all__ = [
    "V4DaverageOutputs",
    "V4DaverageParameters",
    "V__4_DAVERAGE_METADATA",
    "v__4_daverage",
    "v__4_daverage_params",
]
