# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__ALIGN_CENTERS_METADATA = Metadata(
    id="33d48e001912a44e2935434b56014a343a7f22f0.boutiques",
    name="@Align_Centers",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VAlignCentersParameters = typing.TypedDict('VAlignCentersParameters', {
    "__STYXTYPE__": typing.Literal["@Align_Centers"],
    "base": InputPathType,
    "dset": InputPathType,
    "children": typing.NotRequired[list[InputPathType] | None],
    "echo": bool,
    "overwrite": bool,
    "prefix": typing.NotRequired[str | None],
    "matrix_only": bool,
    "matrix_only_no_dset": bool,
    "no_cp": bool,
    "center_grid": bool,
    "center_cm": bool,
    "center_cm_no_amask": bool,
    "shift_xform": typing.NotRequired[InputPathType | None],
    "shift_xform_inv": typing.NotRequired[InputPathType | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@Align_Centers": v__align_centers_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@Align_Centers": v__align_centers_outputs,
    }.get(t)


class VAlignCentersOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__align_centers(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    transform_matrix: OutputPathType
    """Transform matrix needed for the shift applied to DSET."""
    shifted_dset: OutputPathType | None
    """Shifted Dataset aligned with the base volume."""
    shifted_child_dsets: OutputPathType | None
    """Shifted child datasets aligned with the base volume."""


def v__align_centers_params(
    base: InputPathType,
    dset: InputPathType,
    children: list[InputPathType] | None = None,
    echo: bool = False,
    overwrite: bool = False,
    prefix: str | None = None,
    matrix_only: bool = False,
    matrix_only_no_dset: bool = False,
    no_cp: bool = False,
    center_grid: bool = False,
    center_cm: bool = False,
    center_cm_no_amask: bool = False,
    shift_xform: InputPathType | None = None,
    shift_xform_inv: InputPathType | None = None,
) -> VAlignCentersParameters:
    """
    Build parameters.
    
    Args:
        base: Base volume, typically a template. Can also specify RAI\
            coordinates for center alignment.
        dset: Dataset to be aligned to BASE.
        children: Additional datasets (originally in register with DSET) that\
            should be shifted in the same way.
        echo: Echo all commands to terminal for debugging.
        overwrite: Overwrite existing output files.
        prefix: Custom prefix for the result files.
        matrix_only: Only output the transform needed to align the centers\
            without shifting any child volumes.
        matrix_only_no_dset: Like -1Dmat_only, but no datasets are created or\
            changed.
        no_cp: Do not create new data; shift existing ones. Use with caution.
        center_grid: Center is that of the volume's grid (default).
        center_cm: Center is the center of mass of the volume.
        center_cm_no_amask: Like -cm, but with no automask.
        shift_xform: Apply shift translation from a 1D file.
        shift_xform_inv: Apply inverse of shift translation from a 1D file.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@Align_Centers",
        "base": base,
        "dset": dset,
        "echo": echo,
        "overwrite": overwrite,
        "matrix_only": matrix_only,
        "matrix_only_no_dset": matrix_only_no_dset,
        "no_cp": no_cp,
        "center_grid": center_grid,
        "center_cm": center_cm,
        "center_cm_no_amask": center_cm_no_amask,
    }
    if children is not None:
        params["children"] = children
    if prefix is not None:
        params["prefix"] = prefix
    if shift_xform is not None:
        params["shift_xform"] = shift_xform
    if shift_xform_inv is not None:
        params["shift_xform_inv"] = shift_xform_inv
    return params


def v__align_centers_cargs(
    params: VAlignCentersParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@Align_Centers")
    cargs.append(execution.input_file(params.get("base")))
    cargs.append(execution.input_file(params.get("dset")))
    if params.get("children") is not None:
        cargs.extend([
            "-child",
            *[execution.input_file(f) for f in params.get("children")]
        ])
    if params.get("echo"):
        cargs.append("-echo")
    if params.get("overwrite"):
        cargs.append("-overwrite")
    if params.get("prefix") is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix")
        ])
    if params.get("matrix_only"):
        cargs.append("-1Dmat_only")
    if params.get("matrix_only_no_dset"):
        cargs.append("-1Dmat_only_nodset")
    if params.get("no_cp"):
        cargs.append("-no_cp")
    if params.get("center_grid"):
        cargs.append("-grid")
    if params.get("center_cm"):
        cargs.append("-cm")
    if params.get("center_cm_no_amask"):
        cargs.append("-cm_no_amask")
    if params.get("shift_xform") is not None:
        cargs.extend([
            "-shift_xform",
            execution.input_file(params.get("shift_xform"))
        ])
    if params.get("shift_xform_inv") is not None:
        cargs.extend([
            "-shift_xform_inv",
            execution.input_file(params.get("shift_xform_inv"))
        ])
    return cargs


def v__align_centers_outputs(
    params: VAlignCentersParameters,
    execution: Execution,
) -> VAlignCentersOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VAlignCentersOutputs(
        root=execution.output_file("."),
        transform_matrix=execution.output_file(pathlib.Path(params.get("dset")).name + "_shft.1D"),
        shifted_dset=execution.output_file(params.get("prefix") + "_shft+orig.BRIK") if (params.get("prefix") is not None) else None,
        shifted_child_dsets=execution.output_file(params.get("prefix") + "_child_shft+orig.BRIK") if (params.get("prefix") is not None) else None,
    )
    return ret


def v__align_centers_execute(
    params: VAlignCentersParameters,
    execution: Execution,
) -> VAlignCentersOutputs:
    """
    Moves the center of a dataset (DSET) to the center of a base volume (BASE) and
    optionally creates a transform matrix.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VAlignCentersOutputs`).
    """
    params = execution.params(params)
    cargs = v__align_centers_cargs(params, execution)
    ret = v__align_centers_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__align_centers(
    base: InputPathType,
    dset: InputPathType,
    children: list[InputPathType] | None = None,
    echo: bool = False,
    overwrite: bool = False,
    prefix: str | None = None,
    matrix_only: bool = False,
    matrix_only_no_dset: bool = False,
    no_cp: bool = False,
    center_grid: bool = False,
    center_cm: bool = False,
    center_cm_no_amask: bool = False,
    shift_xform: InputPathType | None = None,
    shift_xform_inv: InputPathType | None = None,
    runner: Runner | None = None,
) -> VAlignCentersOutputs:
    """
    Moves the center of a dataset (DSET) to the center of a base volume (BASE) and
    optionally creates a transform matrix.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        base: Base volume, typically a template. Can also specify RAI\
            coordinates for center alignment.
        dset: Dataset to be aligned to BASE.
        children: Additional datasets (originally in register with DSET) that\
            should be shifted in the same way.
        echo: Echo all commands to terminal for debugging.
        overwrite: Overwrite existing output files.
        prefix: Custom prefix for the result files.
        matrix_only: Only output the transform needed to align the centers\
            without shifting any child volumes.
        matrix_only_no_dset: Like -1Dmat_only, but no datasets are created or\
            changed.
        no_cp: Do not create new data; shift existing ones. Use with caution.
        center_grid: Center is that of the volume's grid (default).
        center_cm: Center is the center of mass of the volume.
        center_cm_no_amask: Like -cm, but with no automask.
        shift_xform: Apply shift translation from a 1D file.
        shift_xform_inv: Apply inverse of shift translation from a 1D file.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VAlignCentersOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__ALIGN_CENTERS_METADATA)
    params = v__align_centers_params(
        base=base,
        dset=dset,
        children=children,
        echo=echo,
        overwrite=overwrite,
        prefix=prefix,
        matrix_only=matrix_only,
        matrix_only_no_dset=matrix_only_no_dset,
        no_cp=no_cp,
        center_grid=center_grid,
        center_cm=center_cm,
        center_cm_no_amask=center_cm_no_amask,
        shift_xform=shift_xform,
        shift_xform_inv=shift_xform_inv,
    )
    return v__align_centers_execute(params, execution)


__all__ = [
    "VAlignCentersOutputs",
    "VAlignCentersParameters",
    "V__ALIGN_CENTERS_METADATA",
    "v__align_centers",
    "v__align_centers_params",
]
