# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__ALIGN_PARTIAL_OBLIQUE_METADATA = Metadata(
    id="d0ac6388c730c43ce7683b59b4069417404eff3d.boutiques",
    name="@align_partial_oblique",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VAlignPartialObliqueParameters = typing.TypedDict('VAlignPartialObliqueParameters', {
    "__STYXTYPE__": typing.Literal["@align_partial_oblique"],
    "base": InputPathType,
    "input": InputPathType,
    "suffix": typing.NotRequired[str | None],
    "keep_tmp": bool,
    "clean": bool,
    "dxyz": typing.NotRequired[float | None],
    "dx": typing.NotRequired[float | None],
    "dy": typing.NotRequired[float | None],
    "dz": typing.NotRequired[float | None],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@align_partial_oblique": v__align_partial_oblique_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@align_partial_oblique": v__align_partial_oblique_outputs,
    }.get(t)


class VAlignPartialObliqueOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__align_partial_oblique(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    aligned_output: OutputPathType
    """Aligned partial coverage T1 weighted dataset"""


def v__align_partial_oblique_params(
    base: InputPathType,
    input_: InputPathType,
    suffix: str | None = None,
    keep_tmp: bool = False,
    clean: bool = False,
    dxyz: float | None = None,
    dx: float | None = None,
    dy: float | None = None,
    dz: float | None = None,
) -> VAlignPartialObliqueParameters:
    """
    Build parameters.
    
    Args:
        base: Reference anatomical full coverage volume.
        input_: Partial coverage T1 weighted non-oblique dataset.
        suffix: Output dataset name is formed by adding SUF to the prefix of\
            the base dataset. The default suffix is _alnd_PartialCoverageObliqueT1.
        keep_tmp: Keep temporary files.
        clean: Clean all temp files, likely left from -keep_tmp option then\
            exit.
        dxyz: Cubic voxel size of output dataset in TLRC space Default MM is 1.
        dx: Size of voxel in the x direction (Right-Left). Default is 1mm.
        dy: Size of voxel in the y direction (Anterior-Posterior). Default is\
            1mm.
        dz: Size of voxel in the z direction (Inferior-Superior). Default is\
            1mm.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@align_partial_oblique",
        "base": base,
        "input": input_,
        "keep_tmp": keep_tmp,
        "clean": clean,
    }
    if suffix is not None:
        params["suffix"] = suffix
    if dxyz is not None:
        params["dxyz"] = dxyz
    if dx is not None:
        params["dx"] = dx
    if dy is not None:
        params["dy"] = dy
    if dz is not None:
        params["dz"] = dz
    return params


def v__align_partial_oblique_cargs(
    params: VAlignPartialObliqueParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@align_partial_oblique")
    cargs.extend([
        "-base",
        execution.input_file(params.get("base"))
    ])
    cargs.extend([
        "-input",
        execution.input_file(params.get("input"))
    ])
    if params.get("suffix") is not None:
        cargs.extend([
            "-suffix",
            params.get("suffix")
        ])
    if params.get("keep_tmp"):
        cargs.append("-keep_tmp")
    if params.get("clean"):
        cargs.append("-clean")
    if params.get("dxyz") is not None:
        cargs.extend([
            "-dxyz",
            str(params.get("dxyz"))
        ])
    if params.get("dx") is not None:
        cargs.extend([
            "-dx",
            str(params.get("dx"))
        ])
    if params.get("dy") is not None:
        cargs.extend([
            "-dy",
            str(params.get("dy"))
        ])
    if params.get("dz") is not None:
        cargs.extend([
            "-dz",
            str(params.get("dz"))
        ])
    return cargs


def v__align_partial_oblique_outputs(
    params: VAlignPartialObliqueParameters,
    execution: Execution,
) -> VAlignPartialObliqueOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VAlignPartialObliqueOutputs(
        root=execution.output_file("."),
        aligned_output=execution.output_file(pathlib.Path(params.get("base")).name + "_alnd_" + pathlib.Path(params.get("input")).name + ".nii.gz"),
    )
    return ret


def v__align_partial_oblique_execute(
    params: VAlignPartialObliqueParameters,
    execution: Execution,
) -> VAlignPartialObliqueOutputs:
    """
    A script to align a full coverage T1 weighted non-oblique dataset to match a
    partial coverage T1 weighted non-oblique dataset. Alignment is done with a
    rotation and shift (6 parameters) transform only.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VAlignPartialObliqueOutputs`).
    """
    params = execution.params(params)
    cargs = v__align_partial_oblique_cargs(params, execution)
    ret = v__align_partial_oblique_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__align_partial_oblique(
    base: InputPathType,
    input_: InputPathType,
    suffix: str | None = None,
    keep_tmp: bool = False,
    clean: bool = False,
    dxyz: float | None = None,
    dx: float | None = None,
    dy: float | None = None,
    dz: float | None = None,
    runner: Runner | None = None,
) -> VAlignPartialObliqueOutputs:
    """
    A script to align a full coverage T1 weighted non-oblique dataset to match a
    partial coverage T1 weighted non-oblique dataset. Alignment is done with a
    rotation and shift (6 parameters) transform only.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        base: Reference anatomical full coverage volume.
        input_: Partial coverage T1 weighted non-oblique dataset.
        suffix: Output dataset name is formed by adding SUF to the prefix of\
            the base dataset. The default suffix is _alnd_PartialCoverageObliqueT1.
        keep_tmp: Keep temporary files.
        clean: Clean all temp files, likely left from -keep_tmp option then\
            exit.
        dxyz: Cubic voxel size of output dataset in TLRC space Default MM is 1.
        dx: Size of voxel in the x direction (Right-Left). Default is 1mm.
        dy: Size of voxel in the y direction (Anterior-Posterior). Default is\
            1mm.
        dz: Size of voxel in the z direction (Inferior-Superior). Default is\
            1mm.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VAlignPartialObliqueOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__ALIGN_PARTIAL_OBLIQUE_METADATA)
    params = v__align_partial_oblique_params(
        base=base,
        input_=input_,
        suffix=suffix,
        keep_tmp=keep_tmp,
        clean=clean,
        dxyz=dxyz,
        dx=dx,
        dy=dy,
        dz=dz,
    )
    return v__align_partial_oblique_execute(params, execution)


__all__ = [
    "VAlignPartialObliqueOutputs",
    "VAlignPartialObliqueParameters",
    "V__ALIGN_PARTIAL_OBLIQUE_METADATA",
    "v__align_partial_oblique",
    "v__align_partial_oblique_params",
]
