# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__COMMAND_GLOBB_METADATA = Metadata(
    id="5f14a5e6156977564d2f36a3dee265f9e274c661.boutiques",
    name="@CommandGlobb",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VCommandGlobbParameters = typing.TypedDict('VCommandGlobbParameters', {
    "__STYXTYPE__": typing.Literal["@CommandGlobb"],
    "program_command": str,
    "output_dir": str,
    "extension": typing.NotRequired[str | None],
    "brick_list": list[str],
})


def dyn_cargs(
    t: str,
) -> typing.Any:
    """
    Get build cargs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build cargs function.
    """
    return {
        "@CommandGlobb": v__command_globb_cargs,
    }.get(t)


def dyn_outputs(
    t: str,
) -> typing.Any:
    """
    Get build outputs function by command type.
    
    Args:
        t: Command type.
    Returns:
        Build outputs function.
    """
    return {
        "@CommandGlobb": v__command_globb_outputs,
    }.get(t)


class VCommandGlobbOutputs(typing.NamedTuple):
    """
    Output object returned when calling `v__command_globb(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_files: OutputPathType
    """Output files generated by the specified program command line."""


def v__command_globb_params(
    program_command: str,
    output_dir: str,
    brick_list: list[str],
    extension: str | None = None,
) -> VCommandGlobbParameters:
    """
    Build parameters.
    
    Args:
        program_command: The entire command line for the program desired. The\
            command is best put between single quotes, do not use the \\ to break a\
            long line within the quotes.
        output_dir: The output directory where the results will be saved.
        brick_list: A list of bricks (or anything) on which the program command\
            will be executed.
        extension: If the program requires a -prefix option, then you can\
            specify the extension which will get appended to the Brick names before\
            +orig.
    Returns:
        Parameter dictionary
    """
    params = {
        "__STYXTYPE__": "@CommandGlobb",
        "program_command": program_command,
        "output_dir": output_dir,
        "brick_list": brick_list,
    }
    if extension is not None:
        params["extension"] = extension
    return params


def v__command_globb_cargs(
    params: VCommandGlobbParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@CommandGlobb")
    cargs.extend([
        "-com",
        params.get("program_command")
    ])
    cargs.extend([
        "-session",
        params.get("output_dir")
    ])
    if params.get("extension") is not None:
        cargs.extend([
            "-newext",
            params.get("extension")
        ])
    cargs.extend([
        "-list",
        *params.get("brick_list")
    ])
    return cargs


def v__command_globb_outputs(
    params: VCommandGlobbParameters,
    execution: Execution,
) -> VCommandGlobbOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VCommandGlobbOutputs(
        root=execution.output_file("."),
        output_files=execution.output_file(params.get("output_dir") + "/*"),
    )
    return ret


def v__command_globb_execute(
    params: VCommandGlobbParameters,
    execution: Execution,
) -> VCommandGlobbOutputs:
    """
    A command-line tool to execute a specified program command line on a list of
    input bricks.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        execution: The execution object.
    Returns:
        NamedTuple of outputs (described in `VCommandGlobbOutputs`).
    """
    params = execution.params(params)
    cargs = v__command_globb_cargs(params, execution)
    ret = v__command_globb_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__command_globb(
    program_command: str,
    output_dir: str,
    brick_list: list[str],
    extension: str | None = None,
    runner: Runner | None = None,
) -> VCommandGlobbOutputs:
    """
    A command-line tool to execute a specified program command line on a list of
    input bricks.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        program_command: The entire command line for the program desired. The\
            command is best put between single quotes, do not use the \\ to break a\
            long line within the quotes.
        output_dir: The output directory where the results will be saved.
        brick_list: A list of bricks (or anything) on which the program command\
            will be executed.
        extension: If the program requires a -prefix option, then you can\
            specify the extension which will get appended to the Brick names before\
            +orig.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VCommandGlobbOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__COMMAND_GLOBB_METADATA)
    params = v__command_globb_params(
        program_command=program_command,
        output_dir=output_dir,
        extension=extension,
        brick_list=brick_list,
    )
    return v__command_globb_execute(params, execution)


__all__ = [
    "VCommandGlobbOutputs",
    "VCommandGlobbParameters",
    "V__COMMAND_GLOBB_METADATA",
    "v__command_globb",
    "v__command_globb_params",
]
